/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl
extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity>
implements IInvoiceReceiveRegistService {
    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "TAX_RECEIVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    @Transactional
    public boolean saveOrUpdate(InvoiceReceiveRegistEntity entity) {
        int invoiceQuantity = 0;
        if (ListUtil.isNotEmpty(entity.getInvoiceReceiveList())) {
            CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String, String> defMap = this.getDefMap((List)defList.getData());
            this.checkPool(entity.getInvoiceReceiveList());
            QueryParam param = new QueryParam();
            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceiveList()) {
                if ("add".equals(poolEntity.getRowState())) {
                    CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    poolEntity.setBillCode((String)billCode.getData());
                    param.getParams().put("invoiceNumber", new Parameter("eq", (Object)poolEntity.getInvoiceNumber()));
                    List list = this.invoiceReceivePoolService.queryList(param);
                    if (ListUtil.isNotEmpty((List)list)) {
                        throw new BusinessException("\u53d1\u7968: \u53f7\u7801\u3010" + poolEntity.getInvoiceNumber() + "\u3011\u5df2\u5b58\u5728\uff01");
                    }
                    BigDecimal taxMny = poolEntity.getTaxMny();
                    String memo = poolEntity.getMemo();
                    List attachIds = poolEntity.getAttachIds();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)poolEntity));
                    poolEntity.setAttachIds(attachIds);
                    poolEntity.setMemo(memo);
                    poolEntity.setTaxMny(taxMny);
                    poolEntity.setId(null);
                    poolEntity.setBillState(0);
                    ++invoiceQuantity;
                } else if (!"del".equals(poolEntity.getRowState())) {
                    param.getParams().put("invoiceNumber", new Parameter("eq", (Object)poolEntity.getInvoiceNumber()));
                    List list = this.invoiceReceivePoolService.queryList(param);
                    if (ListUtil.isNotEmpty((List)list) && ((InvoiceReceivePoolEntity)((Object)list.get(0))).getReceiveBillId() != null && !((InvoiceReceivePoolEntity)((Object)list.get(0))).getReceiveBillId().equals(entity.getId())) {
                        throw new BusinessException("\u53f7\u7801\u3010" + poolEntity.getInvoiceNumber() + "\u3011\u5df2\u5b58\u5728\uff01");
                    }
                    ++invoiceQuantity;
                }
                poolEntity.setInvoiceTypeName(defMap.get(poolEntity.getInvoiceType() + ""));
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
                poolEntity.setCustomerId(entity.getBuyerId());
                poolEntity.setCustomerName(entity.getBuyerName());
                poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setRegist(false);
                poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
                poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
                poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
                poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
                poolEntity.setAuthState(0);
                poolEntity.setDeductionState(0);
                poolEntity.setFlag(0);
            }
        }
        entity.setInvoiceQuantity(invoiceQuantity);
        return super.saveOrUpdateNoES((Object)entity);
    }

    public void checkPool(List<InvoiceReceivePoolEntity> poolList) {
        for (int i = 0; i < poolList.size(); ++i) {
            InvoiceReceivePoolEntity vo = poolList.get(i);
            if ("del".equals(vo.getRowState())) continue;
            for (int j = i + 1; j < poolList.size(); ++j) {
                InvoiceReceivePoolEntity poolVo = poolList.get(j);
                if (!vo.getInvoiceNumber().equals(poolVo.getInvoiceNumber())) continue;
                throw new BusinessException("\u53d1\u7968\u53f7\u7801\u7b2c" + (i + 1) + "\u884c\u548c\u7b2c" + (j + 1) + "\u91cd\u590d");
            }
        }
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }
}

