package com.ejianc.business.taxnew.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;

import java.util.List;

/**
 * 销项发票池
 * 
 * @author generator
 * 
 */
public interface IInvoiceOpenPoolService extends IBaseService<InvoiceOpenPoolEntity> {

    /**
     * 根据注册id删除
     * @param registId
     */
    public void deleteRegistId(Long registId);

    /**
     * 根据登记id查询
     * @param registId
     * @return
     */
    public List<InvoiceOpenPoolEntity> queryRegistById(Long registId);

    List<InvoiceOpenPoolVO> queryList(QueryWrapper<InvoiceOpenPoolEntity> queryWrapper);

    /**
     * 根据登记id批量删
     * @param registIds
     * @return
     */
    public void deleteBatchRegistId(List<Long> registIds);
}
