/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.taxnew.bean.InvoiceDeducApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceDeducBillEntity;
import com.ejianc.business.taxnew.bean.InvoiceDeducBillSubEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplyService;
import com.ejianc.business.taxnew.service.IInvoiceDeducBillService;
import com.ejianc.business.taxnew.service.IInvoiceDeducBillSubService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.vo.InvoiceDeducBillSubVO;
import com.ejianc.business.taxnew.vo.InvoiceDeducBillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invoiceDeducBill"})
public class InvoiceDeducBillController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "tax-deduc-bill-001";
    @Autowired
    private IInvoiceDeducBillService service;
    @Autowired
    private IInvoiceDeducApplyService iInvoiceDeducApplyService;
    @Autowired
    private IInvoiceDeducBillSubService billSubService;
    @Autowired
    private IInvoiceReceivePoolService iInvoiceReceivePoolService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceDeducBillVO> saveOrUpdate(@RequestBody InvoiceDeducBillVO saveorUpdateVO) {
        InvoiceDeducBillEntity entity = (InvoiceDeducBillEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceDeducBillEntity.class));
        boolean isNew = false;
        if (entity.getApplyId() == null) {
            throw new BusinessException("\u7533\u8bf7\u5355id\u3010applyId\u3011\u6ca1\u8d4b\u503c\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            isNew = true;
        }
        Integer actualInvoiceQuantity = 0;
        for (InvoiceDeducBillSubEntity sub : entity.getInvoiceDeducBillSubs()) {
            if (sub.getAuthState() == 0) {
                throw new BusinessException("\u5b58\u5728\u672a\u8ba4\u8bc1\u7684\u53d1\u7968\uff0c\u4ee3\u7801\uff1a\u3010" + sub.getInvoiceCode() + "\u3011\uff0c\u53d1\u7968\u53f7\u7801\uff1a\u3010" + sub.getInvoiceNumber() + "\u3011\uff0c\u8bf7\u8ba4\u8bc1\u540e\u518d\u7ef4\u62a4\u62b5\u6263\u4fe1\u606f\uff01");
            }
            sub.setProjectName(entity.getProjectName());
            sub.setProjectId(entity.getProjectId());
            sub.setOrgId(entity.getOrgId());
            sub.setCode(entity.getCode());
            if (!"\u662f".equals(sub.getCanDeduc())) continue;
            Integer n = actualInvoiceQuantity;
            Integer n2 = actualInvoiceQuantity = Integer.valueOf(actualInvoiceQuantity + 1);
        }
        entity.setApplyInvoiceQuantity(entity.getInvoiceDeducBillSubs().size());
        entity.setActualInvoiceQuantity(actualInvoiceQuantity);
        this.service.saveOrUpdateNoES((Object)entity);
        if (isNew) {
            InvoiceDeducApplyEntity applyEntity = (InvoiceDeducApplyEntity)((Object)this.iInvoiceDeducApplyService.selectById(entity.getApplyId()));
            applyEntity.setDeducBillId(entity.getId());
            this.iInvoiceDeducApplyService.saveOrUpdate((Object)applyEntity);
        }
        InvoiceDeducBillVO vo = (InvoiceDeducBillVO)BeanMapper.map((Object)((Object)entity), InvoiceDeducBillVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceDeducBillVO> queryDetail(Long id) {
        InvoiceDeducBillEntity entity = (InvoiceDeducBillEntity)((Object)this.service.selectById(id));
        InvoiceDeducBillVO vo = (InvoiceDeducBillVO)BeanMapper.map((Object)((Object)entity), InvoiceDeducBillVO.class);
        for (InvoiceDeducBillSubVO sub : vo.getInvoiceDeducBillSubs()) {
            InvoiceReceivePoolEntity invoice = (InvoiceReceivePoolEntity)((Object)this.iInvoiceReceivePoolService.selectById(sub.getInvoiceId()));
            sub.setAuthState(invoice.getAuthState());
            sub.setAuthDescription(invoice.getAuthState() == 0 ? "\u672a\u8ba4\u8bc1" : (invoice.getAuthState() == 1 ? "\u8ba4\u8bc1\u6210\u529f" : "\u8ba4\u8bc1\u5931\u8d25"));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceDeducBillVO> vos) {
        vos.forEach(vo -> {
            InvoiceDeducBillEntity entity = (InvoiceDeducBillEntity)((Object)((Object)this.service.selectById(vo.getId())));
            InvoiceDeducApplyEntity applyEntity = (InvoiceDeducApplyEntity)((Object)((Object)this.iInvoiceDeducApplyService.selectById(entity.getApplyId())));
            applyEntity.setDeducBillId(null);
            this.iInvoiceDeducApplyService.saveOrUpdate((Object)applyEntity);
        });
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducBillVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyPersonName");
        fuzzyFields.add("memo");
        fuzzyFields.add("processPersonName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceDeducBillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySubList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducBillSubVO>> querySubList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("invoiceCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("invoiceNumber");
        fuzzyFields.add("memo");
        fuzzyFields.add("content");
        fuzzyFields.add("thisMemo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.billSubService.queryPage(param);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceDeducBillSubVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"excelSubExport"})
    public void excelSubExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("invoiceCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("invoiceNumber");
        fuzzyFields.add("memo");
        fuzzyFields.add("content");
        fuzzyFields.add("thisMemo");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.billSubService.queryPage(queryParam);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceDeducBillSubVO.class));
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceDeducBillSubVO r = (InvoiceDeducBillSubVO)BeanMapper.map((Object)pool, InvoiceDeducBillSubVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                switch (r.getAuthState()) {
                    case 0: {
                        r.setAuthStateName("\u672a\u8ba4\u8bc1");
                        break;
                    }
                    case 1: {
                        r.setAuthStateName("\u8ba4\u8bc1\u6210\u529f");
                        break;
                    }
                    case 2: {
                        r.setAuthStateName("\u8ba4\u8bc1\u5931\u8d25");
                        break;
                    }
                }
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("deducBillPool-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("applyPersonName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("memo");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("processPersonName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(e -> {
                InvoiceDeducBillVO r = (InvoiceDeducBillVO)BeanMapper.map((Object)e, InvoiceDeducBillVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("InvoiceDeducBill-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInvoiceDeducBillData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducBillVO>> refInvoiceDeducBillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceDeducBillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

