package com.ejianc.business.taxnew.service.impl;

import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 收票登记
 * 
 * @author generator
 * 
 */
@Service("invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity> implements IInvoiceReceiveRegistService{

    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "TAX_RECEIVE";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;

    @Autowired
    private IDefdocApi defdocApi;

    /**
     * 增加或修改对象
     *
     * @param entity 实体对象
     */
    @Override
    @Transactional
    public boolean saveOrUpdate(InvoiceReceiveRegistEntity entity) {
        int invoiceQuantity = 0 ; // 发票数量
        if(ListUtil.isNotEmpty(entity.getInvoiceReceiveList())){
            CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String,String> defMap =getDefMap(defList.getData());

            checkPool(entity.getInvoiceReceiveList());
            QueryParam param = new QueryParam();
            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceiveList()) {
                if("add".equals(poolEntity.getRowState())){
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if(billCode.isSuccess()) {
                        poolEntity.setBillCode(billCode.getData());
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    param.getParams().put("invoiceNumber",new Parameter(QueryParam.EQ,poolEntity.getInvoiceNumber()));
                    List<InvoiceReceivePoolEntity> list = invoiceReceivePoolService.queryList(param);
                    if(ListUtil.isNotEmpty(list)){
                        throw new BusinessException("发票: 号码【"+poolEntity.getInvoiceNumber()+"】已存在！");
                    }
                    BigDecimal taxMny = poolEntity.getTaxMny();
                    String memo = poolEntity.getMemo();
                    List<Long> attachIds = poolEntity.getAttachIds();
                    BeanUtils.copyProperties(entity,poolEntity);
                    poolEntity.setAttachIds(attachIds);
                    poolEntity.setMemo(memo);
                    poolEntity.setTaxMny(taxMny);
                    poolEntity.setId(null);
                    poolEntity.setBillState(0);
                    invoiceQuantity++;
                }else {
                    if(!"del".equals(poolEntity.getRowState())){
                        param.getParams().put("invoiceNumber",new Parameter(QueryParam.EQ,poolEntity.getInvoiceNumber()));
                        List<InvoiceReceivePoolEntity> list = invoiceReceivePoolService.queryList(param);
                        if(ListUtil.isNotEmpty(list) && list.get(0).getReceiveBillId()!=null && !list.get(0).getReceiveBillId().equals(entity.getId())){
                            throw new BusinessException("号码【"+poolEntity.getInvoiceNumber()+"】已存在！");
                        }
                        invoiceQuantity++;
                    }
                }
                poolEntity.setInvoiceTypeName(defMap.get(poolEntity.getInvoiceType()+""));
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
                poolEntity.setCustomerId(entity.getBuyerId());
                poolEntity.setCustomerName(entity.getBuyerName());
                poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setRegist(false);
                poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
                poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
                poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
                poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
                poolEntity.setAuthState(0);
                poolEntity.setDeductionState(0);
                poolEntity.setFlag(0);
                if(entity.getPurchaseType()!= null){
                    poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
                }
                if(entity.getDependOnProject()!= null){
                    poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
                }
                if(entity.getReceiveType() != null){
                    poolEntity.setContractType(String.valueOf(entity.getReceiveType()));
                }
                if(poolEntity.getContractId()!= null ){
                    poolEntity.setType(1);
                }else{
                    poolEntity.setType(2);
                }
            }
        }
        entity.setInvoiceQuantity(invoiceQuantity);
        return super.saveOrUpdateNoES(entity);
    }

    /**
     * 验证发票提交中的发票是否存在重复
     * @param poolList
     */
    public void checkPool(List<InvoiceReceivePoolEntity> poolList){
        for (int i = 0; i < poolList.size(); i++) {
            InvoiceReceivePoolEntity vo = poolList.get(i);
            if(!"del".equals(vo.getRowState())){
                for (int j = i+1; j < poolList.size(); j++) {
                    InvoiceReceivePoolEntity poolVo = poolList.get(j);
                    if (vo.getInvoiceNumber().equals(poolVo.getInvoiceNumber())) {
                        throw new BusinessException("发票号码第" + (i+1) + "行和第" + (j+1) + "重复");
                    }
                }
            }
        }
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }
}
