package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.finance.vo.ParamsCheckDsSpreadVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.tax.mapper.InvoiceOpenMapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

/**
 * 开票登记
 *
 * @author generator
 *
 */
@Service("invoiceOpenRegistService")
public class InvoiceOpenRegistServiceImpl extends BaseServiceImpl<InvoiceOpenRegistMapper, InvoiceOpenRegistEntity> implements IInvoiceOpenRegistService{
    @Autowired
    private IInvoiceOpenPoolService invoiceOpenPoolService;
    @Autowired
    private IInvoiceOpenApplyService invoiceOpenApplyService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Lock lock = new ReentrantLock(true);
    private static final String BILL_CODE = "tax-open-regist-001";
    private static final String BILL_POOL_CODE = "tax-open-pool-001";

    // 开票登记 管控参数
    private static final String CHEC_INVOICE_OPEN_CODE = "P-jyh01v35";
    //系统是否开启专业分包预算标志
    private static final String SYS_IS_PROBUDGET_CODE = "P-D76yn127";

    @Autowired
    private InvoiceOpenRegistMapper invoiceOpenRegistMapper;

    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IIncomeContractApi iIncomeContractApi;
    @Autowired
    private InvoiceOpenMapper invoiceOpenMapper;
    /**
     * 根据开票申请保存到开票登记
     * @param invoiceOpenApplyEntity
     */
    @Transactional
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("dr","0");
        queryWrapper.eq("apply_id" ,invoiceOpenApplyEntity.getId());
        List<InvoiceOpenApplyEntity> invoiceOpenApplyList =super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(invoiceOpenApplyList)){
            throw new BusinessException("不可以重复提交");
        }
        InvoiceOpenRegistEntity registEntity = new InvoiceOpenRegistEntity();
        registEntity.setApplyCode(invoiceOpenApplyEntity.getCode());
        registEntity.setApplyDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setApplyer(invoiceOpenApplyEntity.getApplyer());
        registEntity.setApplyerId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setApplyMny(invoiceOpenApplyEntity.getApplyMny());
        registEntity.setApplyMnyTaxChn(invoiceOpenApplyEntity.getApplyMnyTaxChn());
        registEntity.setApplyMnyTax(invoiceOpenApplyEntity.getApplyMnyTax());
        registEntity.setBuyerAddrPhone(invoiceOpenApplyEntity.getBuyerAddrPhone());
        registEntity.setBuyerBankAccount(invoiceOpenApplyEntity.getBuyerBankAccount());
        registEntity.setBuyerId(invoiceOpenApplyEntity.getBuyerId());
        registEntity.setBuyer(invoiceOpenApplyEntity.getBuyer());
        registEntity.setApplyId(invoiceOpenApplyEntity.getId());
        registEntity.setBuyerTaxId(invoiceOpenApplyEntity.getBuyerTaxId());
        registEntity.setContractId(invoiceOpenApplyEntity.getContractId());
        registEntity.setContractName(invoiceOpenApplyEntity.getContractName());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        //registEntity.setInvoiceType(Integer.valueOf(invoiceOpenApplyEntity.getInvoiceTypes()));
        registEntity.setMoneyType(invoiceOpenApplyEntity.getMoneyType());
        registEntity.setMoneyTypeId(invoiceOpenApplyEntity.getMoneyTypeId());
        registEntity.setOrgId(invoiceOpenApplyEntity.getOrgId());
        registEntity.setOrgName(invoiceOpenApplyEntity.getOrgName());
        registEntity.setProjectId(invoiceOpenApplyEntity.getProjectId());
        registEntity.setProjectName(invoiceOpenApplyEntity.getProjectName());
        registEntity.setSellerId(invoiceOpenApplyEntity.getSellerId());
        registEntity.setSeller(invoiceOpenApplyEntity.getSeller());
        registEntity.setSellerTaxCode(invoiceOpenApplyEntity.getSellerTaxCode());
        registEntity.setSellerAddrPhone(invoiceOpenApplyEntity.getSellerAddrPhone());
        registEntity.setSellerBankAccount(invoiceOpenApplyEntity.getSellerBankAccount());
        registEntity.setTax(invoiceOpenApplyEntity.getTax());
        registEntity.setRegistOpenType(1);//有申请
        registEntity.setRegistState(0);//待登记
        registEntity.setHasContract(invoiceOpenApplyEntity.getHasContract()); //是否有合同
        registEntity.setNowContractMny(invoiceOpenApplyEntity.getNowContractMny());
        registEntity.setTotalQuoteMny(invoiceOpenApplyEntity.getTotalQuoteMny());
        registEntity.setTotalOpenApplyMnyTax(invoiceOpenApplyEntity.getTotalOpenApplyMnyTax());
        registEntity.setTotalOpenMny(invoiceOpenApplyEntity.getTotalOpenMny());
        registEntity.setTotalBackMnyTax(invoiceOpenApplyEntity.getTotalBackMnyTax());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        String billCode =getBillCode(BILL_CODE);
        registEntity.setCode(billCode);
        super.save(registEntity);
    }

    /**
     * 保存（同时添加到发票池中）
     * @param invoiceOpenRegistEntity
     */
    @Transactional
    public InvoiceOpenRegistEntity saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        lock.lock();
        try {
            List<InvoiceOpenPoolEntity> invoiceOpenPoolEntities = new ArrayList<InvoiceOpenPoolEntity>();
            if(CollectionUtils.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())){

                CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
                Map<String,String> defMap =getDefMap(defList.getData());
                List<InvoiceOpenPoolEntity> invoiceOpenPoolList =invoiceOpenRegistEntity.getContractItemList();
                checkPool(invoiceOpenPoolList);
                int invoiceAuantity = invoiceOpenPoolList.size();

                for (InvoiceOpenPoolEntity entity:invoiceOpenPoolList){
                    if("del".equals(entity.getRowState())){
                        invoiceAuantity--;
                    }
                }

                if(invoiceOpenRegistEntity.getRegistDate() == null){
                    invoiceOpenRegistEntity.setRegistDate(new Date());
                }

                invoiceOpenRegistEntity.setInvoiceAuantity(invoiceAuantity);
                invoiceOpenRegistEntity.setRegistState(0);

                //后期加参数在控制
                if (invoiceOpenRegistEntity.getId() != null){
                    //有开票申请
                    super.updateById(invoiceOpenRegistEntity);

                }else{

                    String billCode =getBillCode(BILL_CODE);
                    invoiceOpenRegistEntity.setCode(billCode);
                    //无开票申请直接保存
                    super.save(invoiceOpenRegistEntity);
                }

                for (InvoiceOpenPoolEntity pool : invoiceOpenPoolList){
                    if(invoiceOpenRegistEntity.getApplyId() != null){
                        pool.setOpenApplyType(1);//有申请
                        pool.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
                        pool.setApplyId(invoiceOpenRegistEntity.getApplyId());
                        pool.setApplyMnyTax(invoiceOpenRegistEntity.getApplyMnyTax());
                    }

                    pool.setType(invoiceOpenRegistEntity.getHasContract());
                    pool.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
                    pool.setContractId(invoiceOpenRegistEntity.getContractId());
                    pool.setContractName(invoiceOpenRegistEntity.getContractName());
                    pool.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
                    pool.setCustomerName(invoiceOpenRegistEntity.getBuyer());
                    pool.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
                    pool.setEmployeeId(invoiceOpenRegistEntity.getRegistUserId());
                    pool.setEmployeeName(invoiceOpenRegistEntity.getRegistUserName());
                    pool.setOrgId(invoiceOpenRegistEntity.getOrgId());
                    pool.setOrgName(invoiceOpenRegistEntity.getOrgName());
                    pool.setProjectId(invoiceOpenRegistEntity.getProjectId());
                    pool.setProjectName(invoiceOpenRegistEntity.getProjectName());
                    pool.setRegistId(invoiceOpenRegistEntity.getId());
                    pool.setRegistCode(invoiceOpenRegistEntity.getCode());
                    pool.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
                    pool.setSupplierName(invoiceOpenRegistEntity.getSeller());
                    pool.setSupplierId(invoiceOpenRegistEntity.getSellerId());
                    pool.setType(invoiceOpenRegistEntity.getHasContract());
                    pool.setMoneyTypeId(invoiceOpenRegistEntity.getMoneyTypeId());
                    pool.setBuyerAddrPhone(invoiceOpenRegistEntity.getBuyerAddrPhone());
                    pool.setBuyerBankAccount(invoiceOpenRegistEntity.getBuyerBankAccount());
                    pool.setSellerAddrPhone(invoiceOpenRegistEntity.getSellerAddrPhone());
                    pool.setSellerBankAccount(invoiceOpenRegistEntity.getSellerBankAccount());
                    pool.setInvoiceTypeName(defMap.get(pool.getInvoiceType()+""));
                    pool.setRegist(0); //未生效
                    if (StringUtils.isNotEmpty(pool.getRowState())  && "del".equals(pool.getRowState())){
                        invoiceOpenPoolService.removeById(pool.getId());
                    }else if(StringUtils.isEmpty(pool.getRowState())  || "edit".equals(pool.getRowState())){
                        invoiceOpenPoolService.updateById(pool);
                        invoiceOpenPoolEntities.add(pool);
                    }else if (StringUtils.isNotEmpty(pool.getRowState())  && "add".equals(pool.getRowState())){
                        String billCode =getBillCode(BILL_POOL_CODE);
                        pool.setBillCode(billCode);
                        invoiceOpenPoolService.save(pool);
                        invoiceOpenPoolEntities.add(pool);
                    }
                }

                invoiceOpenRegistEntity.setContractItemList(invoiceOpenPoolEntities);

            }else{
                throw new BusinessException("发票信息不能为空");
            }

        }finally {
            lock.unlock(); //释放锁
        }

        return invoiceOpenRegistEntity;
    }

    /**
     * 获取billCode
     * @return
     */
    public String getBillCode(String code){
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            return billCode.getData();
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    /**
     * 根据id查询带出 发票池数据
     * @param id
     * @return
     */
    public InvoiceOpenRegistEntity selectByIdAll(Long id) {
        InvoiceOpenRegistEntity entity =this.getById(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("regist_id" ,id);
        queryWrapper.eq("dr" ,0);
        List<InvoiceOpenPoolEntity> list =invoiceOpenPoolService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            entity.setContractItemList(list);
        }
        return entity;
    }

    /**
     * 根据申请id查询一条数据
     * @param applyId
     * @return
     */
    public InvoiceOpenRegistEntity selectOpenRegistByApplyId(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("apply_id" ,applyId);
        InvoiceOpenRegistEntity entity =invoiceOpenRegistMapper.selectOne(queryWrapper);
        if(entity != null){
            QueryParam param = new QueryParam();
            param.getParams().put("registId",new Parameter(QueryParam.EQ,entity.getId()));
            List<InvoiceOpenPoolEntity> list =invoiceOpenPoolService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                entity.setContractItemList(list);
            }
        }
        return entity;
    }

    /**
     * 处理Excel日期格式问题
     * @param date
     * @return
     */
    public String excelDoubleToDate(String date) {
        if(date.length() == 5){
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date tDate = DoubleToDate(Double.parseDouble(date));
                return sdf.format(tDate);
            }catch (Exception e){
                e.printStackTrace();
                return date;
            }
        }
        return date;
    }

    /**
     * 根据合同id统计发票金额
     * @param contractId
     * @return
     */
    public Map<String, BigDecimal> selectSumInvoiceMny(Long contractId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<InvoiceOpenRegistEntity> query = new QueryWrapper<InvoiceOpenRegistEntity>();
        query.select("  sum(invoice_mny) as totalInvoiceMny ");
        query.eq("contract_id", contractId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);
        if(null != data) {
            resp.put("totalInvoiceMny", null != data.get("totalInvoiceMny") ? new BigDecimal(data.get("totalInvoiceMny").toString()) :  BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalInvoiceMny", BigDecimal.ZERO);
        }
        return resp;
    }

    //解析Excel日期格式
    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000; //系统时区偏移 1900/1/1 到 1970/1/1 的 25569 天
        tDate.setTime((long) ((dVal - 25569) * 24 * 3600 * 1000 + localOffset));
        return tDate;
    }

    /**
     * 验证发票是否重复
     * @param poolList
     * @return
     */
    public void checkPool(List<InvoiceOpenPoolEntity> poolList){
        List<String> invoiceNumberParamList = new ArrayList<>();
        for (int i = 0; i < poolList.size(); i++) {
            InvoiceOpenPoolEntity vo = poolList.get(i);
            if("add".equals(vo.getRowState()) || "edit".equals(vo.getRowState())){
                invoiceNumberParamList.add(vo.getInvoiceNumber());
                for (int j = i+1; j < poolList.size(); j++) {
                    InvoiceOpenPoolEntity poolVo = poolList.get(j);
                    if (vo.getInvoiceNumber().equals(poolVo.getInvoiceNumber())) {
                        throw new BusinessException("发票号码第" + (i+1) + "行和第" + (j+1) + "重复");
                    }
                }
            }
        }

        if(CollectionUtils.isNotEmpty(invoiceNumberParamList)){
            checkInvoiceNumber(poolList,invoiceNumberParamList);
        }
    }

    /**
     * 删除
     * @param vos
     * @return
     */
    @Transactional
    public CommonResponse<String> delete(List<InvoiceOpenRegistVO> vos) {
        List<Long> ids = vos.stream().map(InvoiceOpenRegistVO::getId).collect(Collectors.toList());
        QueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("dr", 1,3);
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.in("regist_id", ids);
        List<InvoiceOpenPoolVO> list = invoiceOpenPoolService.queryList(queryWrapper);
        if(list!=null&&list.size()>0){
            String message = "";
            List<InvoiceOpenRegistEntity> entitys = (List<InvoiceOpenRegistEntity>) this.listByIds(list.stream().map(InvoiceOpenPoolVO::getRegistId).collect(Collectors.toList()));
            for(InvoiceOpenRegistEntity entity : entitys){
                if(message.length()>0){
                    message += ("、" + entity.getCode());
                }else{
                    message += entity.getCode();
                }
            }
            if(message.length()>0){
                return CommonResponse.error("以下登记："+message+"存在发票数据，不能删除！！！");
            }
        }

        QueryWrapper<InvoiceOpenRegistEntity> query = new QueryWrapper<>();
        query.eq("dr", 0);
        query.in("id", ids);
        List<InvoiceOpenRegistEntity> registList = super.list(query);
        List<Long> applyIds = registList.stream().map(InvoiceOpenRegistEntity::getApplyId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(registList)){
            UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
            wrapper.in("id",applyIds);
            wrapper.set("open_type",0);//改成为登记状态
            invoiceOpenApplyService.update(wrapper);


        }

        if(CollectionUtils.isNotEmpty(ids)){
            UpdateWrapper<InvoiceOpenRegistEntity> wrapper = new UpdateWrapper<InvoiceOpenRegistEntity>();
            wrapper.in("id",ids);
            wrapper.set("regist_state",0);
            this.update(wrapper);
        }

        invoiceOpenPoolService.deleteBatchRegistId(ids);
        removeByIds(ids);
        return CommonResponse.success("删除登记成功");
    }

    @Override
    public List<InvoiceOpenRegistVO> querylist(QueryWrapper<InvoiceOpenRegistEntity> queryWrapper) {
        List<InvoiceOpenRegistEntity> list = this.list(queryWrapper);
        return BeanMapper.mapList(list, InvoiceOpenRegistVO.class);
    }


    /**
     * 查询发票号码
     * @param poolList
     * @param invoiceNumberParamList
     */
    public void checkInvoiceNumber(List<InvoiceOpenPoolEntity> poolList,List<String> invoiceNumberParamList){
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in("invoice_number",invoiceNumberParamList);
        queryWrapper.eq("dr",0);
        queryWrapper.in("org_id",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        List<InvoiceOpenPoolEntity> openPoolEntityList =invoiceOpenPoolService.list(queryWrapper);
        Map<String, InvoiceOpenPoolEntity> poolMap = new HashMap<>();

        for(InvoiceOpenPoolEntity entity:poolList){
            if("add".equals(entity.getRowState()) || "edit".equals(entity.getRowState())){
                poolMap.put(entity.getInvoiceNumber(),entity);
            }
        }

        List<InvoiceOpenPoolEntity> restList = new LinkedList<>();
        for(InvoiceOpenPoolEntity poolEntity:openPoolEntityList){
            if(poolMap.containsKey(poolEntity.getInvoiceNumber())){
                restList.add(poolEntity);
            }
        }

        if(CollectionUtils.isNotEmpty(restList)){
            for (InvoiceOpenPoolEntity e:restList){
                InvoiceOpenPoolEntity v =poolMap.get(e.getInvoiceNumber());
                if(v.getId() != null){
                    if(!v.getId().equals(e.getId())){
                        throw new BusinessException("发票号码"+e.getInvoiceNumber()+"已经存在");
                    }
                }else{
                    throw new BusinessException("发票号码"+e.getInvoiceNumber()+"已经存在");
                }
            }
        }

    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    @Override
    public ParamsCheckSpreadVO checkParams(Long contractId, BigDecimal appMoney) {
        // 初始化返回参数
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        List<ParamsCheckDsSpreadVO> checkDsVOS = new ArrayList<>();
        String[] paramsArray = {"none", "warn", "alert"};
        paramsCheckVO.setWarnType(paramsArray[0]);

        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(SYS_IS_PROBUDGET_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO data = byCode.getData();
            String valueData = data.getValueData();
            if (!"1".equals(valueData)) {
                logger.info("未读取到费率配置参数！"+contractId);
                return paramsCheckVO;
            }
        }else{
            logger.info("非世纪阳光！"+contractId);
            return paramsCheckVO;
        }

        // 管理费率
        BigDecimal manageRate = BigDecimal.ZERO;
        // 累计金额
        BigDecimal oldSumMoney = BigDecimal.ZERO;
        // 合同总金额
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        // 临时值，用于格式化费率
        BigDecimal temp = new BigDecimal(100);

        CommonResponse<BillParamVO> configCode = paramConfigApi.getBillParamByCode(CHEC_INVOICE_OPEN_CODE);
        if(configCode.isSuccess() && null != configCode.getData()){
            paramsCheckVO.setWarnType(paramsArray[configCode.getData().getControlType()]);
            manageRate = configCode.getData().getRoleValue();
        }else{
            logger.info("未读取到费率配置参数！"+CHEC_INVOICE_OPEN_CODE);
            return paramsCheckVO;
        }
        // 获取合同信息
        CommonResponse<ContractVo> contractVoCommonResponse = iIncomeContractApi.queryDetail(contractId);
        if(contractVoCommonResponse.isSuccess() && null != contractVoCommonResponse.getData() && null != contractVoCommonResponse.getData().getContractTaxMny()){
            contractTaxMny = contractVoCommonResponse.getData().getContractTaxMny();
        }
        // 累计金额
        BigDecimal sumMoneyByContractId = invoiceOpenMapper.getSumMoneyByContractId(contractId);
        if(null != sumMoneyByContractId){
            oldSumMoney = sumMoneyByContractId;
        }
        BigDecimal manageMoney = contractTaxMny.multiply(manageRate).divide(temp);
        BigDecimal sumMoney = oldSumMoney.add(appMoney);
        BigDecimal subMoney = sumMoney.subtract(manageMoney);
        if(sumMoney.compareTo(manageMoney) > 0){
            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
            paramsCheckDsVO.setWarnItem("销项发票超开");
            paramsCheckDsVO.setWarnName("开票登记金额大于施工合同金额");
            paramsCheckDsVO.setContent("本次开票登记金额："+appMoney.setScale(2, BigDecimal.ROUND_HALF_UP)+"，施工合同金额*"+manageRate.setScale(2, BigDecimal.ROUND_HALF_UP)+"%："+manageMoney.setScale(2, BigDecimal.ROUND_HALF_UP)+
                    "。超出金额："+subMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
            checkDsVOS.add(paramsCheckDsVO);
            paramsCheckVO.setDataSource(checkDsVOS);
        }
        return paramsCheckVO;
    }
}
