/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.sub.api.ISubContractInvoiceReceiveApi;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceReceive")
public class InvoiceReceiveBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private ISubContractInvoiceReceiveApi subContractInvoiceReceiveApi;
    @Autowired
    private IInvoiceReceiveService invoiceReceiveService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity entity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveService.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("invoiceNumber", new Parameter("eq", (Object)entity.getInvoiceNumber()));
        List list = this.invoiceReceiveService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity entity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveService.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("invoiceNumber", new Parameter("eq", (Object)entity.getInvoiceNumber()));
        List list = this.invoiceReceiveService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u6536\u7968\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity invoiceReceiveEntity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveService.selectById(billId));
        if (null != invoiceReceiveEntity.getContractId()) {
            if (invoiceReceiveEntity.getContractType().equals("1")) {
                CommonResponse stringCommonResponse = this.subContractInvoiceReceiveApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (stringCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                }
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("2")) {
                CommonResponse stringCommonResponse = this.equipmentContractApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (stringCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                }
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("3")) {
                CommonResponse stringCommonResponse = this.equipmentContractApi.rentAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (stringCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                }
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("4")) {
                this.logger.info("\u8fdb\u5165\u6536\u7968\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199-\u7269\u8d44\u91c7\u8d2d--- billId:" + billId + "  state:" + state);
                return CommonResponse.success();
            }
            if (invoiceReceiveEntity.getContractType().equals("5")) {
                this.logger.info("\u8fdb\u5165\u6536\u7968\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199-\u7269\u8d44\u79df\u8d41--- billId:" + billId + "  state:" + state);
                return CommonResponse.success();
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u6536\u7968\u64a4\u56de\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity invoiceReceiveEntity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveService.selectById(billId));
        if (null != invoiceReceiveEntity.getContractId()) {
            if (invoiceReceiveEntity.getContractType().equals("1")) {
                CommonResponse jsonObjectCommonResponse = this.subContractInvoiceReceiveApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                }
                return CommonResponse.error((String)"\u64a4\u56de\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("2")) {
                CommonResponse jsonObjectCommonResponse = this.equipmentContractApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                }
                return CommonResponse.error((String)"\u64a4\u56de\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("3")) {
                CommonResponse jsonObjectCommonResponse = this.equipmentContractApi.rentAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny());
                if (jsonObjectCommonResponse.isSuccess()) {
                    return CommonResponse.success();
                }
                return CommonResponse.error((String)"\u64a4\u56de\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("4")) {
                this.logger.info("\u8fdb\u5165\u6536\u7968\u64a4\u56de\u540e\u56de\u5199-\u7269\u8d44\u91c7\u8d2d--- billId:" + billId + "  state:" + state);
                return CommonResponse.success();
            }
            if (invoiceReceiveEntity.getContractType().equals("5")) {
                this.logger.info("\u8fdb\u5165\u6536\u7968\u64a4\u56de\u540e\u56de\u5199-\u7269\u8d44\u79df\u8d41--- billId:" + billId + "  state:" + state);
                return CommonResponse.success();
            }
        }
        return CommonResponse.success();
    }
}

