package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceOpenPoolMapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 销项发票池
 * 
 * @author generator
 * 
 */
@Service("invoiceOpenPoolService")
public class InvoiceOpenPoolServiceImpl extends BaseServiceImpl<InvoiceOpenPoolMapper, InvoiceOpenPoolEntity> implements IInvoiceOpenPoolService{
     @Autowired
     private InvoiceOpenPoolMapper invoiceOpenPoolMapper;
     @Autowired
     private InvoiceOpenRegistMapper invoiceOpenRegistMapper;
     @Autowired
     private IDefdocApi defdocApi;
     @Autowired
     private IBillCodeApi billCodeApi;

     private final String configCode = "TAX_OPEN";
    /**
     * 根据注册id删除
     * @param registId
     */
    public void deleteRegistId(Long registId) {
        QueryWrapper<InvoiceOpenPoolEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("regist_id", registId);
        invoiceOpenPoolMapper.delete(deleteWrapper);
    }

    @Override
    public List<InvoiceOpenPoolEntity> queryRegistById(Long registId) {
        QueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("regist_id", registId);
        queryWrapper.eq("dr","0");
        return invoiceOpenPoolMapper.selectList(queryWrapper);
    }

    @Override
    public List<InvoiceOpenPoolVO> queryList(QueryWrapper<InvoiceOpenPoolEntity> queryWrapper) {
        List<InvoiceOpenPoolEntity> list = this.list(queryWrapper);
        return BeanMapper.mapList(list, InvoiceOpenPoolVO.class);
    }

    @Override
    public void deleteBatchRegistId(List<Long> registIds) {
        QueryWrapper<InvoiceOpenPoolEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.in("regist_id", registIds);
        invoiceOpenPoolMapper.delete(deleteWrapper);
    }

    @Override
    public void createSave(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        QueryWrapper<InvoiceOpenRegistEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("apply_id",invoiceOpenApplyEntity.getId());
        queryWrapper.eq("dr",0);
        List<InvoiceOpenRegistEntity> invoiceOpenRegistEntities = invoiceOpenRegistMapper.selectList(queryWrapper);
        System.out.println("================");
        System.out.println(invoiceOpenRegistEntities.size());
        if(invoiceOpenRegistEntities.size()==1){
            InvoiceOpenRegistEntity invoiceOpenRegistEntity = invoiceOpenRegistEntities.get(0);
            InvoiceOpenPoolEntity pool = new InvoiceOpenPoolEntity();
            pool.setOpenApplyType(1);//有申请
            pool.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
            pool.setApplyId(invoiceOpenRegistEntity.getApplyId());
            pool.setApplyMnyTax(invoiceOpenRegistEntity.getApplyMnyTax());
            pool.setType(invoiceOpenRegistEntity.getHasContract());
            pool.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
            pool.setContractId(invoiceOpenRegistEntity.getContractId());
            pool.setContractName(invoiceOpenRegistEntity.getContractName());
            pool.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
            pool.setCustomerName(invoiceOpenRegistEntity.getBuyer());
            pool.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
            pool.setEmployeeId(invoiceOpenRegistEntity.getRegistUserId());
            pool.setEmployeeName(invoiceOpenRegistEntity.getRegistUserName());
            pool.setOrgId(invoiceOpenRegistEntity.getOrgId());
            pool.setOrgName(invoiceOpenRegistEntity.getOrgName());
            pool.setProjectId(invoiceOpenRegistEntity.getProjectId());
            pool.setProjectName(invoiceOpenRegistEntity.getProjectName());
            pool.setRegistId(invoiceOpenRegistEntity.getId());
            pool.setRegistCode(invoiceOpenRegistEntity.getCode());
            pool.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
            pool.setSupplierName(invoiceOpenRegistEntity.getSeller());
            pool.setSupplierId(invoiceOpenRegistEntity.getSellerId());
            pool.setType(invoiceOpenRegistEntity.getHasContract());
            pool.setMoneyTypeId(invoiceOpenRegistEntity.getMoneyTypeId());
            pool.setBuyerAddrPhone(invoiceOpenRegistEntity.getBuyerAddrPhone());
            pool.setBuyerBankAccount(invoiceOpenRegistEntity.getBuyerBankAccount());
            pool.setSellerAddrPhone(invoiceOpenRegistEntity.getSellerAddrPhone());
            pool.setSellerBankAccount(invoiceOpenRegistEntity.getSellerBankAccount());

            CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String,String> defMap =getDefMap(defList.getData());
            pool.setInvoiceType(invoiceOpenApplyEntity.getInvoiceType());
            pool.setInvoiceTypeName(defMap.get(pool.getInvoiceType()+""));
            pool.setRegist(0); //未生效
            pool.setInvoiceCode(getBillCode(configCode));
            pool.setInvoiceNumber(getBillCode(configCode));
            pool.setInvoiceDate(new Date());
            pool.setInvoiceMny(invoiceOpenApplyEntity.getNoTaxMoney()); // 发票金额（不含税）
            pool.setTaxMny(invoiceOpenApplyEntity.getTaxAmount()); // 税额
            pool.setInvoiceTaxMny(invoiceOpenApplyEntity.getApplyMnyTax()); // 价税合计apply_mny_tax
            invoiceOpenPoolMapper.insert(pool);
        }
    }
    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }
    /**
     * 获取billCode
     * @return
     */
    public String getBillCode(String code){
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            return billCode.getData();
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }
}
