package com.ejianc.business.taxnew.controller;

import java.io.Serializable;

import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.vo.InvoiceOpenApplyVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 开票申请
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("invoiceOpenApply")
public class InvoiceOpenApplyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IInvoiceOpenApplyService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IInvoiceOpenRegistService iInvoiceOpenRegistService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceOpenApplyVO> saveOrUpdate(@RequestBody InvoiceOpenApplyVO saveorUpdateVO) {
    	InvoiceOpenApplyEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceOpenApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getOpenType()==null){
            entity.setOpenType(0);
        }
    	service.saveOrUpdate(entity, false);

    	InvoiceOpenApplyVO vo = BeanMapper.map(entity, InvoiceOpenApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceOpenApplyVO> queryDetail(Long id) {
    	InvoiceOpenApplyEntity entity = service.selectById(id);
    	InvoiceOpenApplyVO vo = BeanMapper.map(entity, InvoiceOpenApplyVO.class);
        CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String,String> defMap =getDefMap(defList.getData());
        vo.setInvoiceTypeName(defMap.get(vo.getInvoiceType()+""));
       /* InvoiceOpenApplyEntity invoiceOpenApplyEntity =service.getById(id);
        iInvoiceOpenRegistService.save(invoiceOpenApplyEntity);*/
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceOpenApplyVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceOpenApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("buyer");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceOpenApplyEntity> page = service.queryPage(param,false);
        IPage<InvoiceOpenApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceOpenApplyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryOpenList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenApplyVO>> queryOpenList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("buyer");
        param.getFuzzyFields().add("code");        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("openType", new Parameter(QueryParam.EQ, 1));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceOpenApplyEntity> page = service.queryPage(param,false);
        IPage<InvoiceOpenApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceOpenApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("buyer");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));        IPage<InvoiceOpenApplyEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceOpenApplyVO> voList = new ArrayList<InvoiceOpenApplyVO>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(openApplyEntity -> {
                InvoiceOpenApplyVO r = BeanMapper.map(openApplyEntity, InvoiceOpenApplyVO.class);
                r.setOpenTypeName(r.getOpenType() ==0?"未开票":"已经开票");
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceOpenApply-export.xlsx", beans, response);
    }

    /**
     * 统计合同本次申请金额
     * @return
     */
    @RequestMapping(value = "/querySumApplyMnyTax", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> querySumApplyMnyTax(Long contractId){
        Map<String, BigDecimal> map = service.selectSumApplyMnyTax(contractId);
        return CommonResponse.success("查询累计申请金额成功！",map);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }
}
