package com.ejianc.business.taxnew.controller;

import java.io.Serializable;

import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.vo.InvoiceOpenApplyVO;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 开票登记
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("invoiceOpenRegist")
public class InvoiceOpenRegistController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IInvoiceOpenRegistService service;

    @Autowired
    private IInvoiceOpenPoolService iInvoiceOpenPoolService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IDefdocApi defdocApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> saveOrUpdate(@RequestBody InvoiceOpenRegistVO saveorUpdateVO) {

    	InvoiceOpenRegistEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceOpenRegistEntity.class);
        InvoiceOpenRegistEntity registEntity =service.saveOrUpdatePool(entity);
    	InvoiceOpenRegistVO vo = BeanMapper.map(registEntity, InvoiceOpenRegistVO.class);
    	List<InvoiceOpenPoolVO> list =vo.getContractItemList();
    	List<InvoiceOpenPoolVO> allList = new ArrayList<>();
    	for (InvoiceOpenPoolVO v:list){
    	    v.setRowState(null);
            allList.add(v);
        }
    	vo.setContractItemList(allList);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }



    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> queryDetail(Long id) {
    	InvoiceOpenRegistEntity entity = service.selectByIdAll(id);
    	InvoiceOpenRegistVO vo = BeanMapper.map(entity, InvoiceOpenRegistVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceOpenRegistVO> vos) {
        return service.delete(vos);
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenRegistVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("applyCode");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("buyer");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("seller");
        param.getFuzzyFields().add("contractName");

        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("registUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("registUserId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");

        }

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceOpenRegistEntity> page = service.queryPage(param,false);
        IPage<InvoiceOpenRegistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceOpenRegistVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryRegistPool", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> queryPoolList(Long id) {
        InvoiceOpenRegistEntity entity =service.selectOpenRegistByApplyId(id);
        InvoiceOpenRegistVO vo = new InvoiceOpenRegistVO();
        if (entity != null){
            vo = BeanMapper.map(entity, InvoiceOpenRegistVO.class);

        }
        return CommonResponse.success("查询列表数据成功！",vo);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "registPool-import.xlsx", "开票登记导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<InvoiceOpenPoolVO> successList = new ArrayList<>();
            List<InvoiceOpenPoolVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 8) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
                Map<String,String> defMap =getDefMap(defList.getData());

                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    InvoiceOpenPoolVO invoiceOpenPoolVO = new InvoiceOpenPoolVO();
                    if (StringUtils.isBlank(datas.get(0))) {
                        invoiceOpenPoolVO.setErrorMessage("发票类型能不为空");
                    }else{
                        String invoiceTypeCall =datas.get(0);
                        String invoiceType= defMap.get(invoiceTypeCall);
                        if(StringUtils.isNotEmpty(invoiceType)){
                            invoiceOpenPoolVO.setInvoiceType(Long.valueOf(invoiceType));
                            invoiceOpenPoolVO.setInvoiceTypeName(invoiceTypeCall);
                        }else{
                            invoiceOpenPoolVO.setErrorMessage("发票类型可能不正确");
                        }

                    }

                    if (StringUtils.isBlank(datas.get(1))){
                        invoiceOpenPoolVO.setErrorMessage("发票代码不为空");
                    }else{
                        invoiceOpenPoolVO.setInvoiceCode(datas.get(1));
                    }

                    if (StringUtils.isBlank(datas.get(2))){
                        invoiceOpenPoolVO.setErrorMessage("发票号码不为空");
                    }else{
                        invoiceOpenPoolVO.setInvoiceNumber(datas.get(2));
                    }

                    if (StringUtils.isBlank(datas.get(3))){
                        invoiceOpenPoolVO.setErrorMessage("开票日期不为空");
                    }else{
                         //对应的就是时间戳对应的Date
                        try {
                            String strDate =service.excelDoubleToDate(datas.get(3));
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                            Date date = simpleDateFormat.parse(strDate);
                            invoiceOpenPoolVO.setInvoiceDate(date);
                        } catch (Exception e) {
                            invoiceOpenPoolVO.setErrorMessage("开票日期格式不正确");
                            e.printStackTrace();
                        }
                    }

                    if (StringUtils.isBlank(datas.get(4))){
                        invoiceOpenPoolVO.setErrorMessage("发票金额不为空");
                    }else{
                        try {
                            invoiceOpenPoolVO.setInvoiceMny(new BigDecimal(datas.get(4)));
                        }catch (Exception e){
                            invoiceOpenPoolVO.setErrorMessage("发票金额必须是数字");
                        }
                    }

                    if (StringUtils.isBlank(datas.get(5))){
                        invoiceOpenPoolVO.setTaxMny(new BigDecimal(0));
                    }else{
                        try {
                            invoiceOpenPoolVO.setTaxMny(new BigDecimal(datas.get(5)));
                        }catch (Exception e){
                            invoiceOpenPoolVO.setErrorMessage("税金必须是数字");
                        }
                    }

                    invoiceOpenPoolVO.setInvoiceContent(datas.get(6));
                    invoiceOpenPoolVO.setMemo(datas.get(7));
                    invoiceOpenPoolVO.setInvoiceTaxMny(invoiceOpenPoolVO.getInvoiceMny().add(invoiceOpenPoolVO.getTaxMny()));
                    if (StringUtils.isNotBlank(invoiceOpenPoolVO.getErrorMessage())){
                        errorList.add(invoiceOpenPoolVO);
                    }else{
                        successList.add(invoiceOpenPoolVO);
                    }
                }
            }

            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * 查询已开具发票列表(用于开票申请已开具发票)
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryApplyRegistList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenPoolVO>> queryApplyRegistList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("invoiceCode");
        param.getFuzzyFields().add("invoiceNumber");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("regist",new Parameter(QueryParam.EQ,1));
        IPage<InvoiceOpenPoolEntity> page = iInvoiceOpenPoolService.queryPage(param,false);
        IPage<InvoiceOpenPoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceOpenPoolVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 导出(待登记-和全部)
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("applyCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("buyer");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));        IPage<InvoiceOpenRegistEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceOpenRegistVO> voList = new ArrayList<InvoiceOpenRegistVO>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceOpenRegistVO r = BeanMapper.map(pool, InvoiceOpenRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        String titel="";
        if(queryParam.getParams().get("registState") != null){
            if(queryParam.getParams().get("registState").getValue().equals(0)){
                titel="待登记";
            }
        }else{
            titel="";
        }
        beans.put("titel",titel);
        ExcelExport.getInstance().export("invoiceOpenRegistStaye-export.xlsx", beans, response);
    }

    @PostMapping(value = "alreadyExcelExport")
    public void alreadyExcelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("applyCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("buyer");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));        IPage<InvoiceOpenRegistEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceOpenRegistVO> voList = new ArrayList<InvoiceOpenRegistVO>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceOpenRegistVO r = BeanMapper.map(pool, InvoiceOpenRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceOpenRegist-Apply-export.xlsx", beans, response);
    }
    /**
     * 无申请导出excel
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "notExcelExport")
    public void notExcelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("applyCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("buyer");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));        IPage<InvoiceOpenRegistEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceOpenRegistVO> voList = new ArrayList<InvoiceOpenRegistVO>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceOpenRegistVO r = BeanMapper.map(pool, InvoiceOpenRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceOpenRegist-export.xlsx", beans, response);
    }

    /**
     * 导出(用于开票申请已开具发票--开票申请已开具发票)
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelApplyRegistExport")
    public void excelApplyRegistExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //queryParam.getParams().put("openApplyType",new Parameter(QueryParam.EQ,1));
        queryParam.getParams().put("regist",new Parameter(QueryParam.EQ,1));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<InvoiceOpenPoolEntity> pageData = iInvoiceOpenPoolService.queryPage(queryParam, false);
        List<InvoiceOpenPoolVO> voList = new ArrayList<InvoiceOpenPoolVO>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceOpenPoolVO r = BeanMapper.map(pool, InvoiceOpenPoolVO.class);
                voList.add(r);
            });
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("applyRegistPool-export.xlsx", beans, response);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    /**
     * @Author xuannl
     * @Date 2021/11/29
     * @Description checkParams 校验是否超额
     * @param contractId
     * @param appMoney
     */
    @RequestMapping(value = "/checkParams", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamsCheckSpreadVO> checkParams(Long contractId, BigDecimal appMoney) {
        ParamsCheckSpreadVO paramsCheckSpreadVO = service.checkParams(contractId, appMoney);
        return CommonResponse.success("查询打印数据成功！",paramsCheckSpreadVO);
    }
}
