package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenPoolMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;

@Service("invoiceOpenRegist") 
public class InvoiceOpenRegistBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IInvoiceOpenPoolService invoiceOpenPoolService;
	@Autowired
	private InvoiceOpenPoolMapper invoiceOpenPoolMapper;

	@Autowired
	private IInvoiceOpenRegistService invoiceOpenRegistService;

	@Autowired
	private IInvoiceOpenApplyService invoiceOpenApplyService;

	@Autowired
	private IIncomeContractApi incomeContractApwi;
	@Autowired
	private IBillTypeApi billTypeApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		UpdateWrapper<InvoiceOpenPoolEntity> updateWrapper = new UpdateWrapper();
		updateWrapper.eq("regist_id",billId);
		updateWrapper.eq("dr",0);
		updateWrapper.set("bill_state",state);
		updateWrapper.set("regist",1);//改成已生效
		invoiceOpenPoolService.update(updateWrapper);
		InvoiceOpenRegistEntity invoiceOpenRegistEntity = invoiceOpenRegistService.selectByIdAll(billId);
		if(invoiceOpenRegistEntity.getApplyId() != null){
			UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
			wrapper.eq("id",invoiceOpenRegistEntity.getApplyId());
			wrapper.set("open_type",1);
			invoiceOpenApplyService.update(wrapper);
		}
		invoiceOpenRegistEntity.setRegistState(1);
		//无子表，自动生成
		if(invoiceOpenRegistEntity.getContractItemList().size()==0){
			List<InvoiceOpenPoolEntity> list = invoiceOpenRegistService.generateInvoiceOpenPool(invoiceOpenRegistEntity);
			list.forEach(sub->{
				sub.setBillState(state);
				sub.setRegist(1);
			});
			invoiceOpenRegistEntity.setContractItemList(list);
			invoiceOpenRegistEntity.setInvoiceAuantity(1);
			invoiceOpenPoolService.save(list.get(0));
		}
		invoiceOpenRegistService.saveOrUpdateNoES(invoiceOpenRegistEntity);
		/** 回调合同相关 */
		if(ListUtil.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())){
			List<InvoiceOpenPoolEntity> poolEntities = invoiceOpenRegistEntity.getContractItemList();
			for (InvoiceOpenPoolEntity invoiceOpenEntity : poolEntities) {
				CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), true);
				if (!stringCommonResponse.isSuccess()) {
					logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//合同是否被其他单据引用
		QueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new QueryWrapper();
		queryWrapper.eq("regist_id",billId);
		queryWrapper.eq("dr",0);

		List<InvoiceOpenPoolEntity> poolEntities = invoiceOpenPoolService.list(queryWrapper);
		if(ListUtil.isNotEmpty(poolEntities)){
			for (InvoiceOpenPoolEntity poolEntity : poolEntities) {
				CommonResponse<String>  res = billTypeApi.checkQuote("BT200605000000001",poolEntity.getId());
				logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
				if(!res.isSuccess()) {//单据未被下游单据引用
					return CommonResponse.error(res.getMsg());
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		UpdateWrapper<InvoiceOpenPoolEntity> updateWrapper = new UpdateWrapper();
		updateWrapper.eq("regist_id",billId);
		updateWrapper.eq("dr",0);
		updateWrapper.set("bill_state",0);
		updateWrapper.set("regist",0);//改成未生效
		invoiceOpenPoolService.update(updateWrapper);

		InvoiceOpenRegistEntity invoiceOpenRegistEntity =invoiceOpenRegistService.getById(billId);
		if(invoiceOpenRegistEntity.getApplyId() != null){
			UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
			wrapper.eq("id",invoiceOpenRegistEntity.getApplyId());
			wrapper.set("open_type",0);
			invoiceOpenApplyService.update(wrapper);
		}
		invoiceOpenRegistEntity.setRegistState(0);
		invoiceOpenRegistService.saveOrUpdateNoES(invoiceOpenRegistEntity);
		/** 回调合同相关 */
		if(ListUtil.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())){
			List<InvoiceOpenPoolEntity> poolEntities = invoiceOpenRegistEntity.getContractItemList();
			for (InvoiceOpenPoolEntity invoiceOpenEntity : poolEntities) {
				CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), false);
				if (!stringCommonResponse.isSuccess()) {
					logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
				}
			}
		}
		return CommonResponse.success();
	}

}
