package com.ejianc.business.taxnew.controller;

import java.io.Serializable;

import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.business.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 收票登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("invoiceReceiveRegist")
public class InvoiceReceiveRegistController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "tax-receive-code-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> saveOrUpdate(@RequestBody InvoiceReceiveRegistVO saveorUpdateVO) {
        InvoiceReceiveRegistEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceReceiveRegistEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity);
        InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryDetail(Long id) {
        InvoiceReceiveRegistEntity entity = service.selectById(id);
        InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveRegistVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceReceiveRegistVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询进项发票列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("sellerName");
        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("processPersonId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("processPersonId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");

        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceReceiveRegistEntity> page = service.queryPage(param,false);
        IPage<InvoiceReceiveRegistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceiveRegistVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "receivePool-import.xlsx", "收票登记发票导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<InvoiceReceivePoolVO> errorList = new ArrayList<>();
            List<InvoiceReceivePoolVO> successList = new ArrayList<>();
            CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String,String> defMap =getDefMap(defList.getData());
            if(result != null && result.size() > 0) {
                for(int i=0;i<result.size();i++) {
                    InvoiceReceivePoolVO s = new InvoiceReceivePoolVO();
                    List<String> row = result.get(i);
                    if(StringUtils.isEmpty(row.get(0)) || !("增值税专用发票".equals(row.get(0)) || "增值税普通发票".equals(row.get(0)) || "其它".equals(row.get(0)))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票类型选择不正确！");
                    }else {
                        String invoiceType= defMap.get(row.get(0));
                        s.setInvoiceType(Long.valueOf(invoiceType));
                    }
                    s.setInvoiceTypeName(row.get(0));
                    if(StringUtils.isEmpty(row.get(1))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票代码不能为空！");
                    }else {
                        s.setInvoiceCode(row.get(1));
                    }
                    if(StringUtils.isEmpty(row.get(2))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票号码不能为空！");
                    }else {
                        s.setInvoiceNumber(row.get(2));
                    }
                    if(StringUtils.isEmpty(row.get(3))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：开票日期不能为空！");
                    }else {
                        try {
                            s.setInvoiceDate(DateFormatUtil.parseDate("yyyy-MM-dd",row.get(3)));
                        }catch (ParseException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：开票日期格式不正确！");
                            s.setInvoiceDate(null);
                        }
                    }

                    if(StringUtils.isEmpty(row.get(4))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票金额(不含税)不能为空！");
                    }else {
                        try {
                            s.setInvoiceMny(new BigDecimal(row.get(4)));
                        }catch (NumberFormatException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票金额(不含税)不是正确的数字格式！");
                            s.setInvoiceMny(null);
                        }
                    }
                    if(StringUtils.isEmpty(row.get(5))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：税额不能为空！");
                    }else {
                        try {
                            s.setTaxMny(new BigDecimal(row.get(5)));
                        }catch (NumberFormatException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：税额不是正确的数字格式！");
                            s.setTaxMny(null);
                        }
                    }

                    if(StringUtils.isNotEmpty(row.get(6))){
                        s.setContent(row.get(6));
                    }

                    if(s.getInvoiceMny()!=null && s.getTaxMny()!=null){
                        s.setInvoiceTaxMny(s.getTaxMny().add(s.getInvoiceMny()));
                    }
                    if(StringUtils.isEmpty(s.getErrorMessage())){
                        successList.add(s);
                    }else {
                        errorList.add(s);
                    }



                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("sellerName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceReceiveRegistEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceReceiveRegistVO> voList = new ArrayList<InvoiceReceiveRegistVO>();

        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceiveRegistVO r = BeanMapper.map(pool, InvoiceReceiveRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                if(r.getMoneyType() != null){
                    switch (r.getMoneyType()){
                        case 1 :
                            r.setMoneyTypeName("预付款");
                            break;
                        case 2 :
                            r.setMoneyTypeName("进度款");
                            break;
                        case 3 :
                            r.setMoneyTypeName("其他");
                            break;
                        default:
                            break;
                    }
                }
                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceive-export.xlsx", beans, response);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {

        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }
}
