/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.tax.mapper.InvoiceOpenMapper;
import com.ejianc.business.tax.utils.ConvertUpMoney;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="invoiceOpenRegistService")
public class InvoiceOpenRegistServiceImpl
extends BaseServiceImpl<InvoiceOpenRegistMapper, InvoiceOpenRegistEntity>
implements IInvoiceOpenRegistService {
    @Autowired
    private IInvoiceOpenPoolService invoiceOpenPoolService;
    @Autowired
    private IInvoiceOpenApplyService invoiceOpenApplyService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Lock lock = new ReentrantLock(true);
    private static final String BILL_CODE = "tax-open-regist-001";
    private static final String BILL_POOL_CODE = "tax-open-pool-001";
    private static final String CHEC_INVOICE_OPEN_CODE = "P-jyh01v35";
    private static final String configCodeDm = "TAX_FPDM";
    private static final String configCodeHm = "TAX_FPHM";
    @Autowired
    private InvoiceOpenRegistMapper invoiceOpenRegistMapper;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IIncomeContractApi iIncomeContractApi;
    @Autowired
    private InvoiceOpenMapper invoiceOpenMapper;

    @Override
    @Transactional
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.eq((Object)"apply_id", (Object)invoiceOpenApplyEntity.getId());
        List invoiceOpenApplyList = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)invoiceOpenApplyList)) {
            throw new BusinessException("\u4e0d\u53ef\u4ee5\u91cd\u590d\u63d0\u4ea4");
        }
        InvoiceOpenRegistEntity registEntity = new InvoiceOpenRegistEntity();
        registEntity.setApplyCode(invoiceOpenApplyEntity.getCode());
        registEntity.setApplyDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setApplyer(invoiceOpenApplyEntity.getApplyer());
        registEntity.setApplyerId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setApplyMny(invoiceOpenApplyEntity.getApplyMny());
        registEntity.setApplyMnyTaxChn(invoiceOpenApplyEntity.getApplyMnyTaxChn());
        registEntity.setApplyMnyTax(invoiceOpenApplyEntity.getApplyMnyTax());
        registEntity.setBuyerAddrPhone(invoiceOpenApplyEntity.getBuyerAddrPhone());
        registEntity.setBuyerBankAccount(invoiceOpenApplyEntity.getBuyerBankAccount());
        registEntity.setBuyerId(invoiceOpenApplyEntity.getBuyerId());
        registEntity.setBuyer(invoiceOpenApplyEntity.getBuyer());
        registEntity.setApplyId(invoiceOpenApplyEntity.getId());
        registEntity.setBuyerTaxId(invoiceOpenApplyEntity.getBuyerTaxId());
        registEntity.setContractId(invoiceOpenApplyEntity.getContractId());
        registEntity.setContractName(invoiceOpenApplyEntity.getContractName());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        registEntity.setMoneyType(invoiceOpenApplyEntity.getMoneyType());
        registEntity.setMoneyTypeId(invoiceOpenApplyEntity.getMoneyTypeId());
        registEntity.setOrgId(invoiceOpenApplyEntity.getOrgId());
        registEntity.setOrgName(invoiceOpenApplyEntity.getOrgName());
        registEntity.setProjectId(invoiceOpenApplyEntity.getProjectId());
        registEntity.setProjectName(invoiceOpenApplyEntity.getProjectName());
        registEntity.setSellerId(invoiceOpenApplyEntity.getSellerId());
        registEntity.setSeller(invoiceOpenApplyEntity.getSeller());
        registEntity.setSellerTaxCode(invoiceOpenApplyEntity.getSellerTaxCode());
        registEntity.setSellerAddrPhone(invoiceOpenApplyEntity.getSellerAddrPhone());
        registEntity.setSellerBankAccount(invoiceOpenApplyEntity.getSellerBankAccount());
        registEntity.setTax(invoiceOpenApplyEntity.getTax());
        registEntity.setRegistOpenType(1);
        registEntity.setRegistState(0);
        registEntity.setHasContract(invoiceOpenApplyEntity.getHasContract());
        registEntity.setNowContractMny(invoiceOpenApplyEntity.getNowContractMny());
        registEntity.setTotalQuoteMny(invoiceOpenApplyEntity.getTotalQuoteMny());
        registEntity.setTotalOpenApplyMnyTax(invoiceOpenApplyEntity.getTotalOpenApplyMnyTax());
        registEntity.setTotalOpenMny(invoiceOpenApplyEntity.getTotalOpenMny());
        registEntity.setTotalBackMnyTax(invoiceOpenApplyEntity.getTotalBackMnyTax());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        registEntity.setTaxMny(invoiceOpenApplyEntity.getTaxAmount() == null ? BigDecimal.ZERO : invoiceOpenApplyEntity.getTaxAmount());
        registEntity.setInvoiceTaxMny(invoiceOpenApplyEntity.getApplyMnyTax() == null ? BigDecimal.ZERO : invoiceOpenApplyEntity.getApplyMnyTax());
        registEntity.setInvoiceMny(registEntity.getInvoiceTaxMny().subtract(registEntity.getTaxMny()));
        registEntity.setRegistDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setRegistUserId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setRegistUserName(invoiceOpenApplyEntity.getApplyer());
        registEntity.setRegistDeptName(invoiceOpenApplyEntity.getAppDeptName());
        registEntity.setProjectAddress(invoiceOpenApplyEntity.getProjectAddress());
        String billCode = this.getBillCode(BILL_CODE);
        registEntity.setCode(billCode);
        super.save((Object)registEntity);
        this.invoiceOpenPoolService.createSave(invoiceOpenApplyEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public InvoiceOpenRegistEntity saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        this.lock.lock();
        try {
            ArrayList<InvoiceOpenPoolEntity> invoiceOpenPoolEntities = new ArrayList<InvoiceOpenPoolEntity>();
            if (CollectionUtils.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())) {
                CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
                Map<String, String> defMap = this.getDefMap((List)defList.getData());
                List<InvoiceOpenPoolEntity> invoiceOpenPoolList = invoiceOpenRegistEntity.getContractItemList();
                this.checkPool(invoiceOpenPoolList);
                int invoiceAuantity = invoiceOpenPoolList.size();
                for (InvoiceOpenPoolEntity entity : invoiceOpenPoolList) {
                    if (!"del".equals(entity.getRowState())) continue;
                    --invoiceAuantity;
                }
                if (invoiceOpenRegistEntity.getRegistDate() == null) {
                    invoiceOpenRegistEntity.setRegistDate(new Date());
                }
                invoiceOpenRegistEntity.setInvoiceAuantity(invoiceAuantity);
                invoiceOpenRegistEntity.setRegistState(0);
                if (invoiceOpenRegistEntity.getId() != null) {
                    super.saveOrUpdate((Object)invoiceOpenRegistEntity);
                } else {
                    String billCode = this.getBillCode(BILL_CODE);
                    invoiceOpenRegistEntity.setCode(billCode);
                    super.saveOrUpdate((Object)invoiceOpenRegistEntity);
                }
                for (InvoiceOpenPoolEntity pool : invoiceOpenPoolList) {
                    if (invoiceOpenRegistEntity.getApplyId() != null) {
                        pool.setOpenApplyType(1);
                        pool.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
                        pool.setApplyId(invoiceOpenRegistEntity.getApplyId());
                        pool.setApplyMnyTax(invoiceOpenRegistEntity.getApplyMnyTax());
                    }
                    pool.setType(invoiceOpenRegistEntity.getHasContract());
                    pool.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
                    pool.setContractId(invoiceOpenRegistEntity.getContractId());
                    pool.setContractName(invoiceOpenRegistEntity.getContractName());
                    pool.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
                    pool.setCustomerName(invoiceOpenRegistEntity.getBuyer());
                    pool.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
                    pool.setEmployeeId(invoiceOpenRegistEntity.getRegistUserId());
                    pool.setEmployeeName(invoiceOpenRegistEntity.getRegistUserName());
                    pool.setOrgId(invoiceOpenRegistEntity.getOrgId());
                    pool.setOrgName(invoiceOpenRegistEntity.getOrgName());
                    pool.setProjectId(invoiceOpenRegistEntity.getProjectId());
                    pool.setProjectName(invoiceOpenRegistEntity.getProjectName());
                    pool.setRegistId(invoiceOpenRegistEntity.getId());
                    pool.setRegistCode(invoiceOpenRegistEntity.getCode());
                    pool.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
                    pool.setSupplierName(invoiceOpenRegistEntity.getSeller());
                    pool.setSupplierId(invoiceOpenRegistEntity.getSellerId());
                    pool.setType(invoiceOpenRegistEntity.getHasContract());
                    pool.setMoneyTypeId(invoiceOpenRegistEntity.getMoneyTypeId());
                    pool.setBuyerAddrPhone(invoiceOpenRegistEntity.getBuyerAddrPhone());
                    pool.setBuyerBankAccount(invoiceOpenRegistEntity.getBuyerBankAccount());
                    pool.setSellerAddrPhone(invoiceOpenRegistEntity.getSellerAddrPhone());
                    pool.setSellerBankAccount(invoiceOpenRegistEntity.getSellerBankAccount());
                    pool.setInvoiceTypeName(defMap.get(pool.getInvoiceType() + ""));
                    pool.setRegist(0);
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pool.getRowState()) && "del".equals(pool.getRowState())) {
                        this.invoiceOpenPoolService.removeById(pool.getId());
                        continue;
                    }
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pool.getRowState()) || "edit".equals(pool.getRowState())) {
                        this.invoiceOpenPoolService.saveOrUpdate((Object)pool);
                        invoiceOpenPoolEntities.add(pool);
                        continue;
                    }
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pool.getRowState()) || !"add".equals(pool.getRowState())) continue;
                    String billCode = this.getBillCode(BILL_POOL_CODE);
                    pool.setBillCode(billCode);
                    this.invoiceOpenPoolService.saveOrUpdate((Object)pool);
                    invoiceOpenPoolEntities.add(pool);
                }
                invoiceOpenRegistEntity.setContractItemList(invoiceOpenPoolEntities);
            } else {
                String billCode = this.getBillCode(BILL_CODE);
                invoiceOpenRegistEntity.setCode(billCode);
                if (invoiceOpenRegistEntity.getRegistDate() == null) {
                    invoiceOpenRegistEntity.setRegistDate(new Date());
                }
                invoiceOpenRegistEntity.setRegistState(0);
                invoiceOpenRegistEntity.setInvoiceAuantity(0);
                super.saveOrUpdate((Object)invoiceOpenRegistEntity);
            }
        }
        finally {
            this.lock.unlock();
        }
        return invoiceOpenRegistEntity;
    }

    @Override
    public List<InvoiceOpenPoolEntity> generateInvoiceOpenPool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        InvoiceOpenPoolEntity poolEntity = new InvoiceOpenPoolEntity();
        poolEntity.setId(null);
        poolEntity.setRegistId(invoiceOpenRegistEntity.getId());
        poolEntity.setRegistCode(invoiceOpenRegistEntity.getCode());
        poolEntity.setOriginType(0);
        poolEntity.setBillCode(invoiceOpenRegistEntity.getCode());
        CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String, String> defMap = this.getDefMapName((List)defList.getData());
        poolEntity.setInvoiceCode(this.getBillCode(configCodeDm));
        poolEntity.setInvoiceNumber(this.getBillCode(configCodeHm));
        poolEntity.setInvoiceDate(new Date());
        poolEntity.setInvoiceMny(invoiceOpenRegistEntity.getInvoiceMny());
        poolEntity.setTaxMny(invoiceOpenRegistEntity.getTaxMny());
        poolEntity.setInvoiceTaxMny(ComputeUtil.safeAdd((BigDecimal)poolEntity.getInvoiceMny(), (BigDecimal)poolEntity.getTaxMny()));
        if (new BigDecimal(poolEntity.getInvoiceTaxMny().intValue()).compareTo(poolEntity.getInvoiceTaxMny()) == 0) {
            poolEntity.setInvoiceTaxMnyChn(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()) + "\u6574");
        } else {
            poolEntity.setInvoiceTaxMnyChn(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()));
        }
        poolEntity.setType(invoiceOpenRegistEntity.getHasContract());
        poolEntity.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
        poolEntity.setContractId(invoiceOpenRegistEntity.getContractId());
        poolEntity.setContractName(invoiceOpenRegistEntity.getContractName());
        poolEntity.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
        poolEntity.setCustomerName(invoiceOpenRegistEntity.getBuyer());
        poolEntity.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
        poolEntity.setEmployeeId(invoiceOpenRegistEntity.getRegistUserId());
        poolEntity.setEmployeeName(invoiceOpenRegistEntity.getRegistUserName());
        poolEntity.setOrgId(invoiceOpenRegistEntity.getOrgId());
        poolEntity.setOrgName(invoiceOpenRegistEntity.getOrgName());
        poolEntity.setProjectId(invoiceOpenRegistEntity.getProjectId());
        poolEntity.setProjectName(invoiceOpenRegistEntity.getProjectName());
        poolEntity.setRegistId(invoiceOpenRegistEntity.getId());
        poolEntity.setRegistCode(invoiceOpenRegistEntity.getCode());
        poolEntity.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
        poolEntity.setSupplierName(invoiceOpenRegistEntity.getSeller());
        poolEntity.setSupplierId(invoiceOpenRegistEntity.getSellerId());
        poolEntity.setType(invoiceOpenRegistEntity.getHasContract());
        poolEntity.setMoneyTypeId(invoiceOpenRegistEntity.getMoneyTypeId());
        poolEntity.setBuyerAddrPhone(invoiceOpenRegistEntity.getBuyerAddrPhone());
        poolEntity.setBuyerBankAccount(invoiceOpenRegistEntity.getBuyerBankAccount());
        poolEntity.setSellerAddrPhone(invoiceOpenRegistEntity.getSellerAddrPhone());
        poolEntity.setSellerBankAccount(invoiceOpenRegistEntity.getSellerBankAccount());
        String invoiceType = defMap.get("\u5176\u4ed6");
        if (!StringUtils.isNotEmpty((String)invoiceType)) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u53d1\u7968\u7c7b\u578b\u83b7\u53d6\u5931\u8d25");
        }
        poolEntity.setInvoiceType(Long.valueOf(invoiceType));
        poolEntity.setInvoiceTypeName("\u5176\u4ed6");
        poolEntity.setRegist(0);
        ArrayList<InvoiceOpenPoolEntity> list = new ArrayList<InvoiceOpenPoolEntity>();
        list.add(poolEntity);
        this.checkPool(list);
        return list;
    }

    public String getBillCode(String code) {
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            return (String)billCode.getData();
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @Override
    public InvoiceOpenRegistEntity selectByIdAll(Long id) {
        InvoiceOpenRegistEntity entity = (InvoiceOpenRegistEntity)((Object)this.getById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"regist_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.invoiceOpenPoolService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity.setContractItemList(list);
        }
        return entity;
    }

    @Override
    public InvoiceOpenRegistEntity selectOpenRegistByApplyId(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"apply_id", (Object)applyId);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        InvoiceOpenRegistEntity entity = (InvoiceOpenRegistEntity)((Object)this.invoiceOpenRegistMapper.selectOne((Wrapper)queryWrapper));
        if (entity != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("registId", new Parameter("eq", (Object)entity.getId()));
            List list = this.invoiceOpenPoolService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                entity.setContractItemList(list);
            }
        }
        return entity;
    }

    @Override
    public String excelDoubleToDate(String date) {
        if (date.length() == 5) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date tDate = InvoiceOpenRegistServiceImpl.DoubleToDate(Double.parseDouble(date));
                return sdf.format(tDate);
            }
            catch (Exception e) {
                e.printStackTrace();
                return date;
            }
        }
        return date;
    }

    @Override
    public Map<String, BigDecimal> selectSumInvoiceMny(Long contractId) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"  sum(invoice_mny) as totalInvoiceMny "});
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        Map data = super.getMap((Wrapper)query);
        if (null != data) {
            resp.put("totalInvoiceMny", null != data.get("totalInvoiceMny") ? new BigDecimal(data.get("totalInvoiceMny").toString()) : BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalInvoiceMny", BigDecimal.ZERO);
        }
        return resp;
    }

    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000;
        tDate.setTime((long)((dVal - 25569.0) * 24.0 * 3600.0 * 1000.0 + (double)localOffset));
        return tDate;
    }

    public void checkPool(List<InvoiceOpenPoolEntity> poolList) {
        ArrayList<String> invoiceNumberParamList = new ArrayList<String>();
        for (int i = 0; i < poolList.size(); ++i) {
            InvoiceOpenPoolEntity vo = poolList.get(i);
            if (!"add".equals(vo.getRowState()) && !"edit".equals(vo.getRowState())) continue;
            invoiceNumberParamList.add(vo.getInvoiceNumber());
            for (int j = i + 1; j < poolList.size(); ++j) {
                InvoiceOpenPoolEntity poolVo = poolList.get(j);
                if (!vo.getInvoiceNumber().equals(poolVo.getInvoiceNumber())) continue;
                throw new BusinessException("\u53d1\u7968\u53f7\u7801\u7b2c" + (i + 1) + "\u884c\u548c\u7b2c" + (j + 1) + "\u91cd\u590d");
            }
        }
        if (CollectionUtils.isNotEmpty(invoiceNumberParamList)) {
            this.checkInvoiceNumber(poolList, invoiceNumberParamList);
        }
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<InvoiceOpenRegistVO> vos) {
        UpdateWrapper wrapper;
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"dr", new Object[]{1, 3});
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in((Object)"regist_id", ids);
        List<InvoiceOpenPoolVO> list = this.invoiceOpenPoolService.queryList((QueryWrapper<InvoiceOpenPoolEntity>)queryWrapper);
        if (list != null && list.size() > 0) {
            String message = "";
            List entitys = (List)this.listByIds(list.stream().map(InvoiceOpenPoolVO::getRegistId).collect(Collectors.toList()));
            for (InvoiceOpenRegistEntity entity : entitys) {
                if (message.length() > 0) {
                    message = message + "\u3001" + entity.getCode();
                    continue;
                }
                message = message + entity.getCode();
            }
            if (message.length() > 0) {
                return CommonResponse.error((String)("\u4ee5\u4e0b\u767b\u8bb0\uff1a" + message + "\u5b58\u5728\u53d1\u7968\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\uff01\uff01\uff01"));
            }
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)0);
        query.in((Object)"id", ids);
        List registList = super.list((Wrapper)query);
        List applyIds = registList.stream().map(InvoiceOpenRegistEntity::getApplyId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)registList)) {
            wrapper = new UpdateWrapper();
            wrapper.in((Object)"id", applyIds);
            wrapper.set((Object)"open_type", (Object)0);
            this.invoiceOpenApplyService.update((Wrapper)wrapper);
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            wrapper = new UpdateWrapper();
            wrapper.in((Object)"id", ids);
            wrapper.set((Object)"regist_state", (Object)0);
            this.update((Wrapper)wrapper);
        }
        this.invoiceOpenPoolService.deleteBatchRegistId(ids);
        this.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u767b\u8bb0\u6210\u529f");
    }

    @Override
    public List<InvoiceOpenRegistVO> querylist(QueryWrapper<InvoiceOpenRegistEntity> queryWrapper) {
        List list = this.list((Wrapper)queryWrapper);
        return BeanMapper.mapList((Iterable)list, InvoiceOpenRegistVO.class);
    }

    public void checkInvoiceNumber(List<InvoiceOpenPoolEntity> poolList, List<String> invoiceNumberParamList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"invoice_number", invoiceNumberParamList);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"org_id", (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        List openPoolEntityList = this.invoiceOpenPoolService.list((Wrapper)queryWrapper);
        HashMap<String, InvoiceOpenPoolEntity> poolMap = new HashMap<String, InvoiceOpenPoolEntity>();
        for (InvoiceOpenPoolEntity entity : poolList) {
            if (!"add".equals(entity.getRowState()) && !"edit".equals(entity.getRowState())) continue;
            poolMap.put(entity.getInvoiceNumber(), entity);
        }
        LinkedList<InvoiceOpenPoolEntity> restList = new LinkedList<InvoiceOpenPoolEntity>();
        for (InvoiceOpenPoolEntity poolEntity : openPoolEntityList) {
            if (!poolMap.containsKey(poolEntity.getInvoiceNumber())) continue;
            restList.add(poolEntity);
        }
        if (CollectionUtils.isNotEmpty(restList)) {
            for (InvoiceOpenPoolEntity e : restList) {
                InvoiceOpenPoolEntity v = (InvoiceOpenPoolEntity)((Object)poolMap.get(e.getInvoiceNumber()));
                if (v.getId() != null) {
                    if (v.getId().equals(e.getId())) continue;
                    throw new BusinessException("\u53d1\u7968\u53f7\u7801" + e.getInvoiceNumber() + "\u5df2\u7ecf\u5b58\u5728");
                }
                throw new BusinessException("\u53d1\u7968\u53f7\u7801" + e.getInvoiceNumber() + "\u5df2\u7ecf\u5b58\u5728");
            }
        }
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public Map<String, String> getDefMapName(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    @Override
    public ParamsCheckVO checkParams(Long contractId, BigDecimal appMoney) {
        BigDecimal sumMoneyByContractId;
        CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(CHEC_INVOICE_OPEN_CODE, InvocationInfoProxy.getOrgId());
        if (!response.isSuccess()) {
            throw new BusinessException("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u63a7\u5236\u3010\u5f00\u7968\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        List billParamVOS = (List)response.getData();
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        Integer controlType = 0;
        paramsCheckVO.setWarnType(paramsArray[controlType]);
        BigDecimal oldSumMoney = BigDecimal.ZERO;
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        CommonResponse contractVoCommonResponse = this.iIncomeContractApi.queryDetail(contractId);
        if (contractVoCommonResponse.isSuccess() && null != contractVoCommonResponse.getData() && null != ((ContractVo)contractVoCommonResponse.getData()).getContractTaxMny()) {
            contractTaxMny = ((ContractVo)contractVoCommonResponse.getData()).getContractTaxMny();
        }
        if (null != (sumMoneyByContractId = this.invoiceOpenMapper.getSumMoneyByContractId(contractId))) {
            oldSumMoney = sumMoneyByContractId;
        }
        if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal roleValue;
                BigDecimal _contractTaxMny;
                BigDecimal sumMoney;
                BigDecimal subMoney;
                if (0 == billParamVO.getControlType() || !ComputeUtil.isGreaterThan((BigDecimal)(subMoney = ComputeUtil.safeSub((BigDecimal)(sumMoney = ComputeUtil.safeAdd((BigDecimal)oldSumMoney, (BigDecimal)appMoney)), (BigDecimal)(_contractTaxMny = ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal[])new BigDecimal[]{roleValue = ComputeUtil.scaleTwo((BigDecimal)billParamVO.getRoleValue()), ComputeUtil.toBigDecimal((String)"0.01")})))), (BigDecimal)BigDecimal.ZERO)) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u9500\u9879\u53d1\u7968\u8d85\u5f00");
                paramsCheckDsVO.setWarnName("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                paramsCheckDsVO.setContent("\u672c\u6b21\u5f00\u7968\u91d1\u989d\uff1a" + appMoney.setScale(2, 4) + "\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*" + ComputeUtil.scaleTwo((BigDecimal)roleValue) + "%\uff1a" + ComputeUtil.scaleTwo((BigDecimal)_contractTaxMny) + "\u3002\u8d85\u51fa\u91d1\u989d\uff1a" + subMoney.setScale(2, 4));
                checkDsVOS.add(paramsCheckDsVO);
                paramsCheckVO.setDataSource(checkDsVOS);
                InvoiceOpenRegistServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        paramsCheckVO.setWarnType(paramsArray[controlType]);
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

