/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.InvoiceMnyWarnVO;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.business.tax.vo.InvoicePubWarnQueryVO;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tax/"})
public class InvoiceApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceOpenService invoiceOpenService;
    @Autowired
    private IInvoiceReceiveService invoiceReceiveService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInvoiceOpenPoolService invoiceOpenPoolService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"getInvoiceOpenMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getInvoiceOpenMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        try {
            BigDecimal openMny = this.invoiceOpenService.getOpenMny(contractId, orgId);
            return CommonResponse.success((Object)openMny);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getNoContractOpenMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getNoContractOpenMny(@RequestParam Long projectId, @RequestParam Long customerId) {
        try {
            BigDecimal openMny = this.invoiceOpenService.getNoContractOpenMny(projectId, customerId);
            return CommonResponse.success((Object)openMny);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getInvoiceReceiceMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getInvoiceReceiceMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        try {
            BigDecimal openMny = this.invoiceReceiveService.getReceiveMny(contractId, orgId);
            return CommonResponse.success((Object)openMny);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @GetMapping(value={"/invoiceOpenRef"})
    public CommonResponse<IPage<InvoiceOpenVO>> invoiceOpenRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            }
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
                queryParam.getParams().put("type", new Parameter("eq", (Object)1));
            } else {
                queryParam.getParams().put("type", new Parameter("eq", (Object)2));
            }
        }
        IPage pageData = this.invoiceOpenService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), InvoiceOpenVO.class));
        return CommonResponse.success((String)"\u5f00\u7968\u767b\u8bb0\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"/invoiceReceiveRef"})
    public CommonResponse<JSONObject> invoiceReceiveRef(@RequestBody QueryParam queryParam) {
        IPage pageData = this.invoiceReceiveService.queryPage(queryParam, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), InvoiceReceiveVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u6536\u7968\u767b\u8bb0\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/getInvoiceReceiveRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRecordVO> getInvoiceReceiveRecord(@RequestParam Long id) {
        InvoiceReceiveRecordVO invoiceReceiveRecordVO = this.invoiceReceiveService.getInvoiceReceiveRecord(id);
        return CommonResponse.success((Object)invoiceReceiveRecordVO);
    }

    @RequestMapping(value={"/getInvoiceReceiveRecords"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, InvoiceReceiveRecordVO>> getInvoiceReceiveRecords(@RequestBody List<Long> ids) {
        this.logger.info("ids->" + ids.toString());
        Map<Long, InvoiceReceiveRecordVO> invoiceReceiveRecords = this.invoiceReceiveService.getInvoiceReceiveRecords(ids);
        return CommonResponse.success(invoiceReceiveRecords);
    }

    @RequestMapping(value={"/getInvoiceOpenRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceOpenRecordVO> getInvoiceOpenRecord(@RequestParam Long id) {
        InvoiceOpenRecordVO invoiceOpenRecordVO = this.invoiceOpenService.getInvoiceOpenRecord(id);
        return CommonResponse.success((Object)invoiceOpenRecordVO);
    }

    @RequestMapping(value={"/updateUsedInvoiceMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateUsedInvoiceMny(@RequestBody List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS) {
        return this.invoiceReceiveService.updateUsedInvoiceMny(invoiceReceiveFlagVOS);
    }

    @RequestMapping(value={"/updateFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateFlag(@RequestBody List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS) {
        return this.invoiceReceiveService.updateFlag(invoiceReceiveFlagVOS);
    }

    @RequestMapping(value={"countInvoiceOpenByProperties"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<BigDecimal> countInvoiceOpenByProperties(@RequestBody Map<String, Object> param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", param.get("tenantId"));
        queryWrapper.eq((Object)"dr", (Object)0);
        if (null != param.get("projectIds") && CollectionUtils.isNotEmpty((Collection)((List)param.get("projectIds")))) {
            queryWrapper.in((Object)"project_id", (Collection)((List)param.get("projectIds")));
        }
        if (null != param.get("orgIds") && CollectionUtils.isNotEmpty((Collection)((List)param.get("orgIds")))) {
            queryWrapper.in((Object)"org_id", (Collection)((List)param.get("orgIds")));
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq((Object)"type", (Object)1);
        queryWrapper.select(new String[]{" round(ifnull(sum(invoice_tax_mny),0) / 10000, 2) as amt "});
        Map result = this.invoiceOpenService.getMap((Wrapper)queryWrapper);
        return CommonResponse.success((Object)new BigDecimal(result.get("amt").toString()));
    }

    @RequestMapping(value={"getAnnuallyCountData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getAnnuallyCountData(@RequestBody List<Long> projectIds) {
        QueryParam queryParam = new QueryParam();
        Calendar calendar = Calendar.getInstance();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("invoiceDate", new Parameter("between", (Object)(calendar.get(1) + "-01-01," + calendar.get(1) + "-12-31")));
        if (ListUtil.isNotEmpty(projectIds)) {
            queryParam.getParams().put("projectId", new Parameter("in", projectIds));
        }
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        List receiveEntities = this.invoiceReceiveService.queryList(queryParam, false);
        queryParam.getParams().remove("dependOnProject");
        List openEntities = this.invoiceOpenService.queryList(queryParam, false);
        BigDecimal totalReceive = new BigDecimal("0.00");
        BigDecimal totalOpen = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)receiveEntities)) {
            for (BaseEntity entity : receiveEntities) {
                if (entity.getInvoiceTaxMny() == null) continue;
                totalReceive = totalReceive.add(entity.getInvoiceTaxMny());
            }
        }
        if (ListUtil.isNotEmpty((List)openEntities)) {
            for (BaseEntity entity : openEntities) {
                if (entity.getInvoiceTaxMny() == null) continue;
                totalOpen = totalOpen.add(entity.getInvoiceTaxMny());
            }
        }
        JSONObject back = new JSONObject();
        back.put("totalReceive", (Object)totalReceive);
        back.put("totalOpen", (Object)totalOpen);
        return CommonResponse.success((Object)back);
    }

    @RequestMapping(value={"getInvoiceMnyByTenantIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, InvoiceMnyWarnVO>> getInvoiceMnyByTenantIds(@RequestBody InvoicePubWarnQueryVO pubWarnQueryVO) {
        this.logger.error("pubWarnQueryVO is " + JSONObject.toJSONString((Object)pubWarnQueryVO));
        Map<String, InvoiceMnyWarnVO> map = this.invoiceReceiveService.getInvoiceMnyByTenantIds(pubWarnQueryVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"getWarnInvoiceMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, InvoiceMnyWarnVO>> getWarnInvoiceMny(@RequestBody InvoicePubWarnQueryVO pubWarnQueryVO) {
        this.logger.error("pubWarnQueryVO is " + JSONObject.toJSONString((Object)pubWarnQueryVO));
        Map<String, InvoiceMnyWarnVO> map = this.invoiceReceiveService.getWarnInvoiceMny(pubWarnQueryVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @PostMapping(value={"getReceiveListByQueryParam"})
    public CommonResponse<JSONObject> getReceiveListByQueryParam(@RequestBody QueryParam queryParam) {
        List list = this.invoiceReceiveService.queryList(queryParam, false);
        JSONObject back = new JSONObject();
        back.put("records", (Object)list);
        return CommonResponse.success((Object)back);
    }

    @PostMapping(value={"getOpenListByQueryParam"})
    public CommonResponse<JSONObject> getOpenListByQueryParam(@RequestBody QueryParam queryParam) {
        List list = this.invoiceOpenService.queryList(queryParam, false);
        JSONObject back = new JSONObject();
        back.put("records", (Object)list);
        return CommonResponse.success((Object)back);
    }

    @RequestMapping(value={"/billingContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> sumContractMny(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.invoiceOpenService.billingContract(projectId));
    }

    @RequestMapping(value={"/getTaxReceive"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<InvoiceReceiveVO>> getTaxReceive(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.invoiceReceiveService.getTaxReceive(projectId));
    }

    @RequestMapping(value={"/getContractOpenTaxMny"}, method={RequestMethod.GET})
    @ResponseBody
    CommonResponse<BigDecimal> getContractOpenTaxMny(@RequestParam(value="contractId") Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(invoice_tax_mny) invoiceTaxMny"});
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        queryWrapper.in((Object)"bill_state", billStateList);
        InvoiceOpenEntity one = (InvoiceOpenEntity)((Object)this.invoiceOpenService.getOne((Wrapper)queryWrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)one.getInvoiceTaxMny());
    }

    @RequestMapping(value={"/updateUseInvoiceTaxMny"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<BigDecimal> updateUseInvoiceTaxMny(@RequestBody Map<Long, BigDecimal> param) {
        Set<Long> keySet = param.keySet();
        if (CollectionUtils.isNotEmpty(keySet)) {
            keySet.forEach(id -> {
                InvoiceOpenEntity invoiceOpenEntity = (InvoiceOpenEntity)((Object)((Object)this.invoiceOpenService.selectById((Serializable)id)));
                BigDecimal useInvoiceTaxMny = invoiceOpenEntity.getUseInvoiceTaxMny();
                BigDecimal sumInvoiceTaxMny = ComputeUtil.safeAdd((BigDecimal)useInvoiceTaxMny, (BigDecimal)((BigDecimal)param.get(id)));
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, id);
                updateWrapper.set(InvoiceOpenEntity::getUseInvoiceTaxMny, (Object)sumInvoiceTaxMny);
                this.invoiceOpenService.update((Wrapper)updateWrapper);
            });
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }
}

