package com.ejianc.business.taxnew.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 进项发票池
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_receive_pool")
public class InvoiceReceivePoolEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="invoice_code")
    private String invoiceCode; // 发票代码
    @TableField(value="invoice_number")
    private String invoiceNumber; // 发票号码
    @TableField(value="invoice_date")
    private java.util.Date invoiceDate; // 开票日期
    @TableField(value="check_code")
    private String checkCode; // 校验码
    @TableField(value="invoice_type")
    private Long invoiceType; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    @TableField(value="invoice_type_name")
    private String invoiceTypeName; // 发票类型名称:1、增值税专用发票，2、增值税普通发票，3、其他；
    @TableField(value="supplier_name")
    private String supplierName; // 销方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 销方主键
    @TableField(value="invoice_mny")
    private java.math.BigDecimal invoiceMny; // 发票金额（不含税）
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税额
    @TableField(value="invoice_tax_mny")
    private java.math.BigDecimal invoiceTaxMny; // 价税合计
    @TableField(value="invoice_tax_mnys")
    private String invoiceTaxMnys; // 价税合计金额大写
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="auth_state")
    private Integer authState; // 认证状态：0未认证，1认证成功，2认证失败
    @TableField(value="auth_date")
    private java.util.Date authDate; // 认证日期
    @TableField(value="deduction_state")
    private Integer deductionState; // 是否抵扣(1:是，0：否)
    @TableField(value="receive_bill_code")
    private String receiveBillCode; // 收票登记单号
    @TableField(value="receive_bill_id")
    private Long receiveBillId; // 收票登记单id
    @TableField(value="content")
    private String content; // 发票内容
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="period_of_tax")
    private java.util.Date periodOfTax; // 纳税期间
    @TableField(value="auth_person")
    private String authPerson; // 认证人
    @TableField(value="actual_deduction_mny")
    private java.math.BigDecimal actualDeductionMny; // 实际抵扣发票金额
    @TableField(value="actual_deduction_tax")
    private java.math.BigDecimal actualDeductionTax; // 实际抵扣税额
    @TableField(value="contract_type")
    private String contractType; // 合同类型,1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="customer_id")
    private Long customerId; // 购方主键
    @TableField(value="customer_name")
    private String customerName; // 购方名称
    @TableField(value="customer_credit_code")
    private String customerCreditCode; // 纳税人识别号
    @TableField(value="supplier_credit_code")
    private String supplierCreditCode; // 销方纳税人识别号
    @TableField(value="type")
    private Integer type; // 开票类型:1,有合同,2,无合同
    @TableField(value="used_invoice_tax_mny")
    private java.math.BigDecimal usedInvoiceTaxMny; // 已使用金额
    @TableField(value="bill_code")
    private String billCode; // 申请单编码
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="depend_on_project")
    private String dependOnProject; // 是否属于项目,是-1,否-0
    @TableField(value="purchase_type")
    private String purchaseType; // 采购类型 1-自采，2-集采
    @TableField(value="flag")
    private Integer flag; // 是否被抵扣引用(1:是，0：否)
    @TableField(value="deduction_bill_id")
    private Long deductionBillId; // 抵扣单id
    @TableField(value="origin_type")
    private Integer originType; // 来源方式1、手动录入，2、扫码录入，3OCR扫描，4系统下载

    @TableField(value="regist")
    private Boolean regist; // 是否登记
    @TableField(value="buyer_bank_account")
    private String buyerBankAccount; // 购方开户行账号
    @TableField(value="buyer_addr_phone")
    private String buyerAddrPhone; // 购方地址电话
    @TableField(value="seller_bank_account")
    private String sellerBankAccount; // 销售方开户行账号
    @TableField(value="seller_addr_phone")
    private String sellerAddrPhone; // 销售方地址电话
    

    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 发票代码
     */
    public String getInvoiceCode() {
        return invoiceCode;
    }

    /**
     * 发票代码
     */
    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    /**
     * 发票号码
     */
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    /**
     * 发票号码
     */
    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    /**
     * 开票日期
     */
    public java.util.Date getInvoiceDate() {
        return invoiceDate;
    }

    /**
     * 开票日期
     */
    public void setInvoiceDate(java.util.Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    /**
     * 校验码
     */
    public String getCheckCode() {
        return checkCode;
    }

    /**
     * 校验码
     */
    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }
    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public Long getInvoiceType() {
        return invoiceType;
    }

    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    /**
     * 发票类型名称:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    /**
     * 发票类型名称:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    /**
     * 销方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 销方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 销方主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 销方主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 发票金额（不含税）
     */
    public java.math.BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    /**
     * 发票金额（不含税）
     */
    public void setInvoiceMny(java.math.BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 价税合计
     */
    public java.math.BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    /**
     * 价税合计
     */
    public void setInvoiceTaxMny(java.math.BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public String getInvoiceTaxMnys() {
        return invoiceTaxMnys;
    }

    public void setInvoiceTaxMnys(String invoiceTaxMnys) {
        this.invoiceTaxMnys = invoiceTaxMnys;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目主键
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目主键
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 认证状态：0未认证，1认证成功，2认证失败
     */
    public Integer getAuthState() {
        return authState;
    }

    /**
     * 认证状态：0未认证，1认证成功，2认证失败
     */
    public void setAuthState(Integer authState) {
        this.authState = authState;
    }
    /**
     * 认证日期
     */
    public java.util.Date getAuthDate() {
        return authDate;
    }

    /**
     * 认证日期
     */
    public void setAuthDate(java.util.Date authDate) {
        this.authDate = authDate;
    }
    /**
     * 是否抵扣(1:是，0：否)
     */
    public Integer getDeductionState() {
        return deductionState;
    }

    /**
     * 是否抵扣(1:是，0：否)
     */
    public void setDeductionState(Integer deductionState) {
        this.deductionState = deductionState;
    }
    /**
     * 收票登记单号
     */
    public String getReceiveBillCode() {
        return receiveBillCode;
    }

    /**
     * 收票登记单号
     */
    public void setReceiveBillCode(String receiveBillCode) {
        this.receiveBillCode = receiveBillCode;
    }
    /**
     * 收票登记单id
     */
    public Long getReceiveBillId() {
        return receiveBillId;
    }

    /**
     * 收票登记单id
     */
    public void setReceiveBillId(Long receiveBillId) {
        this.receiveBillId = receiveBillId;
    }
    /**
     * 发票内容
     */
    public String getContent() {
        return content;
    }

    /**
     * 发票内容
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 纳税期间
     */
    public java.util.Date getPeriodOfTax() {
        return periodOfTax;
    }

    /**
     * 纳税期间
     */
    public void setPeriodOfTax(java.util.Date periodOfTax) {
        this.periodOfTax = periodOfTax;
    }
    /**
     * 认证人
     */
    public String getAuthPerson() {
        return authPerson;
    }

    /**
     * 认证人
     */
    public void setAuthPerson(String authPerson) {
        this.authPerson = authPerson;
    }
    /**
     * 实际抵扣发票金额
     */
    public java.math.BigDecimal getActualDeductionMny() {
        return actualDeductionMny;
    }

    /**
     * 实际抵扣发票金额
     */
    public void setActualDeductionMny(java.math.BigDecimal actualDeductionMny) {
        this.actualDeductionMny = actualDeductionMny;
    }
    /**
     * 实际抵扣税额
     */
    public java.math.BigDecimal getActualDeductionTax() {
        return actualDeductionTax;
    }

    /**
     * 实际抵扣税额
     */
    public void setActualDeductionTax(java.math.BigDecimal actualDeductionTax) {
        this.actualDeductionTax = actualDeductionTax;
    }
    /**
     * 合同类型,1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    public String getContractType() {
        return contractType;
    }

    /**
     * 合同类型,1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织主键
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 购方主键
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 购方主键
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 购方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 购方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 纳税人识别号
     */
    public String getCustomerCreditCode() {
        return customerCreditCode;
    }

    /**
     * 纳税人识别号
     */
    public void setCustomerCreditCode(String customerCreditCode) {
        this.customerCreditCode = customerCreditCode;
    }
    /**
     * 销方纳税人识别号
     */
    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    /**
     * 销方纳税人识别号
     */
    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }
    /**
     * 开票类型:1,有合同,2,无合同
     */
    public Integer getType() {
        return type;
    }

    /**
     * 开票类型:1,有合同,2,无合同
     */
    public void setType(Integer type) {
        this.type = type;
    }
    /**
     * 已使用金额
     */
    public java.math.BigDecimal getUsedInvoiceTaxMny() {
        return usedInvoiceTaxMny;
    }

    /**
     * 已使用金额
     */
    public void setUsedInvoiceTaxMny(java.math.BigDecimal usedInvoiceTaxMny) {
        this.usedInvoiceTaxMny = usedInvoiceTaxMny;
    }
    /**
     * 申请单编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 申请单编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 是否属于项目,是-1,否-0
     */
    public String getDependOnProject() {
        return dependOnProject;
    }

    /**
     * 是否属于项目,是-1,否-0
     */
    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    /**
     * 采购类型 1-自采，2-集采
     */
    public String getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购类型 1-自采，2-集采
     */
    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 是否使用(1:是，0：否)
     */
    public Integer getFlag() {
        return flag;
    }

    /**
     * 是否使用(1:是，0：否)
     */
    public void setFlag(Integer flag) {
        this.flag = flag;
    }
    /**
     * 来源方式1、手动录入，2、扫码录入，3OCR扫描，4系统下载
     */
    public Integer getOriginType() {
        return originType;
    }

    /**
     * 来源方式0、默认生成，1、手动录入，2、扫码录入，3OCR扫描，4系统下载
     */
    public void setOriginType(Integer originType) {
        this.originType = originType;
    }

    public Long getDeductionBillId() {
        return deductionBillId;
    }

    public void setDeductionBillId(Long deductionBillId) {
        this.deductionBillId = deductionBillId;
    }

    public Boolean getRegist() {
        return regist;
    }

    public void setRegist(Boolean regist) {
        this.regist = regist;
    }

    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }

    public String getBuyerAddrPhone() {
        return buyerAddrPhone;
    }

    public void setBuyerAddrPhone(String buyerAddrPhone) {
        this.buyerAddrPhone = buyerAddrPhone;
    }

    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    public String getSellerAddrPhone() {
        return sellerAddrPhone;
    }

    public void setSellerAddrPhone(String sellerAddrPhone) {
        this.sellerAddrPhone = sellerAddrPhone;
    }
}
