package com.ejianc.business.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.resource.api.IResourceApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 收票登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("invoiceReceiveRegist")
public class InvoiceReceiveRegistController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IResourceApi resourceApi;
    @Autowired
    private IFaceAndIdCardService faceAndIdCardService;


    @Autowired
    private ICommonBusinessService invoiceReceiveRegist;

    @RequestMapping(value = "/testBpm", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> testBpm(Long id) {
        invoiceReceiveRegist.afterApprovalProcessor(id ,1, null);
        return CommonResponse.success("查询详情数据成功！",null);
    }



    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> saveOrUpdate(@RequestBody InvoiceReceiveRegistVO saveorUpdateVO) {
        InvoiceReceiveRegistEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceReceiveRegistEntity.class);
        service.insertOrUpdate(entity);
        InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryDetail(Long id) {
        InvoiceReceiveRegistEntity entity = service.selectById(id);
        InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveRegistVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceReceiveRegistVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询进项发票列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("sellerName");
        param.getFuzzyFields().add("buyerName");
        param.getFuzzyFields().add("processPersonName");
        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("processPersonId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("processPersonId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");

        }
        if(param.getParams().get("type") != null){
            if(param.getParams().get("type").getValue().equals("1")){
                param.getParams().put("contractId", new Parameter(QueryParam.NE, null));
            }else if(param.getParams().get("type").getValue().equals("2")){
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, null));
            }
            param.getParams().remove("type");

        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceReceiveRegistEntity> page = service.queryPage(param,false);
        IPage<InvoiceReceiveRegistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceiveRegistVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "receivePool-import.xlsx", "收票登记发票导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<InvoiceReceivePoolVO> errorList = new ArrayList<>();
            List<InvoiceReceivePoolVO> successList = new ArrayList<>();
            CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String,String> defMap =getDefMap(defList.getData());
            if(result != null && result.size() > 0) {
                for(int i=0;i<result.size();i++) {
                    InvoiceReceivePoolVO s = new InvoiceReceivePoolVO();
                    List<String> row = result.get(i);
                    if(StringUtils.isEmpty(row.get(0)) || !("增值税专用发票".equals(row.get(0)) || "增值税普通发票".equals(row.get(0)) || "其它".equals(row.get(0)))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票类型选择不正确！");
                    }else {
                        String invoiceType= defMap.get(row.get(0));
                        s.setInvoiceType(Long.valueOf(invoiceType));
                    }
                    s.setInvoiceTypeName(row.get(0));
                    if(StringUtils.isEmpty(row.get(1))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票代码不能为空！");
                    }else {
                        s.setInvoiceCode(row.get(1));
                    }
                    if(StringUtils.isEmpty(row.get(2))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票号码不能为空！");
                    }else {
                        s.setInvoiceNumber(row.get(2));
                    }
                    if(StringUtils.isEmpty(row.get(3))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：开票日期不能为空！");
                    }else {
                        try {
                            s.setInvoiceDate(DateFormatUtil.parseDate("yyyy-MM-dd",row.get(3)));
                        }catch (ParseException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：开票日期格式不正确！");
                            s.setInvoiceDate(null);
                        }
                    }

                    if(StringUtils.isEmpty(row.get(4))){
                        s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票金额(不含税)不能为空！");
                    }else {
                        try {
                            s.setInvoiceMny(new BigDecimal(row.get(4)));
                        }catch (NumberFormatException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：发票金额(不含税)不是正确的数字格式！");
                            s.setInvoiceMny(null);
                        }
                    }
                    if(StringUtils.isNotEmpty(row.get(5))){
                        try {
                            s.setTaxMny(new BigDecimal(row.get(5)));
                        }catch (NumberFormatException e) {
                            s.setErrorMessage("第"+i+"行数据：导入失败，原因：税额不是正确的数字格式！");
                            s.setTaxMny(null);
                        }
                    }

                    if(StringUtils.isNotEmpty(row.get(6))){
                        s.setContent(row.get(6));
                    }

                    if(s.getInvoiceMny()!=null && s.getTaxMny()!=null){
                        s.setInvoiceTaxMny(s.getTaxMny().add(s.getInvoiceMny()));
                    }
                    if(StringUtils.isEmpty(s.getErrorMessage())){
                        successList.add(s);
                    }else {
                        errorList.add(s);
                    }



                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("sellerName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceReceiveRegistEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceReceiveRegistVO> voList = new ArrayList<InvoiceReceiveRegistVO>();

        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceiveRegistVO r = BeanMapper.map(pool, InvoiceReceiveRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceive-export.xlsx", beans, response);
    }

    /**
     * @Description queryBuyerName 查询无合同收票单购方名称
     * @param vo
     */
    @RequestMapping(value = "/queryBuyerName", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryBuyerName(@RequestBody InvoiceReceiveRegistVO vo) {
        QueryWrapper<InvoiceReceiveRegistEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(vo.getDependOnProject().equals(1)?"project_id":"org_id",vo.getBuyerHisQueryId());
        queryWrapper.isNull("contract_id");
        queryWrapper.in("bill_state", Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
        queryWrapper.orderByDesc("regist_date").last("limit 1");
        InvoiceReceiveRegistEntity one = service.getOne(queryWrapper);
        InvoiceReceiveRegistVO ivo = null;
        if(one!=null){
            ivo = BeanMapper.map(one, InvoiceReceiveRegistVO.class);
        }
        return CommonResponse.success("查询成功！",ivo);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {

        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    /** 发票上传 并识别 验真 */
    @PostMapping(value = "/uploadFilesAndCheck")
    @ResponseBody
    public CommonResponse<List<InvoiceReceivePoolVO>> uploadFilesAndCheck(@RequestBody List<AttachmentVO> files) {

        CommonResponse<Boolean> invoiceIdentification = resourceApi.checkResource("invoiceIdentificationNum",InvocationInfoProxy.getTenantid());
        if(!invoiceIdentification.isSuccess() || !invoiceIdentification.getData()){
            return CommonResponse.error("贵公司尚未购买发票识别服务，该功能不可用！如有需求请联系实施人员！");
        }

        if(ListUtil.isEmpty(files)){
            return CommonResponse.error("没有可识别的文件！");
        }
//        CommonResponse<List<DefdocDetailVO>> response = defdocApi.getDefDocDetailByDefCodeAndTenantId("tax-invoice-type",InvocationInfoProxy.getTenantid());
        CommonResponse<String> response = faceAndIdCardService.getRecognizeInvoiceNum();
        if(!response.isSuccess()){
            return CommonResponse.error(response.getMsg());
        }
        int num = Integer.parseInt(response.getData());
        if(num<=0 || num<files.size()){
            return CommonResponse.error("发票识别服务数量已用尽，续费后继续使用！如有需求请联系实施人员！");
        }
        List<InvoiceReceivePoolVO> resList = new ArrayList<>();
        String msg = null;
        for (AttachmentVO file : files) {
            InvoiceReceivePoolVO poolVO = new InvoiceReceivePoolVO();
            poolVO.setRowState("add");
            poolVO.setId(IdWorker.getId());
            poolVO.setFileId(file.getId().toString());
            poolVO.setFileName(file.getFileName());
            poolVO.getAttachIds().add(file.getId());

            String fileUrl = file.getImgServerPath()+file.getFilePath();
            String[] names = file.getFileName().split("\\.");
            String fileType = names[names.length-1].toLowerCase();
            CommonResponse<JSONObject>  recognizeRes = faceAndIdCardService.recognizeInvoiceInfo(fileUrl,fileType);
            if(recognizeRes.isSuccess()){
                JSONObject result = recognizeRes.getData();
                poolVO.setIdentifyResult(result.toJSONString());
                poolVO.setInvoiceDate(result.getDate("InvoiceDate"));
                poolVO.setInvoiceCode(result.getString("InvoiceCode"));
                poolVO.setInvoiceNumber(result.getString("InvoiceNo"));
                poolVO.setInvoiceMny(result.getBigDecimal("WithoutTaxAmount"));
                poolVO.setTaxMny(result.getBigDecimal("TaxAmount"));
                poolVO.setInvoiceTaxMny(result.getBigDecimal("InvoiceAmount"));
                poolVO.setInvoiceTaxMnys(result.getString("SumAmount"));
                poolVO.setCheckCode(result.getString("AntiFakeCode"));
                poolVO.setCustomerName(result.getString("PayerName"));
                poolVO.setCustomerCreditCode(result.getString("PayerRegisterNo"));
                poolVO.setBuyerAddrPhone(result.getString("PayerAddress"));
                poolVO.setBuyerBankAccount(result.getString("PayerBankName"));
                poolVO.setSupplierName(result.getString("PayeeName"));
                poolVO.setSupplierCreditCode(result.getString("PayeeRegisterNo"));
                poolVO.setSellerAddrPhone(result.getString("PayeeBankName"));
                poolVO.setSellerBankAccount(result.getString("PayeeAddress"));
                poolVO.setOriginType(3);
            }else {
                String resMsg =recognizeRes.getMsg();
                if(resMsg!=null && resMsg.contains("剩余数量不足以进行此次扣减操作")){
                    msg = "发票识别服务数量已用尽，续费后继续使用！如有需求请联系实施人员！";
                    break;
                }
                poolVO.setIdentifyResult("识别异常:"+resMsg);
            }
            resList.add(poolVO);
        }
        return CommonResponse.success(msg,resList);
    }


    /** 发票手动验真 */
    @PostMapping(value = "/checkByHands")
    @ResponseBody
    public CommonResponse<List<InvoiceReceivePoolVO>> checkByHands(@RequestBody List<InvoiceReceivePoolVO> sourceList) {
        CommonResponse<Boolean> invoiceVerification = resourceApi.checkResource("invoiceVerificationNum",InvocationInfoProxy.getTenantid());
        if(!invoiceVerification.isSuccess() || !invoiceVerification.getData()){
            return CommonResponse.error("贵公司尚未购买发票验真服务，该功能不可用！如有需求请联系实施人员！");
        }else {
            CommonResponse<String> response = faceAndIdCardService.getAuthInvoiceNum();
            if(!response.isSuccess()){
                return CommonResponse.error(response.getMsg());
            }
            int num = Integer.parseInt(response.getData());
            if(num<=0 || num<sourceList.size()){
                return CommonResponse.error("发票验真服务数量已用尽，续费后继续使用！如有需求请联系实施人员！");
            }
            /** 进行发票验真 */
            String msg = null;
            List<InvoiceReceivePoolVO> resList = new ArrayList<>();
            for (InvoiceReceivePoolVO poolVO : sourceList) {
                Map<String, String> map = new HashMap<>();
                if(!poolVO.getIdentifyResult().contains("识别异常")){
                    map.put("fpdm",poolVO.getInvoiceCode());
                    map.put("fphm",poolVO.getInvoiceNumber());
                    map.put("kprq",DateFormatUtil.formatDate("yyyyMMdd",poolVO.getInvoiceDate()));
                    map.put("xym",poolVO.getCheckCode());
                    JSONObject identifyResult = JSONObject.parseObject(poolVO.getIdentifyResult());
                    if(StringUtils.isNotEmpty(poolVO.getInvoiceNumber()) && poolVO.getInvoiceNumber().length() == 20){
                        /**
                         * 电子发票（增值税专用发票）、电子发票（普通发票）：发票号码（20位）、开票日期、价税合计；
                         * 电子发票（航空运输电子客票行程单）：发票号码（20位）、开票日期、开票金额（价税合计）。
                         * */
                        map.put("bhsje",identifyResult.getString("InvoiceAmount"));
                    }else {
                        map.put("bhsje",identifyResult.getString("WithoutTaxAmount"));
                    }
                    CommonResponse<JSONObject> authRes = faceAndIdCardService.authInvoiceInfo(map);
                    if(authRes.isSuccess()){
                        JSONObject result = authRes.getData();
                        poolVO.setCheckResult(result.getString("result"));
                    }else {
                        String resMsg =authRes.getMsg();
                        if(resMsg!=null && resMsg.contains("剩余数量不足以进行此次扣减操作")){
                            msg = "发票验真服务数量已用尽，续费后继续使用！如有需求请联系实施人员！";
                            break;
                        }
                        poolVO.setCheckResult("验真异常："+authRes.getMsg());
                    }
                    resList.add(poolVO);
                }
            }
            return CommonResponse.success(msg,resList);
        }
    }
}
