package com.ejianc.business.taxnew.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.sub.api.ISubContractInvoiceReceiveApi;
import com.ejianc.business.taxnew.bean.InvoiceDeducApplySubEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplySubService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("invoiceReceiveRegist") 
public class InvoiceReceiveRegistBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IEquipmentContractApi equipmentContractApi;
	@Autowired
	private ISubContractInvoiceReceiveApi subContractInvoiceReceiveApi;

	@Autowired
	private IInvoiceReceiveRegistService service;

	@Autowired
	private IInvoiceDeducApplySubService applySubService;

	@Autowired
	private IInvoiceReceivePoolService invoiceReceivePoolService;

	@Autowired
	private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		InvoiceReceiveRegistEntity invoiceReceiveEntity = service.selectById(billId);
		if (ListUtil.isNotEmpty(invoiceReceiveEntity.getInvoiceReceiveList())) {
			invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> {
				sub.setBillState(state);
				sub.setRegist(true);
				sub.setCreateUserCode(invoiceReceiveEntity.getCreateUserCode());
				sub.setCreateTime(invoiceReceiveEntity.getCreateTime());
			});
		} else {
			// 无子表，自动生成一条
			List<InvoiceReceivePoolEntity> list = service.generateInvoiceReceivePool(invoiceReceiveEntity);
			list.forEach(sub -> {
				sub.setBillState(state);
				sub.setRegist(true);
				sub.setCreateUserCode(invoiceReceiveEntity.getCreateUserCode());
				sub.setCreateTime(invoiceReceiveEntity.getCreateTime());
			});
			invoiceReceiveEntity.setInvoiceReceiveList(list);
			invoiceReceiveEntity.setInvoiceQuantity(1);
		}
		service.saveOrUpdateNoES(invoiceReceiveEntity);
		if (null != invoiceReceiveEntity.getContractId() && ListUtil.isNotEmpty(invoiceReceiveEntity.getInvoiceReceiveList())){
			if (invoiceReceiveEntity.getReceiveType() == 1){//分包
				invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub-> {
					CommonResponse<String> stringCommonResponse = subContractInvoiceReceiveApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
					if (!stringCommonResponse.isSuccess()) {
						logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
					}
				});
			}
			if (invoiceReceiveEntity.getReceiveType() == 2){
				invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub-> {
					CommonResponse<String> stringCommonResponse = equipmentContractApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
					if (!stringCommonResponse.isSuccess()) {
						logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
					}
				});
			}
			if (invoiceReceiveEntity.getReceiveType() == 3){
				invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub-> {
					CommonResponse<String> stringCommonResponse = equipmentContractApi.rentAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
					if (!stringCommonResponse.isSuccess()) {
						logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
					}
				});
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		List<String> msg = new ArrayList<>();
		List<Long> subIds = new ArrayList<>();
		InvoiceReceiveRegistEntity entity = service.selectById(billId);
		if(ListUtil.isNotEmpty(entity.getInvoiceReceiveList())){
			entity.getInvoiceReceiveList().forEach(sub-> {
				if(sub.getAuthState()!=0){
					msg.add("本次登记中，发票代码【"+sub.getInvoiceCode()+"】，发票号码【"+sub.getInvoiceNumber()+"】已认证，无法撤回或者弃审单据！");
				}
				subIds.add(sub.getId());
			});
		}
		if(msg.size()>0){
			return CommonResponse.error(msg.get(0));
		}
		if(ListUtil.isNotEmpty(subIds)){
			QueryParam param = new QueryParam();
			param.getParams().put("invoiceId",new Parameter(QueryParam.IN,subIds));
			List<InvoiceDeducApplySubEntity> subEntities = applySubService.queryList(param);
			if(ListUtil.isNotEmpty(subEntities)){
				InvoiceDeducApplySubEntity sub = subEntities.get(0);
				return CommonResponse.error("本次登记中，发票代码【"+sub.getInvoiceCode()+"】，发票号码【"+sub.getInvoiceNumber()+"】已进行抵扣申请，无法撤回或者弃审单据！");
			}
		}

		//合同是否被其他单据引用
		QueryWrapper<InvoiceReceivePoolEntity> queryWrapper = new QueryWrapper();
		queryWrapper.eq("receive_bill_id",billId);
		queryWrapper.eq("dr",0);
		List<InvoiceReceivePoolEntity> poolEntities = invoiceReceivePoolService.list(queryWrapper);
		if(ListUtil.isNotEmpty(poolEntities)){
			for (InvoiceReceivePoolEntity poolEntity : poolEntities) {
				CommonResponse<String>  res = billTypeApi.checkQuote("BT200606000000001",poolEntity.getId());
				logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
				if(!res.isSuccess()) {//单据未被下游单据引用
					return CommonResponse.error("该单据已被下游单据（合同/报销/零星关联发票实体）引用");
				}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		InvoiceReceiveRegistEntity invoiceReceiveEntity = service.selectById(billId);
		if(ListUtil.isNotEmpty(invoiceReceiveEntity.getInvoiceReceiveList())){
			invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub->sub.setBillState(0));
		}
		service.saveOrUpdateNoES(invoiceReceiveEntity);
		if (null != invoiceReceiveEntity.getContractId() && ListUtil.isNotEmpty(invoiceReceiveEntity.getInvoiceReceiveList())){
			if (invoiceReceiveEntity.getReceiveType() == 1){//分包
				invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub-> {
					CommonResponse<JSONObject> stringCommonResponse = subContractInvoiceReceiveApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
					if (!stringCommonResponse.isSuccess()) {
						logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
					}
				});
			}
			if (invoiceReceiveEntity.getReceiveType() == 2){
				invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub-> {
					CommonResponse<JSONObject> stringCommonResponse = equipmentContractApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
					if (!stringCommonResponse.isSuccess()) {
						logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
					}
				});
			}
			if (invoiceReceiveEntity.getReceiveType() == 3){
				invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub-> {
					CommonResponse<JSONObject> stringCommonResponse = equipmentContractApi.rentAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
					if (!stringCommonResponse.isSuccess()) {
						logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
					}
				});
			}
		}
		return CommonResponse.success();
	}

}
