package com.ejianc.business.taxnew.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 开票申请-对甲报量
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_open_apply_quote")
public class InvoiceOpenApplyQuoteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="apply_id")
    private Long applyId; // 申请单id
    @TableField(value="quote_id")
    private Long quoteId; // 甲方报量Id
    @TableField(value="quote_code")
    private String quoteCode; // 甲方报量编码
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="quote_tax_mny")
    private BigDecimal quoteTaxMny; // 本期报量金额
    @TableField(value="quote_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date quoteDate; // 报量时间
    @TableField(value="quote_memo")
    private String quoteMemo; // 描述

    @TableField(value="origin_quote_tax_mny")
    private BigDecimal originQuoteTaxMny; // 报量金额 报量单上原始的报量金额

    @TableField(value="surplus_quote_tax_mny")
    private BigDecimal surplusQuoteTaxMny; // 剩余报量金额


    public BigDecimal getOriginQuoteTaxMny() {
        return originQuoteTaxMny;
    }

    public void setOriginQuoteTaxMny(BigDecimal originQuoteTaxMny) {
        this.originQuoteTaxMny = originQuoteTaxMny;
    }

    public BigDecimal getSurplusQuoteTaxMny() {
        return surplusQuoteTaxMny;
    }

    public void setSurplusQuoteTaxMny(BigDecimal surplusQuoteTaxMny) {
        this.surplusQuoteTaxMny = surplusQuoteTaxMny;
    }

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public String getQuoteCode() {
        return quoteCode;
    }

    public void setQuoteCode(String quoteCode) {
        this.quoteCode = quoteCode;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    public Date getQuoteDate() {
        return quoteDate;
    }

    public void setQuoteDate(Date quoteDate) {
        this.quoteDate = quoteDate;
    }
    public String getQuoteMemo() {
        return quoteMemo;
    }

    public void setQuoteMemo(String quoteMemo) {
        this.quoteMemo = quoteMemo;
    }
    
}
