/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.constructor.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.bean.FazdEntity;
import com.ejianc.business.constructor.service.IFazdService;
import com.ejianc.business.constructor.vo.FazdVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fazd"})
public class FazdController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "fazd";
    @Autowired
    private IFazdService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FazdVO> saveOrUpdate(@RequestBody FazdVO saveOrUpdateVO) {
        FazdEntity entity = (FazdEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FazdEntity.class));
        if (entity.getPid() != null) {
            entity.setChildFlag(1);
        } else {
            entity.setChildFlag(0);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FazdVO vo = (FazdVO)BeanMapper.map((Object)((Object)entity), FazdVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FazdVO> queryDetail(Long id) {
        FazdEntity entity = (FazdEntity)((Object)this.service.selectById(id));
        FazdVO vo = (FazdVO)BeanMapper.map((Object)((Object)entity), FazdVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FazdVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FazdVO fazdVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().clear();
        param.getOrderMap().put("qbm", "asc");
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.pageList(param));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getOrderMap().clear();
        param.getOrderMap().put("qbm", "asc");
        JSONObject pageList = this.service.pageList(param);
        JSONArray jsonArray = pageList.getJSONArray("records");
        List fazdVOS = jsonArray.toJavaList(FazdVO.class);
        ArrayList<FazdVO> list = new ArrayList<FazdVO>();
        for (FazdVO fazdVO : fazdVOS) {
            list.add(fazdVO);
            List children = fazdVO.getChildren();
            list.addAll(children);
        }
        HashMap<String, ArrayList<FazdVO>> beans = new HashMap<String, ArrayList<FazdVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Fazd-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFazdData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FazdVO>> refFazdData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("qbm");
        fuzzyFields.add("mc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject con = JSONObject.parseObject((String)condition);
            Long mark = con.getLong("pid");
            param.getParams().put("pid", new Parameter("eq", (Object)mark));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FazdVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/addChildByPId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FazdVO> addChildByPId(Long pid) {
        FazdVO vo = this.service.addChildByPId(pid);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/refFazdTreeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FazdVO>> refFazdTreeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText, String relyCondition) {
        JSONObject con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("qbm");
        fuzzyFields.add("mc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (con = JSONObject.parseObject((String)condition)).get((Object)"pid")) {
            param.getParams().put("pid", new Parameter("eq", (Object)con.getLong("pid")));
        }
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            Long pid = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("pid", new Parameter("eq", (Object)pid));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FazdVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/lazyFazdTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyFazdTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List<FazdVO> dataList = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
            }
            dataList = this.service.queryListTree(params);
            List maps = BeanMapper.mapList(dataList, Map.class);
            for (Map map : maps) {
                String name = map.get("mc").toString();
                map.remove("mc");
                map.put("name", name);
                String parentId = map.get("pid") != null ? map.get("pid").toString() : "";
                map.remove("pid");
                map.put("parentId", parentId);
            }
            return ResultAsTree.createTreeData((List)maps);
        }
        catch (Exception e) {
            return null;
        }
    }
}

