package com.ejianc.business.constructor.controller;

import java.io.Serializable;

import com.ejianc.business.constructor.bean.SfhsfaEntity;
import com.ejianc.business.constructor.vo.SfhsfaVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.constructor.bean.ZjlzfaEntity;
import com.ejianc.business.constructor.service.IZjlzfaService;
import com.ejianc.business.constructor.vo.ZjlzfaVO;

/**
 * 专家论证方案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("zjlzfa")
public class ZjlzfaController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zjlzfa";//此处需要根据实际修改

    @Autowired
    private IZjlzfaService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ZjlzfaVO> saveOrUpdate(@RequestBody ZjlzfaVO saveOrUpdateVO) {
    	ZjlzfaEntity entity = BeanMapper.map(saveOrUpdateVO, ZjlzfaEntity.class);
        UserContext userContextCache =sessionManager.getUserContext();
    	if(entity.getId() == null || entity.getId() == 0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setTags("zjlzfa");
        entity.setDocsource(1);
    	service.saveOrUpdate(entity, false);
    	ZjlzfaVO vo = BeanMapper.map(entity, ZjlzfaVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ZjlzfaVO> queryDetail(Long id) {
    	ZjlzfaEntity entity = service.selectById(id);
    	ZjlzfaVO vo = BeanMapper.map(entity, ZjlzfaVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ZjlzfaVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ZjlzfaVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ZjlzfaVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ZjlzfaVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询条件
        fuzzyFields.add("famc");  //方案名称
        fuzzyFields.add("falxName"); //方案乐行
        fuzzyFields.add("gcxmmcName"); //项目名称
        fuzzyFields.add("sgdwName"); //施工单位名称
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");

            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                //普通组织
                commonOrgIds.add(org.getId());
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ZjlzfaEntity> page = service.queryPage(param,false);
        IPage<ZjlzfaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ZjlzfaVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("famc");  //方案名称
        fuzzyFields.add("falxName"); //方案乐行
        fuzzyFields.add("gcxmmcName"); //项目名称
        fuzzyFields.add("sgdwName"); //施工单位名称
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ZjlzfaEntity> list = service.queryList(param);
        List<ZjlzfaVO> vos = new ArrayList<>();
        if(ListUtil.isNotEmpty(list)){
            vos = BeanMapper.mapList(list, ZjlzfaVO.class);
            for (ZjlzfaVO vo : vos) {
                if(vo.getJlsq() != null){
                    switch (vo.getJlsq()){
                        case 0:
                            vo.setJlsqName("是");
                            break;
                        case 1:
                            vo.setJlsqName("否");
                            break;
                    }
                }
                if(vo.getDocsource() != null){
                    switch (vo.getDocsource()){
                        case 0:
                            vo.setDocsourceName("已上传");
                            break;
                        case 1:
                            vo.setDocsourceName("未上传");
                            break;
                    }
                }
                if(vo.getGd() != null){
                    switch (vo.getGd()){
                        case 0:
                            vo.setGdName("已归档");
                            break;
                        case 1:
                            vo.setGdName("未归档");
                            break;
                    }
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Zjlzfa-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refZjlzfaData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ZjlzfaVO>> refZjlzfaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("projectId")){
                param.getParams().put("gcxmmc_id", new Parameter(QueryParam.EQ, _con.getLong("projectId")));
            } else {
                return CommonResponse.error("请先选择项目！");
            }
        }

        IPage<ZjlzfaEntity> page = service.queryPage(param,false);
        IPage<ZjlzfaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ZjlzfaVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description 修改附件信息
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ZjlzfaVO> update(@RequestBody ZjlzfaVO updateVO) {
        ZjlzfaEntity sfhsfaEntity = service.selectById(updateVO.getId());
        sfhsfaEntity.setBilltype(updateVO.getBilltype());
        sfhsfaEntity.setFileid(updateVO.getFileid());
        sfhsfaEntity.setFilename(updateVO.getFilename());
        sfhsfaEntity.setFilesize(updateVO.getFilesize());
        sfhsfaEntity.setFilepath(updateVO.getFilepath());
        sfhsfaEntity.setOnlinepath(updateVO.getOnlinepath());
        sfhsfaEntity.setSuperviseuserid(updateVO.getSuperviseuserid());
        sfhsfaEntity.setSuperviseusername(updateVO.getSuperviseusername());
        sfhsfaEntity.setSupervisetime(updateVO.getSupervisetime());
        sfhsfaEntity.setDocsource(updateVO.getDocsource());
        sfhsfaEntity.setSourceid(updateVO.getSourceid());
        sfhsfaEntity.setOrgidfield(updateVO.getOrgidfield());
        sfhsfaEntity.setProjectidfield(updateVO.getProjectidfield());


        sfhsfaEntity.setDetailpageurl(updateVO.getDetailpageurl());
        sfhsfaEntity.setBillcodefield(updateVO.getBillcodefield());

        //从文件名获取文件后缀
//        String filename = updateVO.getFilename();
//        String substring = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
        sfhsfaEntity.setFiletype(updateVO.getFiletype());


        if (updateVO.getGd().equals(0)){
            sfhsfaEntity.setGd(0);
        }

        service.updateById(sfhsfaEntity);
        return CommonResponse.success("保存或修改单据成功！");
    }
}
