package com.ejianc.business.constructor.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.constructor.bean.*;
import com.ejianc.business.constructor.service.*;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;

@Service("faSeal") 
public class FaSealBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISfhsfaService sfhsfaService;

	@Autowired
	private IZjlzfaService zjlzfaService;

	@Autowired
	private IAqbshfaService aqbshfaService;

	@Autowired
	private IGcbshfaService gcbshfaService;

	@Autowired
	private IJszxfaService jszxfaService;

	@Autowired
	private IFaSealService faSealService;

	@Autowired
	private IXmshfaService xmshfaService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectPoolApi projectPoolApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		FaSealEntity faSealEntity = faSealService.selectById(billId);

		String operatorName = faSealEntity.getOperatorName();
		if(StringUtils.isNotEmpty(operatorName)){

			if("三方会审".equals(operatorName)){
				SfhsfaEntity sfhsfaEntity = sfhsfaService.selectById(faSealEntity.getSourceId());
				sfhsfaEntity.setGd(0);
				sfhsfaService.saveOrUpdate(sfhsfaEntity);

			} else if("专家论证".equals(operatorName)){
				ZjlzfaEntity zjlzfaEntity = zjlzfaService.selectById(faSealEntity.getSourceId());
				zjlzfaEntity.setGd(2);
				zjlzfaService.saveOrUpdate(zjlzfaEntity);
			} else if("安全部审核".equals(operatorName)){
				AqbshfaEntity entity = aqbshfaService.selectById(faSealEntity.getSourceId());
				entity.setGd(2);
				aqbshfaService.saveOrUpdate(entity);
			}else if("工程部审核".equals(operatorName)){
				GcbshfaEntity entity = gcbshfaService.selectById(faSealEntity.getSourceId());
				entity.setGd(2);
				gcbshfaService.saveOrUpdate(entity);
			}else if("技术中心审核".equals(operatorName)){
				JszxfaEntity entity = jszxfaService.selectById(faSealEntity.getSourceId());
				entity.setGd(2);
				jszxfaService.saveOrUpdate(entity);
			}else if("项目审核".equals(operatorName)){
				XmshfaEntity entity = xmshfaService.selectById(faSealEntity.getSourceId());
				entity.setGd(2);
				xmshfaService.saveOrUpdate(entity);
			}
			return CommonResponse.success();

		}
		return CommonResponse.error("未获取到方案所属类型！");


	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseProjectUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息
			FaSealEntity entity = faSealService.selectById(billId);
			Long projectId = entity.getGcxmmcId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long patrolManager = vo.getPatrolManager();
			String patrolManagerName = vo.getPatrolManagerName();

			logger.info("userId:{}",patrolManager);
			logger.info("userName:{}",patrolManagerName);


			jsonObject.put("userId",patrolManager);
			jsonObject.put("userName",patrolManagerName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
