package com.ejianc.business.constructor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.constructor.vo.FazdVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.constructor.mapper.FazdMapper;
import com.ejianc.business.constructor.bean.FazdEntity;
import com.ejianc.business.constructor.service.IFazdService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 方案字典实体
 * 
 * @author generator
 * 
 */
@Service("fazdService")
public class FazdServiceImpl extends BaseServiceImpl<FazdMapper, FazdEntity> implements IFazdService{

    @Autowired
    private FazdMapper fazdMapper;

    @Override
    public JSONObject pageList(QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        int total = 0; // 总条数
        int pages = 0; // 有几页

        /** 模糊搜索配置字段示例 */
        /*List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");*/

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
       /* if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }*/
        param.getParams().put("childFlag",new Parameter(QueryParam.EQ, 0));

        // 查出来非补充协议的合同
        List<FazdEntity> entityList = this.queryList(param);
        List<FazdEntity> list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        List<FazdVO> voList = BeanMapper.mapList(list, FazdVO.class);
        List<Long> idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());

        // 根据合同查出来补充协议
        QueryParam childrenParam = Utils.deepCopy(param);
        if (ListUtil.isNotEmpty(idList)) {
            childrenParam.getParams().put("pid", new Parameter(QueryParam.IN, idList));
        }
//        childrenParam.getParams().remove("supplementFlag");
        childrenParam.getParams().put("childFlag",new Parameter(QueryParam.EQ, "1"));
        List<FazdEntity> childrenList = this.queryList(childrenParam);
        List<FazdVO> childrenVoList = BeanMapper.mapList(childrenList, FazdVO.class);
        Map<Long, List<FazdVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(FazdVO::getPid));

        if (param.getSearchText() != null && ListUtil.isNotEmpty(childrenVoList)) {
            List<Long> childrenIdList = new ArrayList<>(childrenMap.keySet());
            param.getParams().put("id", new Parameter(QueryParam.IN, childrenIdList));
            // 搜索补充协议编码，主合同为空。清空搜索条件
            if (ListUtil.isEmpty(entityList)) {
                param.setSearchText(null);
            }
            List<FazdEntity> newEntityList = this.queryList(param);
            // 搜索非补充协议编码，两个结果合并
            entityList.addAll(newEntityList);
            entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                    new TreeSet<>(Comparator.comparing(FazdEntity::getId))), ArrayList::new));
            entityList = entityList.stream().sorted(Comparator.comparing(FazdEntity::getCreateTime).reversed()).collect(Collectors.toList());
            list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
            voList = BeanMapper.mapList(list, FazdVO.class);
        }

        if (ListUtil.isNotEmpty(voList)) {
            // 拼装数据
            for (FazdVO vo : voList) {
                if (childrenMap.containsKey(vo.getId())) {
                    vo.setChildren(childrenMap.get(vo.getId()));
                }
            }
        }

        total = entityList.size();
        if (total % pageSize > 0) {
            pages = (total / pageSize) + 1;
        } else if (total % pageSize == 0) {
            pages = total / pageSize;
        }

        JSONObject page = new JSONObject();
        page.put("records", voList);
        page.put("total", total);
        page.put("current", pageIndex);
        page.put("size", pageSize);
        page.put("pages", pages);

        return page;
    }

    @Override
    public FazdVO addChildByPId(Long pid) {
        FazdVO fazdVO = new FazdVO();
        fazdVO.setPid(pid);
        return null;
    }

    @Override
    public List<FazdVO> queryListTree(Map<String, Object> params) {
        List<FazdVO> fazdVOS = fazdMapper.queryListTree(params);
        return fazdVOS;
    }
}
