package com.ejianc.business.tender.prosub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;


/**
 * 招标文件专家表
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件专家表")
public class ProsubDocumentExpertVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表主键")
    private Long documentId;
    @ApiModelProperty("专家ID")
    private Long expertId;
    @ApiModelProperty("专家名称")
    private String expertName;
    @ApiModelProperty("所属单位ID")
    private Long unitId;
    @ApiModelProperty("所属单位名称")
    private String unitName;
    @ApiModelProperty("手机号")
    private String mobile;
    @ApiModelProperty("专业领域")
    private String fieldName;
    @ApiModelProperty("评标状态（0-待评标，1-已评标，2-已失效,3-已驳回）")
    private Integer evaluationState;
    @ApiModelProperty("专家评标主键")
    private Long evaluationId;
    @ApiModelProperty("岗位名称")
    private String postName;
    @ApiModelProperty("类型name")
    private String typeName;
    @ApiModelProperty("级别name")
    private String gradeName;
    @ApiModelProperty("选取方式")
    private String selectionType;
    @ApiModelProperty("评标时间")
    private Date evaluationTime;
    @ApiModelProperty("专家库主键")
    private Long specialistId; // 专家库主键
    private Long deptId; // 部门id
    private String deptName; // 部门名称
    private java.lang.Long expertFrom; // 专家来源(例如：集团、项目)
    private java.lang.String expertFromName; // 专家来源名称

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getSpecialistId() {
        return specialistId;
    }

    public void setSpecialistId(Long specialistId) {
        this.specialistId = specialistId;
    }

    /**
     * 主表主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 主表主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 专家ID
     */
    public Long getExpertId() {
        return expertId;
    }

    /**
     * 专家ID
     */
    public void setExpertId(Long expertId) {
        this.expertId = expertId;
    }
    /**
     * 专家名称
     */
    public String getExpertName() {
        return expertName;
    }

    /**
     * 专家名称
     */
    public void setExpertName(String expertName) {
        this.expertName = expertName;
    }
    /**
     * 所属单位ID
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 所属单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 所属单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 所属单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 手机号
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * 手机号
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    /**
     * 专业领域
     */
    public String getFieldName() {
        return fieldName;
    }

    /**
     * 专业领域
     */
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
    /**
     * 评标状态（0-待评标，1-已评标，2-已失效,3-已驳回）
     */
    public Integer getEvaluationState() {
        return evaluationState;
    }

    /**
     * 评标状态（0-待评标，1-已评标，2-已失效,3-已驳回）
     */
    public void setEvaluationState(Integer evaluationState) {
        this.evaluationState = evaluationState;
    }
    /**
     * 专家评标主键
     */
    public Long getEvaluationId() {
        return evaluationId;
    }

    /**
     * 专家评标主键
     */
    public void setEvaluationId(Long evaluationId) {
        this.evaluationId = evaluationId;
    }
    /**
     * 岗位名称
     */
    public String getPostName() {
        return postName;
    }

    /**
     * 岗位名称
     */
    public void setPostName(String postName) {
        this.postName = postName;
    }
    /**
     * 类型name
     */
    public String getTypeName() {
        return typeName;
    }

    /**
     * 类型name
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    /**
     * 级别name
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 级别name
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 选取方式
     */
    public String getSelectionType() {
        return selectionType;
    }

    /**
     * 选取方式
     */
    public void setSelectionType(String selectionType) {
        this.selectionType = selectionType;
    }
    /**
     * 评标时间
     */
    public Date getEvaluationTime() {
        return evaluationTime;
    }

    /**
     * 评标时间
     */
    public void setEvaluationTime(Date evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    /**
     * 专家来源
     */
    public Long getExpertFrom() {
        return expertFrom;
    }
    /**
     * 专家来源
     */
    public void setExpertFrom(Long expertFrom) {
        this.expertFrom = expertFrom;
    }
    /**
     * 专家来源名称
     */
    public String getExpertFromName() {
        return expertFromName;
    }
    /**
     * 专家来源名称
     */
    public void setExpertFromName(String expertFromName) {
        this.expertFromName = expertFromName;
    }

}
