package com.ejianc.business.tender.other.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件主表")
public class OtherDocumentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("招标公告主键")
    private Long noticeId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("文件名称")
    private String documentName;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("招标联系人")
    private Long employeeId;
    @ApiModelProperty("招标联系人名称")
    private String employeeName;
    @ApiModelProperty("招标联系人电话")
    private String employeeMobile;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("计价方式(0-固定单价,1-浮动单价,2-固定总额)")
    private Integer valueType;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @ApiModelProperty("项目联系人")
    private String projectLinkName;
    @ApiModelProperty("项目联系人电话")
    private String projectLinkPhone;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("报价开始时间")
    private Date offerStartTime;
    @ApiModelProperty("报价结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date offerEndTime;
    @ApiModelProperty("是否允许多品牌报价,0-是,1-否")
    private Integer brandFlag;
    @ApiModelProperty("是否发布,0-是,1-否")
    private Integer publishFlag;
    @ApiModelProperty("是否开标,0-是,1-否")
    private Integer bidFlag;
    @ApiModelProperty("招标单位ID")
    private Long unitId;
    @ApiModelProperty("招标单位名称")
    private String unitName;
    @ApiModelProperty("文件内容")
    private String documentContent;
    @ApiModelProperty(" 招标方式")
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
    @ApiModelProperty("招标文件物料详情表")
    private List<OtherDocumentDetailVO> otherDocumentDetailList = new ArrayList<>();
    @ApiModelProperty("招标文件物料详情表(报价详情用)")
    private List<OtherDocumentDetailVO> otherDocumentDetailSellList = new ArrayList<>();
    @ApiModelProperty("招标文件截止日期变更记录表")
    private List<OtherDocumentRecordVO> otherDocumentRecordList = new ArrayList<>();
    @ApiModelProperty("招标文件方案表")
    private List<OtherDocumentSchemeVO> otherDocumentSchemeList = new ArrayList<>();
    @ApiModelProperty("招标文件报价表")
    private List<OtherDocumentSellVO> otherDocumentSellList = new ArrayList<>();
    @ApiModelProperty("招标文件供应商标")
    private List<OtherDocumentSupplierVO> otherDocumentSupplierList = new ArrayList<>();
    @ApiModelProperty("招标文件供应商标方案报价表(界面设计器避键值免重复设计)")
    private List<OtherDocumentSupplierVO> otherDocumentSupplierSchemeList = new ArrayList<>();
    @ApiModelProperty("招标文件供应商标方案报价表(界面设计器避键值免重复设计)")
    private List<OtherDocumentExpertVO> expertVOList = new ArrayList<>();
    private List<OtherInviteDetailRecordVO> otherDetailRecord = new ArrayList<>(); //
    @ApiModelProperty("开标时间")
    private Date bidTime;
    @ApiModelProperty("是否下一步,0-是,1-否")
    private Integer nextFlag;
    private String purchaseId; // 采购方式ID
    private String purchaseName; // 采购方式名称
    private Long sourceId;
    private List<String> fileNames;
    @ApiModelProperty("报名供应商情况")
    private List<OtherNoticeSupplierVO> otherDocumentSupplierDetail = new ArrayList<>();
    private String settlementClause; // 结算条款

    public String getSettlementClause() {
        return settlementClause;
    }

    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }

    public List<OtherNoticeSupplierVO> getOtherDocumentSupplierDetail() {
        return otherDocumentSupplierDetail;
    }

    public void setOtherDocumentSupplierDetail(List<OtherNoticeSupplierVO> otherDocumentSupplierDetail) {
        this.otherDocumentSupplierDetail = otherDocumentSupplierDetail;
    }

    public List<OtherInviteDetailRecordVO> getOtherDetailRecord() {
        return otherDetailRecord;
    }

    public void setOtherDetailRecord(List<OtherInviteDetailRecordVO> otherDetailRecord) {
        this.otherDetailRecord = otherDetailRecord;
    }

    public List<OtherDocumentExpertVO> getExpertVOList() {
        return expertVOList;
    }

    public void setExpertVOList(List<OtherDocumentExpertVO> expertVOList) {
        this.expertVOList = expertVOList;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public List<String> getFileNames() {
        return fileNames;
    }

    public void setFileNames(List<String> fileNames) {
        this.fileNames = fileNames;
    }

    public List<OtherDocumentDetailVO> getOtherDocumentDetailSellList() {
        return otherDocumentDetailSellList;
    }

    public void setOtherDocumentDetailSellList(List<OtherDocumentDetailVO> otherDocumentDetailSellList) {
        this.otherDocumentDetailSellList = otherDocumentDetailSellList;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }

    public Date getBidTime() {
        return bidTime;
    }

    public void setBidTime(Date bidTime) {
        this.bidTime = bidTime;
    }

    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    public List<OtherDocumentSupplierVO> getOtherDocumentSupplierSchemeList() {
        return otherDocumentSupplierSchemeList;
    }

    public void setOtherDocumentSupplierSchemeList(List<OtherDocumentSupplierVO> otherDocumentSupplierSchemeList) {
        this.otherDocumentSupplierSchemeList = otherDocumentSupplierSchemeList;
    }

    public String getDocumentContent() {
        return documentContent;
    }

    public void setDocumentContent(String documentContent) {
        this.documentContent = documentContent;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 招标公告主键
     */
    public Long getNoticeId() {
        return noticeId;
    }

    /**
     * 招标公告主键
     */
    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 文件名称
     */
    public String getDocumentName() {
        return documentName;
    }

    /**
     * 文件名称
     */
    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 招标联系人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目联系人
     */
    public String getProjectLinkName() {
        return projectLinkName;
    }

    /**
     * 项目联系人
     */
    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }
    /**
     * 项目联系人电话
     */
    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    /**
     * 项目联系人电话
     */
    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }
    /**
     * 报价开始时间
     */
    public Date getOfferStartTime() {
        return offerStartTime;
    }

    /**
     * 报价开始时间
     */
    public void setOfferStartTime(Date offerStartTime) {
        this.offerStartTime = offerStartTime;
    }
    /**
     * 报价结束时间
     */
    public Date getOfferEndTime() {
        return offerEndTime;
    }

    /**
     * 报价结束时间
     */
    public void setOfferEndTime(Date offerEndTime) {
        this.offerEndTime = offerEndTime;
    }
    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public Integer getBrandFlag() {
        return brandFlag;
    }

    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public void setBrandFlag(Integer brandFlag) {
        this.brandFlag = brandFlag;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 是否开标,0-是,1-否
     */
    public Integer getBidFlag() {
        return bidFlag;
    }

    /**
     * 是否开标,0-是,1-否
     */
    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    /**
     * 招标单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public List<OtherDocumentDetailVO> getOtherDocumentDetailList() {
        return otherDocumentDetailList;
    }

    public void setOtherDocumentDetailList(List<OtherDocumentDetailVO> otherDocumentDetailList) {
        this.otherDocumentDetailList = otherDocumentDetailList;
    }

    public List<OtherDocumentRecordVO> getOtherDocumentRecordList() {
        return otherDocumentRecordList;
    }

    public void setOtherDocumentRecordList(List<OtherDocumentRecordVO> otherDocumentRecordList) {
        this.otherDocumentRecordList = otherDocumentRecordList;
    }

    public List<OtherDocumentSchemeVO> getOtherDocumentSchemeList() {
        return otherDocumentSchemeList;
    }

    public void setOtherDocumentSchemeList(List<OtherDocumentSchemeVO> otherDocumentSchemeList) {
        this.otherDocumentSchemeList = otherDocumentSchemeList;
    }

    public List<OtherDocumentSellVO> getOtherDocumentSellList() {
        return otherDocumentSellList;
    }

    public void setOtherDocumentSellList(List<OtherDocumentSellVO> otherDocumentSellList) {
        this.otherDocumentSellList = otherDocumentSellList;
    }

    public List<OtherDocumentSupplierVO> getOtherDocumentSupplierList() {
        return otherDocumentSupplierList;
    }

    public void setOtherDocumentSupplierList(List<OtherDocumentSupplierVO> otherDocumentSupplierList) {
        this.otherDocumentSupplierList = otherDocumentSupplierList;
    }
}
