package com.ejianc.business.tender.other.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 招标文件报价表
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件报价表")
public class OtherDocumentSellVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("采购物料详情主键")
    private Long detailId;
    @ApiModelProperty("方案子表主键")
    private Long schemeId;
    @ApiModelProperty("招标文件主表主键")
    private Long documentId;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("供应商ID")
    private Long supplierId;
    @ApiModelProperty("供应商租户id")
    private Long supplierTenantId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("材料ID")
    private Long materialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private Long materialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("供货品牌")
    private String brand;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("单价(含税)")
    private BigDecimal priceTax;
    @ApiModelProperty("总额")
    private BigDecimal money;
    @ApiModelProperty("总额(含税)")
    private BigDecimal moneyTax;
    @ApiModelProperty("税额")
    private BigDecimal sellTax;
    @ApiModelProperty("中标数量")
    private BigDecimal tenderNum;
    @ApiModelProperty("中标金额")
    private BigDecimal tenderMoney;
    @ApiModelProperty("方案名称")
    private String schemeName;
    @ApiModelProperty("是否中标,0-是1-否")
    private Integer tenderFlag;
    @ApiModelProperty("定标立项备注")
    private String materialMemo;
    @ApiModelProperty("定标立项品牌")
    private String materialBrand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("分时")
    private BigDecimal score;
    @ApiModelProperty("中标金额(含税)")
    private BigDecimal tenderMoneyTax;
    @ApiModelProperty("洽商轮数")
    private Integer talkNum;
    @ApiModelProperty("是否推荐,1-是,2-否")
    private Integer referFlag;
    @ApiModelProperty("是否通过,1-是,2-否")
    private Integer passFlag;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEnterDate; // 计划进场时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planLeaveDate; // 计划出场时间
    private BigDecimal planDay; // 计划周期
    private BigDecimal detailRate; // 材料税率

    public BigDecimal getDetailRate() {
        return detailRate;
    }

    public void setDetailRate(BigDecimal detailRate) {
        this.detailRate = detailRate;
    }
    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }
    public Integer getPassFlag() {
        return passFlag;
    }

    public void setPassFlag(Integer passFlag) {
        this.passFlag = passFlag;
    }
    public Integer getReferFlag() {
        return referFlag;
    }

    public void setReferFlag(Integer referFlag) {
        this.referFlag = referFlag;
    }
    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public BigDecimal getTenderMoneyTax() {
        return tenderMoneyTax;
    }

    public void setTenderMoneyTax(BigDecimal tenderMoneyTax) {
        this.tenderMoneyTax = tenderMoneyTax;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public Integer getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }

    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }

    public String getMaterialBrand() {
        return materialBrand;
    }

    public void setMaterialBrand(String materialBrand) {
        this.materialBrand = materialBrand;
    }

    /**
     * 采购物料详情主键
     */
    public Long getDetailId() {
        return detailId;
    }

    /**
     * 采购物料详情主键
     */
    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }
    /**
     * 方案子表主键
     */
    public Long getSchemeId() {
        return schemeId;
    }

    /**
     * 方案子表主键
     */
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    /**
     * 招标文件主表主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主表主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 供应商ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商租户id
     */
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户id
     */
    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 材料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 材料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 供货品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 供货品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getPriceTax() {
        return priceTax;
    }

    /**
     * 单价(含税)
     */
    public void setPriceTax(BigDecimal priceTax) {
        this.priceTax = priceTax;
    }
    /**
     * 总额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 总额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 税额
     */
    public BigDecimal getSellTax() {
        return sellTax;
    }

    /**
     * 税额
     */
    public void setSellTax(BigDecimal sellTax) {
        this.sellTax = sellTax;
    }
    /**
     * 中标数量
     */
    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    /**
     * 中标数量
     */
    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }
    /**
     * 中标金额
     */
    public BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 中标金额
     */
    public void setTenderMoney(BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 方案名称
     */
    public String getSchemeName() {
        return schemeName;
    }

    /**
     * 方案名称
     */
    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    /**
     * 是否中标,1-是2-否
     */
    public Integer getTenderFlag() {
        return tenderFlag;
    }

    /**
     * 是否中标,1-是2-否
     */
    public void setTenderFlag(Integer tenderFlag) {
        this.tenderFlag = tenderFlag;
    }
    
}
