package com.ejianc.business.tender.api;

import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.cost.vo.AllPlanDetailVO;
import com.ejianc.business.tender.cost.vo.PlanControlRuleDetailVO;
import com.ejianc.business.tender.hystrix.TenderCostHystrix;
import com.ejianc.business.tender.hystrix.TenderHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-tender-web", url="${common.env.feign-client-url}", path="ejc-tender-web", fallback = TenderCostHystrix.class)
public interface ITenderCostApi {

	/**
	 *新增或修改
	 * @return
	 */
	@PostMapping(value = "/api/allPlanDetail/saveOrUpdateBatch")
	CommonResponse<List<PlanControlRuleDetailVO>> saveOrUpdateBatch(@RequestBody BatPlanVO vo);


	/**
	 *检验
	 * @return
	 */
	@PostMapping(value = "/api/allPlanDetail/check")
	CommonResponse<List<PlanControlRuleDetailVO>> check(@RequestBody BatPlanVO vo);

    /**
     *批量删除
     * @return
     */
    @PostMapping(value = "/api/allPlanDetail/delete")
    CommonResponse<String> delete(@RequestBody List<BatPlanDetailVO> vos);
}
