package com.ejianc.business.tender.prosub.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料立项主表
 *
 * @author generator
 *
 */
public class ProsubInviteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long employeeId; // 编制人
    private String employeeName; // 编制人名称
    private Long unitId; // 招标单位ID
    private String unitName; // 招标单位名称
    private String memo; // 备注
    private Integer establishType; // 立项类型(0-招标立项，1-定标立项)
    private Integer billState; // 单据状态（审批必须字段）
    private String tenderName; // 招标名称
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
    private Integer tenderStage; // 招标阶段(0-定标立项,1-招标立项,2-招标公告,3-招标文件,4-专家评标,5-已完成,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告,11-流标，12-费标)
    private String tenderUnitNum; // 中标单位及数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 编制日期
    private Integer valueType; // 计价方式(0-可调单价,1-固定总价,2-成本加酬金)
    private String projectCode; // 项目编号
    private BigDecimal tenderMoney; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    private Integer abolishType; // 流/废标（0-正常，1-流标，2-废标）
    private Long subType; // 分包类型（0-专业分包，1-劳务分包）
    private String projectQualification; // 工程资质
    private BigDecimal payScale; // 付款比例
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date entryTime; // 进场时间
    private String tenderTypeName; //
    private String establishTypeName; //
    private String purchaseTypeName; //
    private String tenderStageName; //
    private String billStateName; //
    private String paymentId; // 付款方式
    private String paymentName; // 付款方式
    private String projectQualificationId; // 工程资质id
    private String purchaseId; // 分包内容
    private String purchaseName; // 分包内容名称
    private BigDecimal score; // 专家评分
    private Long supplierId; // 付款方式
    private String supplierName; // 付款方式
    private String subTypeName; // 分包类型（0-专业分包，1-劳务分包）
    private Integer tenderPlatform; // 招标平台(1-招采平台，2-云上营家)


    @TableField(value="money")
    private BigDecimal money; // 定标金额(无税)
    @TableField(value="tax_money")
    private BigDecimal taxMoney; // 定标金额(含税)
    @TableField(value="sign_status")
    private Integer signStatus; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    private String signStatusName; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    private Integer occupyState; //占用状态:0-未占用,1-已占用
    private String orgCode; // 项目部编码
    private String parentOrgCode; // 项目部上级组织编码
    private String subContent; // 分包类别
    private String subContentName; // 分包类别名称
    private String subDescribe; // 分包范围及作业内容简述
    private Integer isLowPrice; // 低价中标
    private String settlementClause; // 结算条款
    private Integer priceShowFlag; // 招标控制价是否显示0否1是


    public Integer getPriceShowFlag() {
        return priceShowFlag;
    }

    public void setPriceShowFlag(Integer priceShowFlag) {
        this.priceShowFlag = priceShowFlag;
    }
    public String getSettlementClause() {
        return settlementClause;
    }

    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }


    public Integer getIsLowPrice() {
        return isLowPrice;
    }

    public void setIsLowPrice(Integer isLowPrice) {
        this.isLowPrice = isLowPrice;
    }

    public String getSubDescribe() {
        return subDescribe;
    }

    public void setSubDescribe(String subDescribe) {
        this.subDescribe = subDescribe;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getOccupyState() {
        return occupyState;
    }

    public void setOccupyState(Integer occupyState) {
        this.occupyState = occupyState;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }



    private List<ProsubInviteDetailVO> subDetail = new ArrayList<>(); // 材料招标立项采购清单表
    private List<ProsubInviteSupplierVO> supplierDetail = new ArrayList<>(); // 材料招标立项供应商表
    private List<ProsubInviteDetailRecordVO> subDetailRecord = new ArrayList<>(); // 材料招标立项采购清单表不合并
//    private List<SubInviteExpertVO> expertDetail = new ArrayList<>(); // 材料招标立项专家表
    private List<ProsubInviteDetailBidderVO> subDetailBidder = new ArrayList<>(); // 材料定标立项定标情况表

    public Integer getTenderPlatform() {
        return tenderPlatform;
    }

    public void setTenderPlatform(Integer tenderPlatform) {
        this.tenderPlatform = tenderPlatform;
    }

    public String getProjectQualificationId() {
        return projectQualificationId;
    }
    //@ReferDeserialTransfer
    public void setProjectQualificationId(String projectQualificationId) {
        this.projectQualificationId = projectQualificationId;
    }

    public String getSubTypeName() {
        return subTypeName;
    }

    public void setSubTypeName(String subTypeName) {
        this.subTypeName = subTypeName;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getTenderStageName() {
        return tenderStageName;
    }

    public void setTenderStageName(String tenderStageName) {
        this.tenderStageName = tenderStageName;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getEstablishTypeName() {
        return establishTypeName;
    }

    public void setEstablishTypeName(String establishTypeName) {
        this.establishTypeName = establishTypeName;
    }

    public String getTenderTypeName() {
        return tenderTypeName;
    }

    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }

    /**
     * 流/废标状态
     */
    public Integer getAbolishType() {
        return abolishType;
    }

    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标单位ID
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 招标名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标阶段
     */
    public Integer getTenderStage() {
        return tenderStage;
    }

    /**
     * 招标阶段
     */
    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    /**
     * 中标单位及数量
     */
    public String getTenderUnitNum() {
        return tenderUnitNum;
    }

    /**
     * 中标单位及数量
     */
    public void setTenderUnitNum(String tenderUnitNum) {
        this.tenderUnitNum = tenderUnitNum;
    }
    /**
     * 编制日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 招标金额
     */
    public BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 招标金额
     */
    public void setTenderMoney(BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public Integer getEstablishType() {
        return establishType;
    }

    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public void setEstablishType(Integer establishType) {
        this.establishType = establishType;
    }

    public List<ProsubInviteDetailVO> getSubDetail() {
        return subDetail;
    }

    public void setSubDetail(List<ProsubInviteDetailVO> subDetail) {
        this.subDetail = subDetail;
    }

    public List<ProsubInviteDetailRecordVO> getSubDetailRecord() {
        return subDetailRecord;
    }

    public void setSubDetailRecord(List<ProsubInviteDetailRecordVO> subDetailRecord) {
        this.subDetailRecord = subDetailRecord;
    }

    public List<ProsubInviteDetailBidderVO> getSubDetailBidder() {
        return subDetailBidder;
    }

    public void setSubDetailBidder(List<ProsubInviteDetailBidderVO> subDetailBidder) {
        this.subDetailBidder = subDetailBidder;
    }

    public List<ProsubInviteSupplierVO> getSupplierDetail() {
        return supplierDetail;
    }

    public void setSupplierDetail(List<ProsubInviteSupplierVO> supplierDetail) {
        this.supplierDetail = supplierDetail;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    public String getProjectQualification() {
        return projectQualification;
    }

    public void setProjectQualification(String projectQualification) {
        this.projectQualification = projectQualification;
    }

    public String getPaymentId() {
        return paymentId;
    }
    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public Date getEntryTime() {
        return entryTime;
    }

    public void setEntryTime(Date entryTime) {
        this.entryTime = entryTime;
    }

    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public String getSubContentName() {
        return subContentName;
    }

    public void setSubContentName(String subContentName) {
        this.subContentName = subContentName;
    }
}
