/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.abolish.service.impl;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.tender.abolish.bean.WasteEntity;
import com.ejianc.business.tender.abolish.mapper.WasteMapper;
import com.ejianc.business.tender.abolish.service.IWasteService;
import com.ejianc.business.tender.abolish.vo.WasteBidTbVO;
import com.ejianc.business.tender.abolish.vo.WasteTbVO;
import com.ejianc.business.tender.abolish.vo.WasteVO;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentExpertEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentExpertService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteDetailService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailVO;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="wasteService")
public class WasteServiceImpl
extends BaseServiceImpl<WasteMapper, WasteEntity>
implements IWasteService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer ABOLISH_TYPE_0 = 0;
    private static final Integer ABOLISH_TYPE_2 = 2;
    private static final Integer BID_FLAG = 0;
    private static final Integer PUBLISH_FLAG_YES = 0;
    private static final Integer PUBLISH_FLAG_NO = 1;
    private static final Integer WIN_BID_TYPE_2 = 2;
    private static final String OUT_REASON = "\u5df2\u5e9f\u6807";
    private static final Integer PURCHASE_TYPE_0 = 0;
    private static final Integer PURCHASE_TYPE_1 = 1;
    private static final String SEND_MAP_KEY_SUBJECT = "subject";
    private static final String SEND_MAP_KEY_CONTENT = "content";
    @Value(value="${gysUrl.updateBidOutUrl}")
    private String updateBidOutUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IOtherInviteDetailService otherInviteDetailService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherDocumentExpertService otherDocumentExpertService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IExpertEvaluatingDetailService IExpertEvaluatingDetailService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public WasteVO saveOrUpdateByVo(WasteVO saveOrUpdateVO) {
        WasteEntity entity = (WasteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WasteEntity.class));
        this.checkWaste(saveOrUpdateVO);
        super.saveOrUpdate((Object)entity, false);
        WasteVO vo = this.copyWasteBean(entity);
        this.updateInvite(vo.getTenderId(), vo.getTenderStage(), vo.getType(), true);
        return vo;
    }

    @Override
    public void deleteByListVo(List<WasteVO> voList) {
        List idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", idList));
        List entityList = super.queryList(param);
        for (WasteEntity entity : entityList) {
            this.updateInvite(entity.getTenderId(), entity.getTenderStage(), entity.getType(), false);
        }
        super.removeByIds(idList, true);
    }

    @Override
    public WasteVO selectWasteVo(Long tenderId) {
        WasteVO vo;
        QueryParam param = new QueryParam();
        param.getParams().put("tenderId", new Parameter("eq", (Object)tenderId));
        List wasteEntityList = super.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)wasteEntityList)) {
            vo = new WasteVO();
            param.getOrderMap().put("createTime", "desc");
            List processEntityList = this.processService.queryList(param);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)processEntityList)) {
                ProcessEntity processEntity = (ProcessEntity)((Object)processEntityList.get(0));
                vo.setStageId(processEntity.getId());
                vo.setType(processEntity.getType());
            }
            this.initWasteVo(vo, tenderId);
        } else {
            WasteEntity entity = (WasteEntity)((Object)wasteEntityList.get(0));
            vo = this.copyWasteBean(entity);
        }
        return vo;
    }

    @Override
    public WasteVO queryDetailById(Long id) {
        WasteEntity entity = (WasteEntity)((Object)super.selectById((Serializable)id));
        if (entity == null || entity.getId() == 0L) {
            return new WasteVO();
        }
        return this.copyWasteBean(entity);
    }

    @Override
    public void updateGysByWaste(Long id) {
        WasteEntity wasteEntity = (WasteEntity)((Object)super.selectById((Serializable)id));
        WasteTbVO tbVO = new WasteTbVO();
        tbVO.setSourceId(this.objToString(wasteEntity.getTenderId()));
        tbVO.setType(ABOLISH_TYPE_2);
        tbVO.setOutReason(OUT_REASON);
        String paramJson = JSON.toJSONString((Object)tbVO);
        this.sendPostReq(this.updateBidOutUrl, paramJson);
    }

    @Override
    public WasteVO publishWaste(Long id) {
        WasteEntity wasteEntity = (WasteEntity)((Object)super.selectById((Serializable)id));
        wasteEntity.setPublishFlag(PUBLISH_FLAG_YES);
        super.updateById((Object)wasteEntity);
        WasteBidTbVO wasteBidTbVO = new WasteBidTbVO();
        wasteBidTbVO.setSourceType("\u4e91\u5357\u5efa\u6295\u5e9f\u6807\u516c\u544a");
        wasteBidTbVO.setSourceId(this.objToString(wasteEntity.getTenderId()));
        wasteBidTbVO.setTendentId(wasteEntity.getTenantId());
        wasteBidTbVO.setSourceProjectId(this.objToString(wasteEntity.getProjectId()));
        wasteBidTbVO.setProjectName(wasteEntity.getProjectName());
        wasteBidTbVO.setProjectCode(wasteEntity.getProjectCode());
        wasteBidTbVO.setSourceOrgId(this.objToString(wasteEntity.getOrgId()));
        wasteBidTbVO.setOrgName(wasteEntity.getOrgName());
        wasteBidTbVO.setSourceUnitId(this.objToString(wasteEntity.getUnitId()));
        wasteBidTbVO.setUnitName(wasteEntity.getUnitName());
        wasteBidTbVO.setMemo(wasteEntity.getMemo());
        wasteBidTbVO.setContent(wasteEntity.getContent());
        wasteBidTbVO.setWinbidType(WIN_BID_TYPE_2);
        wasteBidTbVO.setType(CommonUtils.getGysType(wasteEntity.getType()));
        wasteBidTbVO.setTenderName(wasteEntity.getTenderName());
        wasteBidTbVO.setTenderType(wasteEntity.getTenderType());
        wasteBidTbVO.setSourceEmployeeId(this.objToString(wasteEntity.getEmployeeId()));
        wasteBidTbVO.setEmployeeName(wasteEntity.getEmployeeName());
        wasteBidTbVO.setEmployeeMobile(wasteEntity.getEmployeeMobile());
        wasteBidTbVO.setNoticeWinbidTime(wasteEntity.getApplyTime());
        ArrayList<WasteBidTbVO> bidTbVOList = new ArrayList<WasteBidTbVO>();
        bidTbVOList.add(wasteBidTbVO);
        String paramJson = JSON.toJSONString(bidTbVOList);
        this.sendPostReq(this.winbidSavesUrl, paramJson);
        return this.copyWasteBean(wasteEntity);
    }

    @Override
    public void sendMsgByWaste(Integer type, Long tenderId) {
        ArrayList<String> userList = new ArrayList<String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        if (5 != type) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + type + "]");
        }
        this.pickSendOtherMsg(tenderId, userList, sendMap);
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + userList);
        if (CollectionUtils.isNotEmpty(userList) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(sendMap)) {
            String subject = (String)sendMap.get(SEND_MAP_KEY_SUBJECT);
            String content = (String)sendMap.get(SEND_MAP_KEY_CONTENT);
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
            new SendMsgUtils().sendSysMsg(userList, subject, content, this.pushMessageApi);
        }
    }

    @Override
    public void updateExpertEvaluatingByWaste(Long tenderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        List expertEvaluatingEntityList = this.IExpertEvaluatingService.queryList(queryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)expertEvaluatingEntityList)) {
            UpdateWrapper wraper = new UpdateWrapper();
            ((UpdateWrapper)wraper.set((Object)"gather_status", (Object)1)).eq((Object)"invite_id", (Object)tenderId);
            this.IExpertEvaluatingService.update((Wrapper)wraper);
            List evaluationIdList = expertEvaluatingEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            UpdateWrapper detailWraper = new UpdateWrapper();
            ((UpdateWrapper)detailWraper.set((Object)"evaluation_state", (Object)2)).in((Object)"evaluation_id", evaluationIdList);
            this.IExpertEvaluatingDetailService.update((Wrapper)detailWraper);
            this.logger.info("\u5e9f\u6807\u751f\u6548\uff0c\u5c06\u8bc4\u6807\u72b6\u6001\u4fee\u6539\u4e3a\u5df2\u5931\u6548\uff0c\u6c47\u603b\u72b6\u6001\u6539\u4e3a\u5df2\u6c47\u603b");
        }
    }

    private void pickSendOtherMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(tenderId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage()) || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage()) || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage()) || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage())) {
            Long documentId;
            List otherInviteExpertEntityList;
            List otherDocumentEntityList = this.otherDocumentService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)otherDocumentEntityList) && CollectionUtils.isNotEmpty((Collection)(otherInviteExpertEntityList = this.otherDocumentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)(documentId = ((OtherDocumentEntity)((Object)otherDocumentEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
                List expertList = otherInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null).map(OtherDocumentExpertEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        } else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        String name = otherInviteEntity.getProjectName();
        String subject = otherInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        String content = otherInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    private void pickCommonSendMsg(QueryParam queryParam, List<String> userList) {
        Long evaluationId;
        List expertEvaluatingDetailEntityList;
        List expertEvaluatingEntityList = this.IExpertEvaluatingService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)expertEvaluatingEntityList) && CollectionUtils.isNotEmpty((Collection)(expertEvaluatingDetailEntityList = this.IExpertEvaluatingDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"evaluation_id", (Object)(evaluationId = ((ExpertEvaluatingEntity)((Object)expertEvaluatingEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
            List expertList = expertEvaluatingDetailEntityList.stream().filter(p -> p.getExpertId() != null).map(ExpertEvaluatingDetailEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
            userList.addAll(expertList);
        }
    }

    private List<OtherInviteDetailVO> queryOtherInviteDetailByWaste(Long tenderId) {
        if (null == tenderId || tenderId == 0L) {
            return new ArrayList<OtherInviteDetailVO>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        List list = this.otherInviteDetailService.queryList(param);
        return BeanMapper.mapList((Iterable)list, OtherInviteDetailVO.class);
    }

    private void updateInvite(Long tenderId, Integer tenderStage, Integer type, boolean addFlag) {
        if (5 != type) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + type + "]");
        }
        this.updateOtherInviteByWaste(tenderId, tenderStage, addFlag);
    }

    private void updateOtherInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(tenderId));
        if (otherInviteEntity != null && otherInviteEntity.getId() != 0L) {
            Integer abolishType = otherInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                this.otherInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                this.otherInviteService.updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                this.otherInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                this.otherInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    private void initWasteVo(WasteVO vo, Long tenderId) {
        if (5 != vo.getType()) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + vo.getType() + "]");
        }
        this.initOtherWasteVo(vo, tenderId);
    }

    private void initOtherWasteVo(WasteVO vo, Long tenderId) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(tenderId));
        if (otherInviteEntity != null) {
            vo.setPurchaseType(otherInviteEntity.getPurchaseType());
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(otherInviteEntity.getPurchaseType()));
            vo.setProjectId(otherInviteEntity.getProjectId());
            vo.setProjectName(otherInviteEntity.getProjectName());
            vo.setProjectCode(otherInviteEntity.getProjectCode());
            vo.setTenderId(otherInviteEntity.getId());
            vo.setTenderName(otherInviteEntity.getTenderName());
            vo.setTenderType(otherInviteEntity.getTenderType());
            vo.setTenderStage(otherInviteEntity.getTenderStage());
            vo.setOrgId(otherInviteEntity.getOrgId());
            vo.setOrgName(otherInviteEntity.getOrgName());
            vo.setParentOrgId(otherInviteEntity.getParentOrgId());
            vo.setParentOrgName(otherInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO);
            vo.setApplyTime((Date)new DateTime());
            vo.setOtherInviteDetailList(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        }
    }

    private void deleteProcess(Long billId, Long tenderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billId", new Parameter("eq", (Object)billId));
        queryParam.getParams().put("tenderId", new Parameter("eq", (Object)tenderId));
        List processEntityList = this.processService.queryList(queryParam);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)processEntityList)) {
            List idList = processEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.processService.removeByIds(idList);
        }
    }

    private WasteVO copyWasteBean(WasteEntity entity) {
        String tenderTypeName;
        switch (entity.getTenderType()) {
            case 0: {
                tenderTypeName = "\u5e73\u53f0\u516c\u5f00\u62db\u6807";
                break;
            }
            case 1: {
                tenderTypeName = "\u9080\u8bf7\u62db\u6807";
                break;
            }
            case 2: {
                tenderTypeName = "\u8be2\u4ef7";
                break;
            }
            case 3: {
                tenderTypeName = "\u7ade\u4e89\u6027\u8c08\u5224";
                break;
            }
            case 4: {
                tenderTypeName = "\u5355\u4e00\u6765\u6e90";
                break;
            }
            case 5: {
                tenderTypeName = "\u7d27\u6025\u62db\u6807";
                break;
            }
            default: {
                tenderTypeName = null;
            }
        }
        WasteVO vo = (WasteVO)BeanMapper.map((Object)((Object)entity), WasteVO.class);
        vo.setTenderTypeName(tenderTypeName);
        if (5 != vo.getType()) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + vo.getType() + "]");
        }
        vo.setOtherInviteDetailList(this.queryOtherInviteDetailByWaste(entity.getTenderId()));
        vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(entity.getPurchaseType()));
        return vo;
    }

    private String getPurchaseTypeNameByType(Integer purchaseType) {
        String purchaseTypeName;
        switch (purchaseType) {
            case 0: {
                purchaseTypeName = "\u9879\u76ee\u91c7\u8d2d";
                break;
            }
            case 1: {
                purchaseTypeName = "\u516c\u53f8\u91c7\u8d2d";
                break;
            }
            default: {
                purchaseTypeName = null;
            }
        }
        return purchaseTypeName;
    }

    private void sendPostReq(String url, String paramJson) {
        CommonResponse response = null;
        try {
            this.logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u53d1\u9001\u53c2\u6570\uff1a{}", (Object)paramJson);
            response = this.systemDataPushService.exchangeDataWithUniversal(url, RequestMethod.POST, paramJson, this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u62a5\u9519\uff1a" + response.getMsg());
            }
            this.logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", response.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u62a5\u9519\uff1a" + e.getMessage());
        }
    }

    private String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    private void checkWaste(WasteVO vo) {
        Long tenderId = vo.getTenderId();
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        if (5 != vo.getType()) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + vo.getType() + "]");
        }
        this.checkOtherWaste(param);
    }

    private void checkOtherWaste(QueryParam param) {
        List otherDocumentEntityList = this.otherDocumentService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)otherDocumentEntityList) || !BID_FLAG.equals(((OtherDocumentEntity)((Object)otherDocumentEntityList.get(0))).getBidFlag())) {
            this.logger.error("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff01");
        }
        List otherPicketageEntityList = this.otherPicketageService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)otherPicketageEntityList)) {
            Integer stuffState = ((OtherPicketageEntity)((Object)otherPicketageEntityList.get(0))).getBillState();
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                this.logger.error("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
                throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff01");
            }
        }
    }
}

