package com.ejianc.business.tender.abolish.service.impl;
import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.notice.vo.SupOfferVO;
import com.ejianc.business.supbid.other.api.ISupNoticeApi;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.business.tender.abolish.bean.FlowEntity;
import com.ejianc.business.tender.abolish.bean.WasteEntity;
import com.ejianc.business.tender.abolish.mapper.FlowMapper;
import com.ejianc.business.tender.abolish.service.IFlowService;
import com.ejianc.business.tender.abolish.vo.FlowBidTbVO;
import com.ejianc.business.tender.abolish.vo.FlowTbVO;
import com.ejianc.business.tender.abolish.vo.FlowVO;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailVO;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
//import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.constraints.Email;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 流标表
 * 
 * @author generator
 * 
 */
@Service("flowService")
public class FlowServiceImpl extends BaseServiceImpl<FlowMapper, FlowEntity> implements IFlowService {

    @Value("${gysUrl.updateBidOutUrl}")
    private String updateBidOutUrl;

    @Value("${gysUrl.winbidSavesUrl}")
    private String winbidSaveUrl;

    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")

    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private CacheManager cacheManager;
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String BILL_CODE = "FLOW_CODE";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private FlowServiceImpl service;

    @Autowired
    private IOtherInviteService otherInviteService;
//    @Autowired
//    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISupNoticeApi supNoticeApi;
//    @Autowired
//    private IProSupplierApi proSupplierApi;
    /** 招标阶段表 */
    @Autowired
    private IProcessService processService;


    /**
     * 保存
     *
     * @param saveorUpdateVO 保存数据
     * @return 返回数据
     */
    @Override
    public FlowVO saveFlow(FlowVO saveorUpdateVO) {
        FlowEntity entity = BeanMapper.map(saveorUpdateVO, FlowEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi
                    .getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        FlowVO vo = BeanMapper.map(entity, FlowVO.class);
        if (CommonUtils.TYPE_OTHER == vo.getType()) {
            this.updateOtherAbolishType(vo.getTenderId().toString(), 1, TenderStageEnum.FLOW_STATE
                    .getTenderTypeCode());
            OtherInviteEntity otherInviteEntity = otherInviteService.selectById(vo.getTenderId());
            vo.setOtherDetail(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + vo.getType() + "]");
        }
        return vo;
    }

    /**
     * 查询详情
     *
     * @param id 流标id
     * @return 查询结果
     */
    @Override
    public FlowVO queryDetail(Long id) {
        FlowEntity entity = service.selectById(id);
        FlowVO vo = BeanMapper.map(entity, FlowVO.class);
        if (CommonUtils.TYPE_OTHER == vo.getType()) {
            OtherInviteEntity otherInviteEntity = otherInviteService.selectById(vo.getTenderId());
            vo.setOtherDetail(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + vo.getType() + "]");
        }
        return vo;
    }

    /**
     * 批量删除流标
     *
     * @param vos 删除流标id列表
     */
    @Override
    public void deleteFlow(List<FlowVO> vos) {
        FlowEntity flowEntity = service.selectById(vos.get(0).getId());
        if (CommonUtils.TYPE_OTHER == flowEntity.getType()) {
            this.updateOtherAbolishType(flowEntity.getTenderId().toString(), 0, flowEntity.getTenderStage());
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + flowEntity.getType() + "]");
        }
//        //更新流标状态
//        stuffInviteService.updateAbolishType(flowEntity.getTenderId().toString(), 0);
//        //更新招标阶段
//        stuffInviteService.updateTenderStage(flowEntity.getTenderId().toString(), flowEntity.getTenderStage());
        service.removeByIds(vos.stream().map(FlowVO::getId).collect(Collectors.toList()), true);
    }

    //发布
    @Transactional
    @Override
    public FlowVO publishFlow(Long id) {
        FlowEntity flowEntity = service.selectById(id);
//        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(flowEntity.getTenderId());

        //推送公示
        FlowBidTbVO flowBidTbVO = new FlowBidTbVO();
        flowBidTbVO.setTenantId(flowEntity.getTenantId());
        flowBidTbVO.setSourceType("云南建投流标公告");
        flowBidTbVO.setSourceId(this.objToString(flowEntity.getTenderId()));
        flowBidTbVO.setSourceProjectId(this.objToString(flowEntity.getProjectId()));
        flowBidTbVO.setProjectName(flowEntity.getProjectName());
        flowBidTbVO.setProjectCode(flowEntity.getProjectCode());
        flowBidTbVO.setSourceOrgId(this.objToString(flowEntity.getOrgId()));
        flowBidTbVO.setOrgName(flowEntity.getOrgName());
        flowBidTbVO.setSourceUnitId(this.objToString(flowEntity.getUnitId()));
        flowBidTbVO.setUnitName(flowEntity.getUnitName());
        flowBidTbVO.setMemo(flowEntity.getMemo());
        flowBidTbVO.setWinbidType(1);
//        flowBidTbVO.setType("MATERIAL");
        flowBidTbVO.setType(CommonUtils.getGysType(flowEntity.getType()));
        flowBidTbVO.setTenderName(flowEntity.getTenderName());
        flowBidTbVO.setTenderType(flowEntity.getTenderType());
        flowBidTbVO.setPurchaseName(flowEntity.getPurchaseName());
        flowBidTbVO.setSourceEmployeeId(this.objToString(flowEntity.getEmployeeId()));
        flowBidTbVO.setEmployeeName(flowEntity.getEmployeeName());
        flowBidTbVO.setEmployeeMobile(flowEntity.getEmployeeMobile());
        flowBidTbVO.setPurchaseType(flowEntity.getPurchaseType());
        flowBidTbVO.setContent(flowEntity.getContent());
        flowBidTbVO.setNoticeWinbidTime(flowEntity.getApplyTime());
//        flowBidTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        List<FlowBidTbVO> list = new ArrayList<>();
        list.add(flowBidTbVO);
        String stringFb = JSONObject.toJSONString(list);
        CommonResponse<Boolean> response = null;
        try {
//            response = systemDataPushService.exchangeDataWithUniversal(winbidSaveUrl, RequestMethod.POST, stringFb, appId,appSecret,appHost);
//
//            if(!response.isSuccess()) {
//                throw new BusinessException("调用发布接口报错" + response.getMsg());
//            }

            List<WinbidVO> winbidVOList = BeanMapper.mapList(list, WinbidVO.class);
            response = supNoticeApi.winbidSave(winbidVOList);
            if(!response.isSuccess()) {
                throw new BusinessException("调用发布接口报错" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("调用发布接口报错" + response.getMsg());
        }
        // 更新发布状态
        flowEntity.setPublishFlag(0);
        service.updateById(flowEntity);
        FlowVO vo = BeanMapper.map(flowEntity, FlowVO.class);
        return vo;
    }
    //一淘汰
    @Transactional
    @Override
    public FlowTbVO updateBidOut(Long id) {
        FlowEntity flowEntity = baseMapper.selectById(id);
        FlowTbVO flowTbVO = new FlowTbVO();
        flowTbVO.setSourceId(this.objToString(flowEntity.getTenderId()));
        flowTbVO.setOutReason("已流标");
        flowTbVO.setType(1);
//        flowTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString(flowTbVO);
        //调用流标接口
        CommonResponse<Boolean> response = null;
        try {
//            response = systemDataPushService
//                    .exchangeDataWithUniversal(updateBidOutUrl, RequestMethod.POST, stringFb, appId, appSecret,
//                            appHost);
//            if (!response.isSuccess()) {
//                throw new BusinessException("调用流标接口报错" + response.getMsg());
//            }

            SupOfferVO supOfferVO = BeanMapper.map(flowTbVO, SupOfferVO.class);
            response = supNoticeApi.updateBidOut(supOfferVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用流标接口报错" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("调用流标接口报错" + response.getMsg());
        }
        return flowTbVO;
    }

    //流标
    @Transactional
    @Override
    public FlowVO flowBid(Long tenderId) {
        LambdaQueryWrapper<FlowEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(FlowEntity::getTenderId, tenderId);
        List<FlowEntity> list = service.list(lambda);
        FlowVO vo;
        QueryParam param = new QueryParam();
        param.getParams().put("tenderId", new Parameter(QueryParam.EQ, tenderId));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<ProcessEntity> processEntityList = processService.queryList(param);
        int type;
        ProcessEntity processEntity;
        if (CollectionUtils.isNotEmpty(processEntityList)) {
            processEntity = processEntityList.get(0);
            type = processEntity.getType();
        }
        else {
            throw new BusinessException("查询数据失败！");
        }
        if (CommonUtils.TYPE_OTHER == type) {
            vo = saveOtherFlow(tenderId, list, processEntity);
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + type + "]");
        }
        return vo;
    }


    /**
     * 修改其他招标立项状态
     *
     * @param tenderId    招标立项id
     * @param abolishType 流标标志
     * @param tenderStage 招标阶段
     */
    private void updateOtherAbolishType(String tenderId, Integer abolishType, Integer tenderStage) {
        //修改流标状态
        otherInviteService.updateAbolishType(tenderId, abolishType);
        //修改招标阶段
        otherInviteService.updateTenderStage(tenderId, tenderStage);
    }

    /**
     * 组织其他流标数据并保存
     *
     * @param tenderId      招标立项id
     * @param list          流标查询结果list
     * @param processEntity 进程表数据
     * @return 组织结果
     */
    private FlowVO saveOtherFlow(Long tenderId, List<FlowEntity> list, ProcessEntity processEntity) {
        FlowVO vo;
        FlowEntity entity = new FlowEntity();
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);
        if (otherInviteEntity.getAbolishType() == null) {
            otherInviteEntity.setAbolishType(0);
        }
        //是否是第一次点击
        if (CollectionUtils.isNotEmpty(list)) {
            entity = list.get(0);
            //是否点击后未保存
            if (otherInviteEntity.getAbolishType() == 1) {
                vo = BeanMapper.map(entity, FlowVO.class);
                vo.setOtherDetail(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
                return vo;
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi
                    .getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setStageId(processEntity.getId());// 阶段主键
        entity.setType(processEntity.getType());// 招标类型
        //复制主表信息
        entity.setTenderStage(otherInviteEntity.getTenderStage());
        entity.setPurchaseName(otherInviteEntity.getPurchaseName());
        entity.setPurchaseType(otherInviteEntity.getPurchaseType());
        entity.setProjectId(otherInviteEntity.getProjectId());
        entity.setProjectName(otherInviteEntity.getProjectName());
        entity.setProjectCode(otherInviteEntity.getProjectCode());
        entity.setTenderId(otherInviteEntity.getId());
        entity.setTenderName(otherInviteEntity.getTenderName());
        entity.setTenderType(otherInviteEntity.getTenderType());
        entity.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        entity.setEmployeeMobile(iEmployeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData()
                .getMobilePhone());
        entity.setUnitId(sessionManager.getUserContext().getOrgId());
        entity.setUnitName(sessionManager.getUserContext().getOrgName());
        entity.setApplyTime(new DateTime());
        entity.setOrgId(otherInviteEntity.getOrgId());
        entity.setOrgName(otherInviteEntity.getOrgName());
        entity.setParentOrgId(otherInviteEntity.getParentOrgId());
        entity.setParentOrgName(otherInviteEntity.getParentOrgName());
        service.saveOrUpdate(entity, false);
        vo = BeanMapper.map(entity, FlowVO.class);
        vo.setOtherDetail(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        return vo;
    }

    /**
     * Object转String
     *
     * @param obj 需要转换的obj
     * @return 转换后的String
     */
    private String objToString(Object obj) {
        if (obj == null) return null;
        return String.valueOf(obj);
    }

}
