package com.ejianc.business.tender.abolish.service.impl;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.supbid.notice.vo.SupOfferVO;
import com.ejianc.business.supbid.other.api.ISupNoticeApi;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.business.tender.abolish.bean.WasteEntity;
import com.ejianc.business.tender.abolish.mapper.WasteMapper;
import com.ejianc.business.tender.abolish.service.IWasteService;
import com.ejianc.business.tender.abolish.vo.WasteBidTbVO;
import com.ejianc.business.tender.abolish.vo.WasteTbVO;
import com.ejianc.business.tender.abolish.vo.WasteVO;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.other.vo.OtherInviteDetailVO;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
//import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 废标记录表
 *
 * @author generator
 */
@Service("wasteService")
public class WasteServiceImpl extends BaseServiceImpl<WasteMapper, WasteEntity> implements IWasteService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**废标标志：0-正常*/
    private static final Integer ABOLISH_TYPE_0 = 0;
    /**废标标志：2-废标*/
    private static final Integer ABOLISH_TYPE_2 = 2;
    /**是否开标：0-是*/
    private static final Integer BID_FLAG = 0;
    /**是否发布：0-是*/
    private static final Integer PUBLISH_FLAG_YES = 0;
    /** 是否发布：1-否 */
    private static final Integer PUBLISH_FLAG_NO = 1;
    /** 推送类型0-中标，1-流标，2-废标 */
    private static final Integer WIN_BID_TYPE_2 = 2;
    /** 已废标 */
    private static final String OUT_REASON = "已废标";
    /** 采购方式(0-项目采购,1-单位采购) */
    private static final Integer PURCHASE_TYPE_0 = 0;
    /** 采购方式(0-项目采购,1-单位采购) */
    private static final Integer PURCHASE_TYPE_1 = 1;

    /** 发送消息map中的key */
    private static final String SEND_MAP_KEY_SUBJECT = "subject";
    /** 发送消息map中的key */
    private static final String SEND_MAP_KEY_CONTENT = "content";


    @Value("${gysUrl.updateBidOutUrl}")
    private String updateBidOutUrl;
    @Value("${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private CacheManager cacheManager;

//    @Autowired
//    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISupNoticeApi supNoticeApi;

    /** 其他明细清单 */
    @Autowired
    private IOtherInviteDetailService otherInviteDetailService;


    /** 其他招标立项主表 */
    @Autowired
    private IOtherInviteService otherInviteService;


    /** 其他招标文件 */
    @Autowired
    private IOtherDocumentService otherDocumentService;


    /** 其他定标表 */
    @Autowired
    private IOtherPicketageService otherPicketageService;


    /** 其他招标文件专家 */
    @Autowired
    private IOtherDocumentExpertService otherDocumentExpertService;

    /** 招标阶段表 */
    @Autowired
    private IProcessService processService;
    /** 专家评标 */
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    /** 专家评标专家 */
    @Autowired
    private IExpertEvaluatingDetailService IExpertEvaluatingDetailService;

//    @Autowired
//    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;


    /**
     * 新增或修改
     *
     * @param saveOrUpdateVO 新增或修改数据
     * @return 新增或修改后数据
     */
    @Override
    public WasteVO saveOrUpdateByVo(WasteVO saveOrUpdateVO) {
        WasteEntity entity = BeanMapper.map(saveOrUpdateVO, WasteEntity.class);
        this.checkWaste(saveOrUpdateVO);
        // 保存实体
        super.saveOrUpdate(entity, false);

        // 第一次保存添加进程表
//        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
//            // 回写进展表
//            ProcessEntity processEntity = new ProcessEntity();
//            processEntity.setBillId(entity.getId());
//            processEntity.setBillName("废标");
//            processEntity.setTenderId(entity.getTenderId());
//            processEntity.setType(entity.getType());
//            processEntity.setFrontendUrl("/waste/wasteCard");
//            processService.saveOrUpdate(processEntity);
//        }
        // 查询招标记录，并根据招标记录修改标识
        WasteVO vo = this.copyWasteBean(entity);
//        this.updateInviteByWaste(vo.getTenderId(), vo.getTenderStage(), true);
        this.updateInvite(vo.getTenderId(), vo.getTenderStage(), vo.getType(), true);
        return vo;
    }

    /**
     * 批量删除
     *
     * @param voList 删除数据
     */
    @Override
    public void deleteByListVo(List<WasteVO> voList) {
        List<Long> idList = voList.stream().map(WasteVO::getId).collect(Collectors.toList());
        // 首先查询出删除废标数据的招标立项id（tenderId）
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, idList));
        List<WasteEntity> entityList = super.queryList(param);
        for (WasteEntity entity : entityList) {
//            this.updateInviteByWaste(entity.getTenderId(), entity.getTenderStage(), false);
            this.updateInvite(entity.getTenderId(), entity.getTenderStage(), entity.getType(), false);
//            this.deleteProcess(entity.getId(),entity.getTenderId());
        }
        // 删除废标数据
        super.removeByIds(idList, true);
    }

    /**
     * 根据id查询详情
     *
     * @param tenderId tenderId 招标立项ID
     * @return 废标详情
     */
    @Override
    public WasteVO selectWasteVo(Long tenderId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenderId", new Parameter(QueryParam.EQ, tenderId));
        List<WasteEntity> wasteEntityList = super.queryList(param);
        WasteVO vo;
        // 未查询到废标数据，表明是第一次保存，需要初始化一些数据
        if (CollectionUtils.isEmpty(wasteEntityList)) {
            vo = new WasteVO();
            // 查询招标阶段
            // 倒序排序，取第一个
            param.getOrderMap().put("createTime", QueryParam.DESC);
            List<ProcessEntity> processEntityList = processService.queryList(param);
            if (CollectionUtils.isNotEmpty(processEntityList)) {
                ProcessEntity processEntity = processEntityList.get(0);
                vo.setStageId(processEntity.getId());// 阶段主键
                vo.setType(processEntity.getType());// 招标类型
            }
            this.initWasteVo(vo, tenderId);
        } else {
            WasteEntity entity = wasteEntityList.get(0);
            vo = this.copyWasteBean(entity);
        }
        return vo;
    }

    /**
     * 根据id查询详情
     * @param id 废标单据id
     * @return 废标详情
     */
    @Override
    public WasteVO queryDetailById(Long id) {
        WasteEntity entity = super.selectById(id);
        // 未查询到数据返回空VO
        if (entity == null || entity.getId() == 0) {
            return new WasteVO();
        }
        return copyWasteBean(entity);
    }

    /**
     * 推送废标消息，修改供应商状态为已淘汰
     * @param id 废标单据id
     */
    @Override
    public void updateGysByWaste(Long id) {
        WasteEntity wasteEntity = super.selectById(id);
        WasteTbVO tbVO = new WasteTbVO();
        tbVO.setSourceId(this.objToString(wasteEntity.getTenderId())); // 招标主键ID
        tbVO.setType(ABOLISH_TYPE_2); // 流标废标类型 1-流标，2-废标
        tbVO.setOutReason(OUT_REASON);//淘汰原因
//        tbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        String paramJson = JSON.toJSONString(tbVO);
//        //调用第三方报名推送招标信息
//        CommonResponse<JSONObject> response = null;
//        try {
//            logger.info("废标提交推送供应商数据：{}",paramJson);
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,updateBidOutUrl, paramJson,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("废标消息推送供方接口报错：" + response.getMsg());
//            }
//            logger.info("废标提交推送供应商数据结果：{}",response.getData());
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("废标消息推送供方接口报错：" + e.getMessage());
//        }
//        this.sendPostReq(updateBidOutUrl,paramJson);
        CommonResponse<Boolean> response = null;
        try {
            logger.info("调用第三方接口发送参数：{}",paramJson);
//            response = systemDataPushService.exchangeDataWithUniversal(url, RequestMethod.POST, paramJson, appId,appSecret,appHost);
//            if(!response.isSuccess()) {
//                throw new BusinessException("调用第三方接口报错：" + response.getMsg());
//            }

            SupOfferVO supOfferVO = BeanMapper.map(tbVO, SupOfferVO.class);
            response = supNoticeApi.updateBidOut(supOfferVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用流标接口报错" + response.getMsg());
            }

            logger.info("调用第三方接口返回结果：{}",response.getData());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("调用第三方接口报错：" + e.getMessage());
        }
    }

    /**
     * 发布废标公示
     * @param id 废标单据id
     * @return 发布结果
     */
    @Override
    public WasteVO publishWaste(Long id) {
        //修改发布标志
        WasteEntity wasteEntity = super.selectById(id);
        wasteEntity.setPublishFlag(PUBLISH_FLAG_YES);
        super.updateById(wasteEntity);
        // 推送废标公示内容
        WasteBidTbVO wasteBidTbVO = new WasteBidTbVO();
        wasteBidTbVO.setSourceType("云南建投废标公告"); // 来源系统类型
        wasteBidTbVO.setSourceId(this.objToString(wasteEntity.getTenderId())); // 招标立项ID
        wasteBidTbVO.setTendentId(wasteEntity.getTenantId()); // 租户主键
        wasteBidTbVO.setSourceProjectId(this.objToString(wasteEntity.getProjectId())); //来源项目主键
        wasteBidTbVO.setProjectName(wasteEntity.getProjectName()); // 项目名称
        wasteBidTbVO.setProjectCode(wasteEntity.getProjectCode());//项目编码
        wasteBidTbVO.setSourceOrgId(this.objToString(wasteEntity.getOrgId())); // 来源组织主键
        wasteBidTbVO.setOrgName(wasteEntity.getOrgName()); //组织名称
        wasteBidTbVO.setSourceUnitId(this.objToString(wasteEntity.getUnitId())); //招标单位主键
        wasteBidTbVO.setUnitName(wasteEntity.getUnitName()); //招标单位名称
        wasteBidTbVO.setMemo(wasteEntity.getMemo()); // 备注
        wasteBidTbVO.setContent(wasteEntity.getContent()); //通知内容
        wasteBidTbVO.setWinbidType(WIN_BID_TYPE_2); //0-中标，1-流标，2-废标
        //材料-MATERIAL,分包-SUB，设备采购-PURCHASE,设备租赁-RENT,周转材租赁-RMAT,其他-OTHER
        wasteBidTbVO.setType(CommonUtils.getGysType(wasteEntity.getType()));
        wasteBidTbVO.setTenderName(wasteEntity.getTenderName()); //公告名称
        wasteBidTbVO.setTenderType(wasteEntity.getTenderType()); //招标方式
        wasteBidTbVO.setSourceEmployeeId(this.objToString(wasteEntity.getEmployeeId())); // 招标联系人主键
        wasteBidTbVO.setEmployeeName(wasteEntity.getEmployeeName()); //招标联系人名称
        wasteBidTbVO.setEmployeeMobile(wasteEntity.getEmployeeMobile()); //招标联系人电话

//        wasteBidTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
//        wasteContentTbVO.setNoticeBidTime(); // 开标时间
        wasteBidTbVO.setNoticeWinbidTime(wasteEntity.getApplyTime()); // 中标时间(废标时间)

        List<WasteBidTbVO> bidTbVOList = new ArrayList<>();
        bidTbVOList.add(wasteBidTbVO);
        //调用第三方接口
        String paramJson = JSON.toJSONString(bidTbVOList);
//        CommonResponse<JSONObject> response = null;
//        try {
//            logger.info("废标发布公示发送参数：{}",paramJson);
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,winbidSavesUrl, paramJson,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("调用第三方接口报错：" + response.getMsg());
//            }
//            logger.info("废标发布公示返回结果：{}",response.getData());
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("调用第三方接口报错：" + e.getMessage());
//        }
//        this.sendPostReq(winbidSavesUrl, paramJson);

        CommonResponse<Boolean> response = null;
        try {
            logger.info("调用第三方接口发送参数：{}",paramJson);
//            response = systemDataPushService.exchangeDataWithUniversal(url, RequestMethod.POST, paramJson, appId,appSecret,appHost);
//            if(!response.isSuccess()) {
//                throw new BusinessException("调用第三方接口报错：" + response.getMsg());
//            }

            List<WinbidVO> winBidVOList = BeanMapper.mapList(bidTbVOList, WinbidVO.class);
            response = supNoticeApi.winbidSave(winBidVOList);
            if(!response.isSuccess()) {
                throw new BusinessException("调用第三方接口报错：" + response.getMsg());
            }

            logger.info("调用第三方接口返回结果：{}",response.getData());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("调用第三方接口报错：" + e.getMessage());
        }
        return this.copyWasteBean(wasteEntity);
    }

    /**
     * 根据招标立项id给专家发送废标消息
     *
     * @param type     招标类型：0-材料，1-...
     * @param tenderId 招标立项id
     */
    @Override
    public void sendMsgByWaste(Integer type, Long tenderId) {
        // 发送的用户列表
        List<String> userList = new ArrayList<>();
        // 组织的内容
        Map<String, String> sendMap = new HashMap<>();
        if (CommonUtils.TYPE_OTHER == type) {
            this.pickSendOtherMsg(tenderId, userList, sendMap);
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + type + "]");
        }
        logger.info("发送信息给专家:>----------" + userList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(userList)
                && CollectionUtils.isNotEmpty(sendMap)) {
            String subject = sendMap.get(SEND_MAP_KEY_SUBJECT);
            String content = sendMap.get(SEND_MAP_KEY_CONTENT);
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
        }
    }

    /**
     * 废标后，专家组长汇总状态从“待汇总”调整为“已汇总”；专家的待评标调整为“已失效”
     *
     * @param tenderId 招标立项id
     */
    @Override
    public void updateExpertEvaluatingByWaste(Long tenderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
        List<ExpertEvaluatingEntity> expertEvaluatingEntityList = IExpertEvaluatingService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(expertEvaluatingEntityList)) {
            // 修改为已汇总
            UpdateWrapper<ExpertEvaluatingEntity> wraper = new UpdateWrapper();
            wraper.set("gather_status", 1).eq("invite_id", tenderId);
            IExpertEvaluatingService.update(wraper);

            List<Long> evaluationIdList = expertEvaluatingEntityList.stream().map(ExpertEvaluatingEntity::getId)
                    .collect(Collectors.toList());
            // 修改为已失效
            UpdateWrapper<ExpertEvaluatingDetailEntity> detailWraper = new UpdateWrapper();
            detailWraper.set("evaluation_state", 2).in("evaluation_id", evaluationIdList);
            IExpertEvaluatingDetailService.update(detailWraper);
            logger.info("废标生效，将评标状态修改为已失效，汇总状态改为已汇总");
        }
    }


    /**
     * 根据其他招标立项信息组装需要发送的消息
     *
     * @param tenderId 招标立项id
     * @param userList 发送消息列表
     * @param sendMap  发送消息参数map
     */
    private void pickSendOtherMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        // 获取招标立项信息
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
        // 招标文件阶段进行废标，此时应该去招标文件对应的专家表中查询专家数据
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage())
                || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode()
                .equals(otherInviteEntity.getTenderStage())
                || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage())
                || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage())) {
            // 获取招标文件信息
            List<OtherDocumentEntity> otherDocumentEntityList = otherDocumentService.queryList(queryParam);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(otherDocumentEntityList)) {
                Long documentId = otherDocumentEntityList.get(0).getId();
                // 获取专家信息
                List<OtherDocumentExpertEntity> otherInviteExpertEntityList = otherDocumentExpertService
                        .list(new QueryWrapper<OtherDocumentExpertEntity>().eq("document_id", documentId)
                                .eq("dr", 0));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(otherInviteExpertEntityList)) {
                    //                List<String> sender = new ArrayList<>();
                    //                //审批通过给专家发内部消息
                    //                for (OtherInviteExpertEntity otherInviteExpertEntity :
                    //                otherInviteExpertEntityList) {
                    //                    sender.add(otherInviteExpertEntity.getExpertId().toString());
                    //                }
                    List<String> expertList = otherInviteExpertEntityList.stream()
                            .filter(p -> p.getExpertId() != null)
                            .map(OtherDocumentExpertEntity::getExpertId)
                            .map(String::valueOf).collect(Collectors.toList());
                    userList.addAll(expertList);
                }
            }
        }
        // 其他招标阶段去专家评标数据表中查询专家数据
        else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        // 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
        String name = otherInviteEntity.getProjectName();
        // 【招标单位】招标的【项目名称】已废标
        String subject = otherInviteEntity.getUnitName() + "招标的" + name + "已废标";
        String content = otherInviteEntity.getUnitName() + "招标的" + name + "已废标";
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    /**
     * 查询公共部分的专家信息
     *
     * @param queryParam 查询条件
     * @param userList   用户列表
     */
    private void pickCommonSendMsg(QueryParam queryParam, List<String> userList) {
        List<ExpertEvaluatingEntity> expertEvaluatingEntityList = IExpertEvaluatingService.queryList(queryParam);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(expertEvaluatingEntityList)) {
            Long evaluationId = expertEvaluatingEntityList.get(0).getId();
            // 获取专家信息
            List<ExpertEvaluatingDetailEntity> expertEvaluatingDetailEntityList = IExpertEvaluatingDetailService
                    .list(new QueryWrapper<ExpertEvaluatingDetailEntity>().eq("evaluation_id", evaluationId)
                            .eq("dr", 0));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(expertEvaluatingDetailEntityList)) {
                List<String> expertList = expertEvaluatingDetailEntityList.stream().filter(p -> p.getExpertId() != null)
                        .map(ExpertEvaluatingDetailEntity::getExpertId)
                        .map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        }
    }


    /**
     * 根据废标VO查询采购清单
     *
     * @param tenderId 招标主键ID
     * @return 采购清单
     */
    private List<OtherInviteDetailVO> queryOtherInviteDetailByWaste(Long tenderId) {
        if (null == tenderId || tenderId == 0) return new ArrayList<>();
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter(QueryParam.EQ, tenderId));
        List<OtherInviteDetailEntity> list = otherInviteDetailService.queryList(param);
        return BeanMapper.mapList(list, OtherInviteDetailVO.class);
    }

    /**
     * 修改招标立项废标状态
     *
     * @param tenderId    招标立项id
     * @param tenderStage 招标阶段
     * @param type        招标类型：1-材料、2-....
     * @param addFlag     true:新增或修改，false：删除废标数据，恢复招标立项废标状态
     */
    private void updateInvite(Long tenderId, Integer tenderStage, Integer type, boolean addFlag) {
        if (CommonUtils.TYPE_OTHER == type) {
            this.updateOtherInviteByWaste(tenderId, tenderStage, addFlag);
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + type + "]");
        }
    }


    /**
     * 修改其他招标立项废标状态
     *
     * @param tenderId    招标立项id
     * @param tenderStage 招标阶段
     * @param addFlag     true:新增或修改，false：删除废标数据，恢复招标立项废标状态
     */
    private void updateOtherInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);
        if (otherInviteEntity != null && otherInviteEntity.getId() != 0) {
            // 新增时修改为废标
            Integer abolishType = otherInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                otherInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                otherInviteService
                        .updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            // 删除时修改为正常
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                otherInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                otherInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    /**
     * 初始化废标VO
     *
     * @param vo       废标vo
     * @param tenderId 招标立项id
     */
    private void initWasteVo(WasteVO vo, Long tenderId) {
        if (CommonUtils.TYPE_OTHER == vo.getType()) {
            this.initOtherWasteVo(vo, tenderId);
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + vo.getType() + "]");
        }
    }


    /**
     * 根据其他招标立项初始化废标信息
     *
     * @param vo       废标VO
     * @param tenderId 材料招标立项id
     */
    private void initOtherWasteVo(WasteVO vo, Long tenderId) {
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);
        if (otherInviteEntity != null) {
//            vo.setPurchaseId(stuffInviteEntity.getPurchaseId());// 采购方式ID
//            vo.setPurchaseName(stuffInviteEntity.getPurchaseName()); // 采购方式名称
            vo.setPurchaseType(otherInviteEntity.getPurchaseType()); // 采购方式(0-项目采购,1-单位采购)
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(otherInviteEntity.getPurchaseType()));
            vo.setProjectId(otherInviteEntity.getProjectId()); // 项目ID
            vo.setProjectName(otherInviteEntity.getProjectName()); // 项目名称
            vo.setProjectCode(otherInviteEntity.getProjectCode()); // 项目编码
            vo.setTenderId(otherInviteEntity.getId()); // 招标立项ID
            vo.setTenderName(otherInviteEntity.getTenderName()); //招标立项名称
            vo.setTenderType(otherInviteEntity.getTenderType()); // 招标方式
            vo.setTenderStage(otherInviteEntity.getTenderStage()); // 招标阶段
            vo.setOrgId(otherInviteEntity.getOrgId());
            vo.setOrgName(otherInviteEntity.getOrgName());
            vo.setParentOrgId(otherInviteEntity.getParentOrgId());
            vo.setParentOrgName(otherInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO); // 是否发布，默认否
            vo.setApplyTime(new DateTime());
//            vo.setStuffInviteDetailList(BeanMapper.mapList(stuffInviteEntity.getStuffDetail(), StuffInviteDetailVO
//            .class));// 采购明细列表
            vo.setOtherInviteDetailList(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        }
    }

    /**
     * 删除进程表
     *
     * @param billId   废标单据id
     * @param tenderId 招标立项id
     */
    private void deleteProcess(Long billId, Long tenderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billId", new Parameter(QueryParam.EQ, billId));
        queryParam.getParams().put("tenderId", new Parameter(QueryParam.EQ, tenderId));
        List<ProcessEntity> processEntityList = processService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(processEntityList)) {
            List<Long> idList = processEntityList.stream().map(ProcessEntity::getId).collect(Collectors.toList());
            processService.removeByIds(idList);
        }
    }

    /**
     * 实体转换为VO
     *
     * @param entity 实体
     * @return vo
     */
    private WasteVO copyWasteBean(WasteEntity entity) {
        String tenderTypeName;
        switch (entity.getTenderType()) {
            case 0:
                tenderTypeName = "平台公开招标";
                break;
            case 1:
                tenderTypeName = "邀请招标";
                break;
            case 2:
                tenderTypeName = "询价";
                break;
            case 3:
                tenderTypeName = "竞争性谈判";
                break;
            case 4:
                tenderTypeName = "单一来源";
                break;
            case 5:
                tenderTypeName = "紧急招标";
                break;
            default:
                tenderTypeName = null;
                break;
        }
        WasteVO vo = BeanMapper.map(entity, WasteVO.class);
        vo.setTenderTypeName(tenderTypeName);
        if (CommonUtils.TYPE_OTHER == vo.getType()) {
            vo.setOtherInviteDetailList(this.queryOtherInviteDetailByWaste(entity.getTenderId()));
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + vo.getType() + "]");
        }
        vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(entity.getPurchaseType()));
        return vo;
    }

    /**
     * 采购方式名称
     * @param purchaseType 采购方式
     * @return 采购方式名称
     */
    private String getPurchaseTypeNameByType(Integer purchaseType){
        String purchaseTypeName;
        switch (purchaseType) {
            case 0:
                purchaseTypeName = "项目采购";
                break;
            case 1:
                purchaseTypeName = "公司采购";
                break;
            default:
                purchaseTypeName = null;
                break;
        }
        return purchaseTypeName;
    }

    /**
     * 调用第三方接口
     * @param url 接口URL
     * @param paramJson 接口参数
     */
//    private void sendPostReq(String url,String paramJson){
//        CommonResponse<String> response = null;
//        try {
//            logger.info("调用第三方接口发送参数：{}",paramJson);
//            response = systemDataPushService.exchangeDataWithUniversal(url, RequestMethod.POST, paramJson, appId,appSecret,appHost);
//            if(!response.isSuccess()) {
//                throw new BusinessException("调用第三方接口报错：" + response.getMsg());
//            }
//            logger.info("调用第三方接口返回结果：{}",response.getData());
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("调用第三方接口报错：" + e.getMessage());
//        }
//    }

    /**
     * Object转String
     *
     * @param obj 需要转换的obj
     * @return 转换后的String
     */
    private String objToString(Object obj) {
        if (obj == null) return null;
        return String.valueOf(obj);
    }

    /**
     * 废标保存校验
     *
     * @param vo 保存参数
     */
    private void checkWaste(WasteVO vo) {
        Long tenderId = vo.getTenderId();
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter(QueryParam.EQ, tenderId));
        if (CommonUtils.TYPE_OTHER == vo.getType()) {
            this.checkOtherWaste(param);
        }
        else {
            throw new BusinessException("不存在招标立项类型[" + vo.getType() + "]");
        }
    }



    /**
     * 校验其他招标
     *
     * @param param 查询参数
     */
    private void checkOtherWaste(QueryParam param) {
        List<OtherDocumentEntity> otherDocumentEntityList = otherDocumentService.queryList(param);
        // 如果是未开标
        if (CollectionUtils.isEmpty(otherDocumentEntityList)
                || !BID_FLAG.equals(otherDocumentEntityList.get(0).getBidFlag())) {
            logger.error("当前项目未开标，无法进行废标！");
            throw new BusinessException("当前项目未开标！");
        }
        // 如果是定标已提交
        List<OtherPicketageEntity> otherPicketageEntityList = otherPicketageService.queryList(param);
        if (CollectionUtils.isNotEmpty(otherPicketageEntityList)) {
            Integer stuffState = otherPicketageEntityList.get(0).getBillState();
            // 定标审批通过不能进行废标
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState)
                    || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                logger.error("当前项目已定标，无法进行废标！");
                throw new BusinessException("当前项目已定标！");
            }
        }
    }

}
