package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.other.vo.OtherBidVO;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("otherPicketage")
public class OtherPicketageBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOtherPicketageService otherPicketageService;
	@Autowired
	private IOtherBidService otherBidService;
	@Autowired
	private IOtherWinnoticeService otherWinnoticeService;
	@Autowired
	private IOtherInviteService otherInviteService;
	@Autowired
	private IOtherAdviceService otherAdviceService;
	@Autowired
	private IOtherBidDetailService otherBidDetailService;
	@Autowired
	private IOtherDocumentSellService otherDocumentSellService;
	@Autowired
	private IOtherBidSupplierService otherBidSupplierService;
	@Autowired
	private IOtherDocumentSupplierService otherDocumentSupplierService;
	@Autowired
	private IProcessService processService;
	@Autowired
	private ISupplierApi supplierApi;
	@Autowired
	private IOtherPicketageRefsupplierService otherPicketageRefsupplierService;
	@Autowired
	private IOtherPicketageSupplierService otherPicketageSupplierService;
	@Autowired
	private IOtherInviteDetailRecordService otherInviteDetailRecordService;
	@Autowired
	private IProjectApi projectApi;

	@Value("${gysUrl.updateTimeUrl}")
	private String updateTimeUrl;

	@Value("${gysUrl.winbidSavesUrl}")
	private String winbidSavesUrl;
	private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OtherBidVO otherBidVO = otherBidService.saveBid(billId);
		otherBidService.publishBid(otherBidVO);

		//处理参照表,只处理项目线的数据
		//查询出所有定标的数据

		OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(billId);
		OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherPicketageEntity.getInviteId());

		// 完成采购计划
		QueryParam otherInviteDetailQueryParam = new QueryParam();
		otherInviteDetailQueryParam.getParams()
				.put("invite_id", new Parameter(QueryParam.EQ, otherInviteEntity.getId()));
		List<OtherInviteDetailRecordEntity> otherInviteDetailEntityList = otherInviteDetailRecordService
				.queryList(otherInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(otherInviteDetailEntityList)) {
			List<String> planIdList = otherInviteDetailEntityList.stream()
					.map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
					.collect(Collectors.toList());
			// 释放采购计划
//			batPlanApi.updateBatPlanQuote(planIdList, PurchasePlanEnum.PLAN_STATE_OVER.getPlanState());
		}

//		if (otherInviteEntity.getPurchaseType().equals(0)) {
		LambdaQueryWrapper<OtherDocumentSellEntity> sellWrapper = Wrappers.lambdaQuery();
		sellWrapper.eq(OtherDocumentSellEntity::getDocumentId, otherPicketageEntity.getDocumentId());
		sellWrapper.eq(OtherDocumentSellEntity::getTenderFlag, 1);
		List<OtherDocumentSellEntity> otherDocumentSellList = otherDocumentSellService.list(sellWrapper);
		//项目招标
		//改造-0905
		Map<Long, ProjectRegisterVO> proMap = new HashMap<>();
		if (otherInviteEntity.getPurchaseType().equals(0)){
			List<Long> projectPks = otherDocumentSellList.stream().map(OtherDocumentSellEntity::getProjectId).collect(Collectors.toList());
//			CommonResponse<ProjectRegisterVO> jsonArrayCommonResponse = projectApi.queryProjectByIds(projectPks);
			CommonResponse<List<ProjectRegisterVO>> projectByIds = projectApi.queryProjectByIds(projectPks);

			if (projectByIds.isSuccess()){
//				JSONArray data = jsonArrayCommonResponse.getData();
				List<ProjectRegisterVO> projectRegisterVOS = projectByIds.getData();
				proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectRegisterVO::getId, Function.identity()));
			}
		}
		Map<String, List<OtherDocumentSellEntity>> dataMap = new HashMap<>();
		for (OtherDocumentSellEntity otherDocumentSellEntity : otherDocumentSellList) {
			//改造-0905
			if (otherInviteEntity.getPurchaseType().equals(0)){
				ProjectRegisterVO projectPoolSetVO = proMap.get(otherDocumentSellEntity.getProjectId());
				if (projectPoolSetVO != null){
					otherDocumentSellEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
//					otherDocumentSellEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
				}
			}
			String s = null;
			if (otherInviteEntity.getPurchaseType().equals(0)){
				s = otherDocumentSellEntity.getProjectId().toString() + otherDocumentSellEntity.getSupplierId()
						.toString();
			}
			if (otherInviteEntity.getPurchaseType().equals(1)){
				s = otherDocumentSellEntity.getSupplierId()
						.toString();
			}

			if (dataMap.containsKey(s)) {
				List<OtherDocumentSellEntity> otherDocumentSellEntityList = dataMap.get(s);
				otherDocumentSellEntityList.add(otherDocumentSellEntity);
				dataMap.put(s,otherDocumentSellEntityList);
			}else {
				List<OtherDocumentSellEntity> otherDocumentSellEntities = new ArrayList<>();
				otherDocumentSellEntities.add(otherDocumentSellEntity);
				dataMap.put(s,otherDocumentSellEntities);
			}
		}
		List<OtherPicketageRefsupplierEntity> otherPicketageRefsupplieotherities = new ArrayList<>();
		dataMap.forEach((key,value) -> {
			OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = new OtherPicketageRefsupplierEntity();
			OtherDocumentSellEntity otherSellEntity = value.stream().findFirst().get();
			otherPicketageRefsupplierEntity.setSupplierId(otherSellEntity.getSupplierId());
			otherPicketageRefsupplierEntity.setSupplierName(otherSellEntity.getSupplierName());
			otherPicketageRefsupplierEntity.setProjectId(otherSellEntity.getProjectId());
			otherPicketageRefsupplierEntity.setProjectName(otherSellEntity.getProjectName());
			otherPicketageRefsupplierEntity.setProjectCode(otherInviteEntity.getProjectCode());
			otherPicketageRefsupplierEntity.setPicketageId(billId);
			otherPicketageRefsupplierEntity.setOccupyFlag(0);
			SupplierVO supplierVO = supplierApi.queryById(otherSellEntity.getSupplierId()).getData();
			otherPicketageRefsupplierEntity.setSupplierTenantId(supplierVO.getTenant());
			otherPicketageRefsupplierEntity.setPicketageName(otherPicketageEntity.getPicketageName());
			otherPicketageRefsupplierEntity.setPicketageDate(new Date());
			//改造-0905
			if (otherInviteEntity.getPurchaseType().equals(0)){
				otherPicketageRefsupplierEntity.setOrgId(otherSellEntity.getOrgId());
				otherPicketageRefsupplierEntity.setOrgName(otherSellEntity.getOrgName());
			}
			if (otherInviteEntity.getPurchaseType().equals(1)){
				otherPicketageRefsupplierEntity.setOrgId(otherInviteEntity.getOrgId());
				otherPicketageRefsupplierEntity.setOrgName(otherInviteEntity.getOrgName());
			}
			otherPicketageRefsupplierEntity.setOrgId(otherInviteEntity.getOrgId());
			otherPicketageRefsupplierEntity.setOrgName(otherInviteEntity.getOrgName());
			otherPicketageRefsupplierEntity.setParentOrgId(otherInviteEntity.getParentOrgId());
			otherPicketageRefsupplierEntity.setParentOrgName(otherInviteEntity.getParentOrgName());
			otherPicketageRefsupplierEntity.setPicketageFlag(0);
			otherPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
			otherPicketageRefsupplierEntity.setPurchaseType(otherInviteEntity.getPurchaseType());
			BigDecimal tenderMoney = BigDecimal.ZERO;
			BigDecimal tenderMoneyTax = BigDecimal.ZERO;
			for (OtherDocumentSellEntity otherDocumentSellEntity : value){
				tenderMoney = tenderMoney.add(otherDocumentSellEntity.getTenderMoney());
				tenderMoneyTax = tenderMoneyTax.add(otherDocumentSellEntity.getTenderMoneyTax());
			}
			otherPicketageRefsupplierEntity.setMoney(tenderMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
			otherPicketageRefsupplierEntity.setMoneyTax(tenderMoneyTax.setScale(2, BigDecimal.ROUND_HALF_UP));
			otherPicketageRefsupplieotherities.add(otherPicketageRefsupplierEntity);
		});
		otherPicketageRefsupplierService.saveBatch(otherPicketageRefsupplieotherities);
//		}
		//生成中标通知书类表数据
		List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
		List<OtherAdviceEntity> otherAdviceList = BeanMapper.mapList(picketageSupplierList, OtherAdviceEntity.class);
		for (OtherAdviceEntity otherAdviceEntity : otherAdviceList){
			otherAdviceEntity.setTitleName(otherInviteEntity.getTenderName());
			otherAdviceEntity.setUnitId(otherInviteEntity.getUnitId());
			otherAdviceEntity.setUnitName(otherInviteEntity.getUnitName());
			otherAdviceEntity.setProjectId(otherInviteEntity.getProjectId());
			otherAdviceEntity.setProjectName(otherInviteEntity.getProjectName());
			otherAdviceEntity.setOrgId(otherInviteEntity.getOrgId());
			otherAdviceEntity.setOrgName(otherInviteEntity.getOrgName());
			otherAdviceEntity.setParentOrgId(otherInviteEntity.getParentOrgId());
			otherAdviceEntity.setParentOrgName(otherInviteEntity.getParentOrgName());
			otherAdviceEntity.setParentOrgName(otherInviteEntity.getParentOrgName());
			otherAdviceEntity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(otherInviteEntity.getTenderType()).getDescription());
			otherAdviceEntity.setLineTypeName(CommonUtils.getTypeName(5));
			otherAdviceEntity.setPurchaseType(otherInviteEntity.getPurchaseType());
			otherAdviceEntity.setScFlag(1);
			otherAdviceEntity.setSendFlag(1);
			otherAdviceEntity.setSignFlag(0);
			otherAdviceEntity.setId(null);

			otherAdviceEntity.setInviteId(otherInviteEntity.getId());
		}
		otherAdviceService.saveBatch(otherAdviceList);




		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
