package com.ejianc.business.tender.abolish.controller;

import java.io.Serializable;

import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.tender.abolish.bean.WasteEntity;
import com.ejianc.business.tender.abolish.service.IWasteService;
import com.ejianc.business.tender.abolish.vo.WasteVO;

/**
 * 废标记录表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("waste")
@Api(value = "废标记录表", tags = {"废标记录表"})
public class WasteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWasteService service;
    @Autowired
    private IExpertEvaluatingService evaluatingService;

    private static final String BILL_CODE = "WASTE_CODE";//此处需要根据实际修改

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WasteVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody WasteVO saveorUpdateVO) {
        if(saveorUpdateVO.getId() == null || saveorUpdateVO.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                saveorUpdateVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        WasteVO vo = service.saveOrUpdateByVo(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WasteVO> queryDetail(@RequestParam Long id) {
//        WasteEntity entity = service.selectById(id);
//        if (entity == null || entity.getId() == 0) {
//            return CommonResponse.success("查询详情数据成功！",new WasteVO());
//        }
//        WasteVO vo = BeanMapper.map(entity,WasteVO.class);
//        vo.setStuffInviteDetailList(service.queryInviteDetailByWaste(vo.getTenderId()));
        WasteVO vo = service.queryDetailById(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WasteVO> vos) {
//        service.removeByIds(vos.stream().map(WasteVO::getId).collect(Collectors.toList()),true);
        service.deleteByListVo(vos);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WasteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<WasteEntity> page = service.queryPage(param,false);
        IPage<WasteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WasteVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WasteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Waste-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refWasteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WasteVO>> refWasteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WasteEntity> page = service.queryPage(param,false);
        IPage<WasteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WasteVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 查询废标数据
     * @param tenderId 立项ID
     * @Return void
     */
    @ApiOperation("查询废标数据")
    @RequestMapping(value = "/queryWasteByTenderId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WasteVO> queryWasteByTenderId(Long tenderId){
        WasteVO vo = service.selectWasteVo(tenderId);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description 发布废标公示
     * @param id 废标单据id
     * @Return 发布结果
     */
    @ApiOperation("发布废标公示")
    @RequestMapping(value = "/publishWaste", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WasteVO> publishWaste(Long id){
        WasteVO vo = service.publishWaste(id);
        return CommonResponse.success("发布废标公示成功！",vo);
    }
}
