package com.ejianc.business.tender.abolish.service;

import com.ejianc.business.tender.abolish.bean.FlowEntity;
import com.ejianc.business.tender.abolish.vo.FlowTbVO;
import com.ejianc.business.tender.abolish.vo.FlowVO;
import com.ejianc.framework.skeleton.template.IBaseService;


import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 流标表
 *
 * @author generator
 */
public interface IFlowService extends IBaseService<FlowEntity> {

    /**
     * 保存
     *
     * @param saveorUpdateVO 保存数据
     * @return 返回数据
     */
    FlowVO saveFlow(FlowVO saveorUpdateVO);

    /**
     * 查询详情
     *
     * @param id 流标id
     * @return 查询结果
     */
    FlowVO queryDetail(Long id);

    /**
     * 批量删除流标
     *
     * @param vos 删除流标id列表
     */
    void deleteFlow(List<FlowVO> vos);

    //发布
    FlowVO publishFlow(Long id);

    //一淘汰
    FlowTbVO updateBidOut(Long id);

    //流标
    FlowVO flowBid(Long tenderId);
}
