package com.ejianc.business.tender.abolish.service;

import com.ejianc.business.tender.abolish.vo.WasteVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.tender.abolish.bean.WasteEntity;

import java.util.List;

/**
 * 废标记录表
 * 
 * @author generator
 * 
 */
public interface IWasteService extends IBaseService<WasteEntity> {


    /**
     * 新增或修改
     * @param saveOrUpdateVO 新增或修改数据
     * @return 新增或修改后数据
     */
    WasteVO saveOrUpdateByVo(WasteVO saveOrUpdateVO);

    /**
     * 批量删除
     * @param voList 删除数据
     */
    void deleteByListVo(List<WasteVO> voList);

    /**
     * 根据id查询详情
     * @param tenderId tenderId 招标立项ID
     * @return 废标详情
     */
    WasteVO selectWasteVo(Long tenderId);

    /**
     * 根据id查询详情
     * @param id 废标单据id
     * @return 废标详情
     */
    WasteVO queryDetailById(Long id);


    /**
     * 推送废标消息
     * @param id 废标单据id
     */
    void updateGysByWaste(Long id);

    /**
     * 发布废标公示
     *
     * @param id 废标单据id
     * @return 发布结果
     */
    WasteVO publishWaste(Long id);

    /**
     * 根据招标立项id给专家发送废标消息
     *
     * @param type     招标类型：0-材料，1-...
     * @param tenderId 招标立项id
     */
    void sendMsgByWaste(Integer type, Long tenderId);

    /**
     * 废标后，专家组长汇总状态从“待汇总”调整为“已汇总”；专家的待评标调整为“已失效”
     *
     * @param tenderId 招标立项id
     */
    void updateExpertEvaluatingByWaste(Long tenderId);
}
