
package com.ejianc.business.tender.abolish.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tender.abolish.bean.FlowEntity;
import com.ejianc.business.tender.abolish.service.IFlowService;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentExpertEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentExpertService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service("flow")
public class FlowBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IFlowService service;
	@Autowired
	private IPushMessageApi pushMessageApi;
	@Autowired
	private IOtherInviteService otherInviteService;

	/** 其他文件 */
	@Autowired
	private IOtherDocumentService otherDocumentService;

	/** 其他专家 */
	@Autowired
	private IOtherDocumentExpertService otherDocumentExpertService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE
				.getBillStateCode().equals(state)) {
			service.updateBidOut(billId);//修改状态
			//获取流标信息
			FlowEntity flowEntity = service.getById(billId);
			if (CommonUtils.TYPE_OTHER == flowEntity.getType()) {
				this.execOther(flowEntity.getTenderId());
			}
			else {
				throw new BusinessException("不存在招标立项类型[" + flowEntity.getType() + "]");
			}

		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}




	/**
	 * 处理其他招标信息
	 *
	 * @param tenderId 招标立项id
	 */
	private void execOther(Long tenderId) {
		// 获取招标立项信息
		OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);
		// 获取招标文件信息
		QueryParam documentParam = new QueryParam();
		documentParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
		List<OtherDocumentEntity> otherDocumentEntityList = otherDocumentService.queryList(documentParam);
		if (CollectionUtils.isNotEmpty(otherDocumentEntityList)) {
			Long documentId = otherDocumentEntityList.get(0).getId();
			// 获取专家信息
			List<OtherDocumentExpertEntity> otherInviteExpertEntityList = otherDocumentExpertService
					.list(new QueryWrapper<OtherDocumentExpertEntity>().eq("document_id", documentId)
							.eq("dr", 0));
			if (CollectionUtils.isNotEmpty(otherInviteExpertEntityList)) {
//                List<String> sender = new ArrayList<>();
//                //审批通过给专家发内部消息
//                for (OtherInviteExpertEntity otherInviteExpertEntity : otherInviteExpertEntityList) {
//                    sender.add(otherInviteExpertEntity.getExpertId().toString());
//                }
				List<String> userList = otherInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null)
						.map(OtherDocumentExpertEntity::getExpertId)
						.map(String::valueOf).collect(Collectors.toList());
				// 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
				String name = otherInviteEntity.getProjectName();
				logger.info("发送信息给专家:>----------" + userList);
				// 【招标单位】招标的【项目名称】已废标
				String subject = otherInviteEntity.getUnitName() + "招标的" + name + "已流标";
				String content = otherInviteEntity.getUnitName() + "招标的" + name + "已流标";
				logger.info("发送信息的内容:>----------" + content);
				new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
			}
		}
	}

}
