package com.ejianc.business.tender.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 截止状态
 */
public enum TenderStateEnum {
    /**
     */
    报名中(1, "报名中"),

    /**
     */
    报价中(2, "报价中"),

    /**
     */
    专家评标中(3, "专家评标中"),

    /**
     */
    专家评标结束(4, "专家评标结束");


    private Integer code;
    private String description;
    private static Map<Integer, TenderStateEnum> enumMap = new HashMap<>();

    TenderStateEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(TenderStateEnum.class).stream().collect(Collectors.toMap(TenderStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static TenderStateEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
