package com.ejianc.business.tender.expert.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料专家评标专家子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_expert_evaluating_detail")
public class ExpertEvaluatingDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="expert_id")
    private Long expertId; // 专家ID
    @TableField(value="expert_name")
    private String expertName; // 专家名称
    @TableField(value="unit_id")
    private Long unitId; // 所属单位ID
    @TableField(value="unit_name")
    private String unitName; // 所属单位名称
    @TableField(value="mobile")
    private String mobile; // 手机号
    @TableField(value="field_name")
    private String fieldName; // 专业领域
    @TableField(value="evaluation_state")
    private Integer evaluationState; // 评标状态（0-待评标，1-已评标，2-已失效,3-已驳回）
    @TableField(value="evaluation_id")
    private Long evaluationId; // 专家评标主键
    @TableField(value="post_name")
    private String postName; // 岗位
    @TableField(value="type_name")
    private String typeName; // 类型
    @TableField(value="grade_name")
    private String gradeName; // 级别
    @TableField(value="leader")
    private Integer leader; // 是否组长（0-是，1-不是）
    @TableField(value="selection_type")
    private String selectionType; // 选取方式
    @TableField(value="evaluation_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date evaluationTime; // 评标时间
    @TableField(value="specialist_id")
    private Long specialistId; // 专家库主键
    @TableField(value="dept_id")
    private java.lang.Long deptId; // 部门id
    @TableField(value="dept_name")
    private java.lang.String deptName; // 部门名称
    @TableField(value="memo")
    private String memo; // 备注

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getSpecialistId() {
        return specialistId;
    }

    public void setSpecialistId(Long specialistId) {
        this.specialistId = specialistId;
    }

    public Date getEvaluationTime() {
        return evaluationTime;
    }

    public void setEvaluationTime(Date evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    /**
     * 岗位
     */
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    /**
     * 类型
     */
    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    /**
     * 级别
     */
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 是否组长（0-是，1-不是）
     */
    public Integer getLeader() {
        return leader;
    }

    public void setLeader(Integer leader) {
        this.leader = leader;
    }
    /**
     * 选取方式（0-手动，1-随机）
     */
    public String getSelectionType() {
        return selectionType;
    }

    public void setSelectionType(String selectionType) {
        this.selectionType = selectionType;
    }

    /**
     * 专家ID
     */
    public Long getExpertId() {
        return expertId;
    }

    /**
     * 专家ID
     */
    public void setExpertId(Long expertId) {
        this.expertId = expertId;
    }
    /**
     * 专家名称
     */
    public String getExpertName() {
        return expertName;
    }

    /**
     * 专家名称
     */
    public void setExpertName(String expertName) {
        this.expertName = expertName;
    }
    /**
     * 所属单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 所属单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 所属单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 所属单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 手机号
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * 手机号
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    /**
     * 专业领域
     */
    public String getFieldName() {
        return fieldName;
    }

    /**
     * 专业领域
     */
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
    /**
     * 评标状态（0-待评标，1-已评标，2-已失效,3-已驳回）
     */
    public Integer getEvaluationState() {
        return evaluationState;
    }

    /**
     * 评标状态（0-待评标，1-已评标，2-已失效,3-已驳回）
     */
    public void setEvaluationState(Integer evaluationState) {
        this.evaluationState = evaluationState;
    }
    /**
     * 专家评标主键
     */
    public Long getEvaluationId() {
        return evaluationId;
    }

    /**
     * 专家评标主键
     */
    public void setEvaluationId(Long evaluationId) {
        this.evaluationId = evaluationId;
    }
    
}
