package com.ejianc.business.tender.expert.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 二次报价表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_expert_repetition")
public class ExpertRepetitionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="template_id")
    private Long templateId; // 模板Id
    @TableField(value="template_name")
    private String templateName; // 模板名称
    @TableField(value="evaluation_name")
    private String evaluationName; // 评标名称
    @TableField(value="employee_id")
    private Long employeeId; // 招标联系人
    @TableField(value="employee_name")
    private String employeeName; // 招标联系人名称
    @TableField(value="repetiter_id")
    private Long repetiterId; //二次评标发起人
    @TableField(value="repetiter_name")
    private String repetiterName; // 二次评标发起人
    @TableField(value="employee_mobile")
    private String employeeMobile; // 招标联系人电话
    @TableField(value="start_time")
    private Date startTime; // 评标开始日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="invite_id")
    private Long inviteId; // 招标ID
    @TableField(value="document_id")
    private Long documentId; // 招标文件主键
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    @TableField(value="gather_status")
    private Integer gatherStatus; // 汇总状态(0-待汇总,1-已汇总)
    @TableField(value="gather_reason")
    private String gatherReason; // 汇总原因
    @TableField(value="invite_type")
    private Integer inviteType; // 招标类型(0-材料,1-劳务....)
    @TableField(value="distinction_flag")
    private Integer distinctionFlag; // 是否区分商务/技术（0-是，1-否）
    @TableField(value="sub_type")
    private Long subType; // 分包类型 ,0-专业分包,1-劳务分包
    @TableField(value="unit_id")
    private Long unitId; // 招标单位ID
    @TableField(value="unit_name")
    private String unitName; // 
    @TableField(value="equipment_type")
    private Integer equipmentType; // 设备属性(0-机械设备租赁，1-机械承揽)
    @TableField(value="tender_money")
    private BigDecimal tenderMoney; // 招标控制金额
    @TableField(value="talk_num")
    private Integer talkNum; // 含本次二次报价次数
    @TableField(value="repetition_reason")
    private String repetitionReason; // 发起二次报价原因
    @TableField(value="evaluating_id")
    private Long evaluatingId; // 评标汇总id
    @TableField(value="bid_flag")
    private Integer bidFlag; // 是否开标,1-是,0-否
    @TableField(value="publish_flag")
    private Integer publishFlag; // 是否发布,1-是,0-否
    @TableField(exist=false)
    @SubEntity(serviceName="expertRepetitionSupplierService", pidName= "repetitionId")
    private List<ExpertRepetitionSupplierEntity> expertRepetitionSupplierList = new ArrayList<>(); // 二次报价-供应商表

    public Long getRepetiterId() {
        return repetiterId;
    }

    public void setRepetiterId(Long repetiterId) {
        this.repetiterId = repetiterId;
    }

    public String getRepetiterName() {
        return repetiterName;
    }

    public void setRepetiterName(String repetiterName) {
        this.repetiterName = repetiterName;
    }

    public List<ExpertRepetitionSupplierEntity> getExpertRepetitionSupplierList() {
        return expertRepetitionSupplierList;
    }

    public void setExpertRepetitionSupplierList(List<ExpertRepetitionSupplierEntity> expertRepetitionSupplierList) {
        this.expertRepetitionSupplierList = expertRepetitionSupplierList;
    }

    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }

    public Integer getPublishFlag() {
        return publishFlag;
    }

    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }

    public Long getEvaluatingId() {
        return evaluatingId;
    }

    public void setEvaluatingId(Long evaluatingId) {
        this.evaluatingId = evaluatingId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
    public String getEvaluationName() {
        return evaluationName;
    }

    public void setEvaluationName(String evaluationName) {
        this.evaluationName = evaluationName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    public Long getDocumentId() {
        return documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    public Integer getGatherStatus() {
        return gatherStatus;
    }

    public void setGatherStatus(Integer gatherStatus) {
        this.gatherStatus = gatherStatus;
    }
    public String getGatherReason() {
        return gatherReason;
    }

    public void setGatherReason(String gatherReason) {
        this.gatherReason = gatherReason;
    }
    public Integer getInviteType() {
        return inviteType;
    }

    public void setInviteType(Integer inviteType) {
        this.inviteType = inviteType;
    }
    public Integer getDistinctionFlag() {
        return distinctionFlag;
    }

    public void setDistinctionFlag(Integer distinctionFlag) {
        this.distinctionFlag = distinctionFlag;
    }
    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Integer getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(Integer equipmentType) {
        this.equipmentType = equipmentType;
    }
    public BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    public void setTenderMoney(BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    public String getRepetitionReason() {
        return repetitionReason;
    }

    public void setRepetitionReason(String repetitionReason) {
        this.repetitionReason = repetitionReason;
    }
    
}
