package com.ejianc.business.tender.expert.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.RandomRuleEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertFieldDetailService;
import com.ejianc.business.tender.expert.service.IRandomRuleService;
import com.ejianc.business.tender.expert.vo.*;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.expert.bean.ExpertEntity;
import com.ejianc.business.tender.expert.service.IExpertService;

/**
 * 专家库主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("expert")
public class ExpertController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IEmployeeApi employeeApi;

    private static final String BILL_CODE = "EXPERT_CODE";//此处需要根据实际修改
    private static final String EXPERT_CODE = "BT211110000000001";
    @Autowired
    private IExpertService service;
    @Autowired
    private IRandomRuleService randomRuleService;
    @Autowired
    private IExpertEvaluatingDetailService IExpertEvaluatingDetailService;
    @Autowired
    private IExpertFieldDetailService expertFieldDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpertVO> saveOrUpdate(@RequestBody ExpertVO saveorUpdateVO) {
        ExpertVO vo = service.saveOrUpdate(saveorUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 启停用
     */
    @RequestMapping(value = "/startUpdate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertVO> startUpdate(@RequestParam Long id, Integer state) {
        ExpertEntity expertEntity = service.selectById(id);
        //该专家是否有未评标
        LambdaQueryWrapper<ExpertEvaluatingDetailEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertEvaluatingDetailEntity::getExpertId,expertEntity.getExpertId());
        lambda.in(ExpertEvaluatingDetailEntity::getEvaluationState,0,3);
        List<ExpertEvaluatingDetailEntity> list = IExpertEvaluatingDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("单据被引用不能调整状态！");
        }
        expertEntity.setState(state);
        service.saveOrUpdate(expertEntity, false);
        ExpertVO vo = BeanMapper.map(expertEntity, ExpertVO.class);
        return CommonResponse.success("启用停用状态调整成功！",vo);
    }
    /**
     * @Description  是否带评标校验
     */
    @RequestMapping(value = "/bidEvaluation", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> bidEvaluation(@RequestParam Long id) {
        Boolean aBoolean = service.bidEvaluation(id);
        return CommonResponse.success("是否待评标！",aBoolean);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertVO> queryDetail(Long id) {
    	ExpertEntity entity = service.selectById(id);
    	ExpertVO vo = BeanMapper.map(entity, ExpertVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertVO> vos) {
        service.removeByIds(vos.stream().map(ExpertVO::getId).collect(Collectors.toList()),true);
        expertFieldDetailService.removes(vos.stream().map(ExpertVO::getExpertId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("expertName");
        fuzzyFields.add("mobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fieldName");
        fuzzyFields.add("postName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("unitId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ExpertEntity> page = service.queryPage(param,false);
        IPage<ExpertVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertVO.class));

//  		List<ExpertVO> ExpertVOList = BeanMapper.mapList( page.getRecords(), ExpertVO.class);
//        if(CollectionUtils.isNotEmpty(ExpertVOList)){
//            ExpertVOList.forEach(e-> {
//                switch (e.getEmployeeType()) {
//                    case 1:
//                        e.setEmployeeTypeName("在职");
//                        break;
//                    case 2:
//                        e.setEmployeeTypeName("离职");
//                        break;
//                    case 3:
//                        e.setEmployeeTypeName("退休");
//                        break;
//                    case 4:
//                        e.setEmployeeTypeName("退休返聘");
//                        break;
//                    case 5:
//                        e.setEmployeeTypeName("派驻人员");
//                        break;
//                    case 6:
//                        e.setEmployeeTypeName("外借人员");
//                        break;
//                    case 7:
//                        e.setEmployeeTypeName("外聘员工");
//                        break;
//                    case 8:
//                        e.setEmployeeTypeName("待岗人员");
//                        break;
//                    case 9:
//                        e.setEmployeeTypeName("过路人员");
//                        break;
//                        case 10:
//                        e.setEmployeeTypeName("三庄人员");
//                        break;
//                    case 11:
//                        e.setEmployeeTypeName("挂证人员");
//                        break;
//                    case 12:
//                        e.setEmployeeTypeName("应聘人员");
//                        break;
//                    case 13:
//                        e.setEmployeeTypeName("其它");
//                        break;
//                    case 14:
//                        e.setEmployeeTypeName("劳务派遣");
//                        break;
//
//                }
//            });
//    }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("expertName");
        fuzzyFields.add("mobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fieldName");
        fuzzyFields.add("postName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("unitId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExpertEntity> list = service.queryList(param);
        List<ExpertExportVO> ExpertExportVOS = new ArrayList<>();
        list.forEach(val ->{
            ExpertExportVO ExpertExportVO = BeanMapper.map(val, ExpertExportVO.class);
            ExpertExportVO.setEmployeeTime(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",val.getEmployeeTime()));
            switch (val.getState()){
                case 0: ExpertExportVO.setState("启用");break;
                case 1: ExpertExportVO.setState("停用");break;
            };
            switch (val.getBillState()){
                case 0: ExpertExportVO.setBillState("自由态");break;
                case 1: ExpertExportVO.setBillState("已提交");break;
                case 2: ExpertExportVO.setBillState("审批中");break;
                case 3: ExpertExportVO.setBillState("审批通过");break;
                case 4: ExpertExportVO.setBillState("审批驳回");break;
                case 5: ExpertExportVO.setBillState("审批中");break;
            }
            ExpertExportVOS.add(ExpertExportVO);
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", ExpertExportVOS);
        ExcelExport.getInstance().export("expert.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refExpertData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExpertVO>> refExpertData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                          String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("expertName");
        param.getFuzzyFields().add("mobile");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("fieldName");
        param.getFuzzyFields().add("postName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
//        /** 组织隔离 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("state", new Parameter("eq",0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,billStates));
        IPage<ExpertEntity> page = service.queryPage(param,false);
        IPage<ExpertVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description queryExpertDetail 随机查询
     * @param
     */
    @RequestMapping(value = "/randomSelect", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ExpertVO>> randomSelect(@RequestParam Integer expertNum, String fieldNames){
        List<ExpertVO> expertVOS = service.randomSelect(expertNum,fieldNames);
        return CommonResponse.success("查询成功！",expertVOS);
    }
    /**
     * @Description queryExpertDetail 随机查询二
     * @param
     */
    @RequestMapping(value = "/randomSelectTwo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExpertVO>> randomSelectTwo(@RequestBody RandomExpertVO randomExpertVO){
         List<ExpertVO> expertVOS = service.randomSelectTwo(randomExpertVO.getExpertNum(), randomExpertVO.getExpertVOS(), randomExpertVO.getInviteId());
        return CommonResponse.success("查询成功！",expertVOS);
    }
    /**
     * @Description queryExpertDetail 随机查询plus
     * @param
     */
    @RequestMapping(value = "/randomSelectPlus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExpertVO>> test(@RequestBody RandomExpertVO randomExpertVO){
        List<ExpertVO> expertVOS = service.randomSelectPlus(randomExpertVO.getExpertNum(), randomExpertVO.getExpertVOS(), randomExpertVO.getInviteId(),randomExpertVO.getInviteType());
        return CommonResponse.success("查询成功！",expertVOS);
    }
    /**
     * @Description queryExpertDetail 专家校验plus
     * @param
     */
    @RequestMapping(value = "/checkOutPlus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<String>> checkOutPlus(@RequestBody RandomExpertVO randomExpertVO){
        List<String> expertVOS = service.checkOutPlus(randomExpertVO.getExpertVOS(), randomExpertVO.getInviteId(),randomExpertVO.getInviteType());
        return CommonResponse.success("查询成功！",expertVOS);
    }
    /**
     * @Description queryExpertDetail 专家校验plus
     * @param
     */
    @RequestMapping(value = "/getRandomNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RandomRuleVO> getRandomNum(@RequestParam Integer inviteType){
        LambdaQueryWrapper<RandomRuleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RandomRuleEntity::getInviteType,inviteType);
        List<RandomRuleEntity> list = randomRuleService.list(wrapper);
        return CommonResponse.success("查询成功！",BeanMapper.map(list.get(0),RandomRuleVO.class));
    }


    /**
     * @Description randomExpertForSupplier 供应商准入随机考察专家
     * @param
     */
    @RequestMapping(value = "/randomExpertForSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExpertVO>> randomExpertForSupplier(@RequestBody RandomSupplierExpertVO randomExpertVO){
         List<ExpertVO> expertVOS = service.randomExpertForSupplier(randomExpertVO);
        return CommonResponse.success("查询成功！",expertVOS);
    }


    /**
     * @Description checkForSupplier 供应商准入随机考察专家 校验
     * @param
     */
    @RequestMapping(value = "/checkForSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<String>> checkForSupplier(@RequestBody RandomSupplierExpertVO randomExpertVO){
         List<String> expertVOS = service.checkForSupplier(randomExpertVO);
        return CommonResponse.success("查询成功！",expertVOS);
    }
    /**
     * @Description queryExpertDetail 校验
     * @param
     */
    @RequestMapping(value = "/checkout", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<String>> checkout(@RequestBody RandomExpertVO randomExpertVO){
        List<String> checkout = service.checkout(randomExpertVO.getExpertVOS(), randomExpertVO.getInviteId());
        return CommonResponse.success("查询成功！",checkout);
    }
    /**
     * @Description 手动查询
     * @param
     * @Return void
     */
    @RequestMapping(value = "/manualSelect", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExpertVO>> manualSelect(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                        String fieldNames,
                                                        String searchObject,
                                                        String searchText) {
        IPage<ExpertVO> expertVOIPage = service.manualSelect(pageNumber, pageSize, fieldNames, searchObject, searchText);
        return CommonResponse.success("查询列表数据成功！",expertVOIPage);
    }
    /**
     * @Description 更新所属项目
     * @param
     */
    @RequestMapping(value = "/updateUnitName", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse updateUnitName(@RequestParam Long id,@RequestParam Long expertId){
        EmployeeVO employeeVO = employeeApi.queryEmployeByUserId(expertId).getData();
        ExpertVO expertVO = queryDetail(id).getData();
        expertVO.setUnitId(employeeVO.getOrgId());
        expertVO.setUnitName(employeeVO.getOrgName());
        expertVO.setDeptId(employeeVO.getDeptId());
        expertVO.setDeptName(employeeVO.getDeptName());
        expertVO.setExpertName(employeeVO.getName());
        expertVO.setEmployeeType(employeeVO.getEmployeeType());
        saveOrUpdate(expertVO);
        return CommonResponse.success("更新所属项目成功!");
    }

    /**
     * @Description 批量改专家库状态
     */
    @RequestMapping(value = "/initEmployeeType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> initEmployeeType(HttpServletRequest request) {
        String param = request.getParameter("param");
        logger.info("获取到的参数JSON是：" + param + "----");

        LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
        expertLambda.in(ExpertEntity::getBillState, 1,3);
        List<ExpertEntity> list = service.list(expertLambda);
        logger.info("获取到的专家信息是：" + JSONObject.toJSONString(list));
        logger.info("获取到的专家参数-是：" + JSONObject.toJSONString(list.stream().map(ExpertEntity::getExpertId).collect(Collectors.toList())));
        List<EmployeeVO> employeeVOList = employeeApi.getJustByIds(list.stream().map(ExpertEntity::getExpertId).collect(Collectors.toList())).getData();
        logger.info("获取到的人员信息是：" + JSONObject.toJSONString(employeeVOList));
        Map<Long,Integer> map = employeeVOList.stream().filter(item -> null != item.getEmployeeType()).collect(Collectors.toMap(EmployeeVO::getId, EmployeeVO::getEmployeeType));
        List<ExpertEntity> upList = new ArrayList<>();
        list.forEach(e->{
            if(map.containsKey(e.getExpertId())&&e.getEmployeeType()!=map.get(e.getExpertId())){
                e.setEmployeeType(map.get(e.getExpertId()));
                upList.add(e);
            }
        });
        if(CollectionUtils.isNotEmpty(upList)){
            logger.info("需要更新的list：" + JSONObject.toJSONString(upList));
            service.updateBatchById(upList);
        }
        return CommonResponse.success("处理成功");
    }

}
