package com.ejianc.business.tender.expert.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.service.*;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingDetailVO;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingVO;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherTalkEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherDocumentSupplierService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.expert.bean.ExpertRepetitionEntity;
import com.ejianc.business.tender.expert.vo.ExpertRepetitionVO;

/**
 * 二次报价表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("expertRepetition")
public class ExpertRepetitionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;


    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "EXPERT_REPETITION_RULE";//此处需要根据实际修改

    @Autowired
    private IExpertRepetitionService service;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> saveOrUpdate(@RequestBody ExpertRepetitionVO saveOrUpdateVO) {
        ExpertRepetitionVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

//    @ApiOperation("发布接口")
//    @RequestMapping(value = "/publishRepetition", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<RentDocumentVO> publishRepetition(@RequestParam Long id) throws Exception {
//        return CommonResponse.success("发布成功！",service.publishRepetition(id));
//    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> queryDetail(Long id) {
    	ExpertRepetitionEntity entity = service.selectById(id);
    	ExpertRepetitionVO vo = BeanMapper.map(entity, ExpertRepetitionVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 点击二次报价接口
     * @param id
     */
    @RequestMapping(value = "/repetitionSell", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> repetitionSell(@RequestBody ExpertRepetitionVO vo) {
        ExpertRepetitionVO expertRepetitionVO = service.repetitionSell(vo);
        return CommonResponse.success("查询详情数据成功！",expertRepetitionVO);
    }
    @ApiOperation("发布接口")
    @RequestMapping(value = "/publish", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> publish(@RequestParam Long id) throws Exception {
        return CommonResponse.success("发布成功！",service.publish(id));
    }
    @ApiOperation("开始评标接口")
    @RequestMapping(value = "/startScore", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> startScore(@RequestParam Long id) throws Exception {
        String s = service.startScore(id);
        return CommonResponse.success("开始评标成功！",s);
    }
    /**
     * @Description queryDetail 发布接口
     * @param id
     */
    @RequestMapping(value = "/publishRepetition", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> publishRepetition(@RequestBody ExpertRepetitionVO vo) {
        ExpertRepetitionVO expertRepetitionVO = service.repetitionSell(vo);
        return CommonResponse.success("查询详情数据成功！",expertRepetitionVO);
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryCollectDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> queryCollectDetail(Long id) {
        ExpertRepetitionVO vo = service.queryCollectDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertRepetitionVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ExpertRepetitionVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ExpertRepetitionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertRepetitionVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("repetiterId", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getEmployeeId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap();
        orderMap.put("createTime","desc");
        param.setOrderMap(orderMap);
        IPage<ExpertRepetitionEntity> page = service.queryPage(param,false);
        IPage<ExpertRepetitionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertRepetitionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExpertRepetitionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExpertRepetition-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
        @RequestMapping(value = "/refExpertSupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherDocumentSupplierVO>> refExpertSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                String condition,
                                                                                String searchObject,
                                                                                String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.getFuzzyFields().add("supplierName");
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Integer inviteType = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 项目id
            Integer talkNum = 0;
            if (_con.containsKey("talkNum")) {
                talkNum = Integer.parseInt(_con.get("talkNum").toString());
                param.getParams().put("talkNum", new Parameter(QueryParam.EQ, talkNum));
            }
            Long documentId = null;
            if (_con.containsKey("documentId")) {
                documentId = Long.parseLong(_con.get("documentId").toString());
                param.getParams().put("documentId", new Parameter(QueryParam.EQ, documentId));
            }
            if (_con.containsKey("inviteType")) {
                inviteType = Integer.parseInt(_con.get("inviteType").toString());
            }
        }
        if(inviteType == CommonUtils.TYPE_OTHER) {
        //其他
            IPage<OtherDocumentSupplierEntity> page = otherDocumentSupplierService.queryPage(param,false);
            IPage<OtherDocumentSupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherDocumentSupplierVO.class));
            return CommonResponse.success("查询参照数据成功！",pageData);
        }

        return null;
     }
        }
