package com.ejianc.business.tender.expert.controller;

import java.io.Serializable;

import com.ejianc.business.tender.expert.vo.TemplateExportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.expert.bean.TemplateEntity;
import com.ejianc.business.tender.expert.service.ITemplateService;
import com.ejianc.business.tender.expert.vo.TemplateVO;

/**
 * 评标模板主表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("template")
public class TemplateController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    private static final String BILL_CODE = "SCORING_TEMPLATE";//此处需要根据实际修改
    private static final String TEMPLATE_CODE = "BT211119000000001";
    @Autowired
    private ITemplateService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemplateVO> saveOrUpdate(@RequestBody TemplateVO saveorUpdateVO) {
        TemplateVO vo = service.saveUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 启停用
     */
    @RequestMapping(value = "/startUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemplateVO> startUpdate(@RequestBody TemplateVO saveorUpdateVO) {
        TemplateEntity entity = BeanMapper.map(saveorUpdateVO, TemplateEntity.class);
        CommonResponse<String> res = billTypeApi.checkQuote(TEMPLATE_CODE, entity.getId());
        logger.info("启用/停用被引用情况"+res.isSuccess()+"-----"+res.getMsg());
        if (!res.isSuccess()){
            switch (entity.getState()){
                case 0: entity.setState(1);break;
                case 1: entity.setState(0);break;
            }
            TemplateVO vo = BeanMapper.map(entity, TemplateVO.class);
            return CommonResponse.success("状态修改失败！",vo);
        }
        service.saveOrUpdate(entity, false);
        TemplateVO vo = BeanMapper.map(entity, TemplateVO.class);
        return CommonResponse.success("修改状态成功！",vo);
    }

    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemplateVO> queryDetail(Long id) {
        TemplateVO vo = service.query(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateVO> vos) {

        service.removeByIds(vos.stream().map(TemplateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("templateName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage<TemplateEntity> page = service.queryPage(param,false);
        IPage<TemplateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemplateVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("templateName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        List<TemplateEntity> list = service.queryList(param);
//导出数据处理
        List<TemplateExportVO> TemplateExportVOS = new ArrayList<>();
        list.forEach(val ->{
            TemplateExportVO TemplateExportVO = BeanMapper.map(val, TemplateExportVO.class);
            switch (val.getState()){
                case 0: TemplateExportVO.setState("停用");break;
                case 1: TemplateExportVO.setState("启用");break;
            };
            switch (val.getBillState()){
                case 0: TemplateExportVO.setBillState("自由态");break;
                case 1: TemplateExportVO.setBillState("已提交");break;
                case 2: TemplateExportVO.setBillState("审批中");break;
                case 3: TemplateExportVO.setBillState("审批通过");break;
                case 4: TemplateExportVO.setBillState("审批驳回");break;
                case 5: TemplateExportVO.setBillState("审批中");break;
            };
            switch (val.getTemplateType()){
                case 6: TemplateExportVO.setTemplateType("其他模板");break;
            };
            TemplateExportVOS.add(TemplateExportVO);
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", TemplateExportVOS);
        ExcelExport.getInstance().export("template.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTemplateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> refTemplateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("templateName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String,Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(conditionMap.get("templateType")!=null){
                Integer templateType = Integer.valueOf(conditionMap.get("templateType").toString());
                param.getParams().put("templateType",new Parameter("eq", templateType));
            }
        }
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("state",new Parameter("eq", 1));
        param.getParams().put("billState", new Parameter(QueryParam.IN,billStates));
        param.getOrderMap().put("createTime", "desc");
        IPage<TemplateEntity> page = service.queryPage(param,false);
        IPage<TemplateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemplateVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
