package com.ejianc.business.tender.expert.service;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.vo.*;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 材料专家评标主表
 * 
 * @author generator
 * 
 */
public interface IExpertEvaluatingService extends IBaseService<ExpertEvaluatingEntity> {

    List<ExpertEvaluatingVO> queryPendingList(Page<ExpertEvaluatingVO> page, String searchText, Integer evaluationState, Integer evaluationState1, String employeeId);

    Boolean updateState(Integer evaluationState, Long id, Long employeeId, DateTime evaluationTime);

    List<ExpertEvaluatingDetailScoreVO>  queryScoreDetail(Long inviteId ,Long evaluationId);

    ExpertEvaluatingVO saveEvaluation( Long documentId);

    void stateCheckout(Long inviteId);

    Map<String,Object> queryExpertDetail(ExpertEvaluatingDetailScoreVO vo);

    List<ExpertEvaluatingVO> queryGatherList(Page<ExpertEvaluatingVO> page, String searchText, Integer gatherStatus, Long employeeId);

    List<ExpertRecordVO> getRecordVO(List<ExpertRecordVO> recordVOList, Integer type);



    ExpertEvaluatingVO otherNext(Long documentId);

    List<TemplateDetailVO> getHead(Long templateId,Integer type);

    List<ExpertEvaluatingDetailScoreVO> getAvgScore(List<ExpertEvaluatingDetailScoreVO> list);

    BigDecimal getScore(List<ExpertRecordVO> list,Integer type);

    void collect(CollectVO collectVO);
/* 评标进度报表*/
    List<ProgressSheetVO> queryProgressSheet(QueryWrapper queryWrapper,Page<ProgressSheetVO> page);
}
