package com.ejianc.business.tender.expert.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tender.expert.vo.ExpertVO;
import com.ejianc.business.tender.expert.vo.RandomSupplierExpertVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.tender.expert.bean.ExpertEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 专家库主表
 * 
 * @author generator
 * 
 */
public interface IExpertService extends IBaseService<ExpertEntity> {
    Boolean dislodge(Long expertId);
    List<ExpertVO> randomSelect(Integer expertNum, String fieldNames);
    IPage<ExpertVO> manualSelect(Integer pageNumber, Integer pageSize,
                                 String fieldNames,
                                 String searchObject,
                                 String searchText);
    ExpertVO saveOrUpdate(ExpertVO saveorUpdateVO);

    Boolean bidEvaluation( Long id);
    List<ExpertVO> randomSelectTwo(Integer expertNum, List<ExpertVO> expertVOS,Long inId);
    List<ExpertVO> randomExpertForSupplier(RandomSupplierExpertVO randomExpertVO);
    List<String> checkForSupplier(RandomSupplierExpertVO randomExpertVO);
    List<String> getExpertIds(Long parentOrgId);
    List<String> checkout(List<ExpertVO> expertVOS,Long inviteId);
    List<String> getDeptExpertIds(Long dept);
//专家抽取规则plus版
    List<ExpertVO> randomSelectPlus(Integer expertNum, List<ExpertVO> expertVOS,Long inviteId,Integer inviteType);
//专家抽取规则校验plus版
    List<String> checkOutPlus(List<ExpertVO> expertVOS,Long inviteId,Integer inviteType);
}
