package com.ejianc.business.tender.expert.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.notice.vo.FileVO;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import com.ejianc.business.supbid.other.api.ISupNoticeApi;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.expert.bean.*;
import com.ejianc.business.tender.expert.service.*;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingVO;
import com.ejianc.business.tender.expert.vo.ExpertRepetitionSupplierVO;
import com.ejianc.business.tender.expert.vo.ExpertRepetitionVO;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherNoticeEntity;
import com.ejianc.business.tender.other.bean.OtherTalkEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierTbVO;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.other.vo.OtherNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.expert.mapper.ExpertRepetitionMapper;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 二次报价表
 * 
 * @author generator
 * 
 */
@Service("expertRepetitionService")
public class ExpertRepetitionServiceImpl extends BaseServiceImpl<ExpertRepetitionMapper, ExpertRepetitionEntity> implements IExpertRepetitionService{
    @Autowired
    private IExpertEvaluatingService expertEvaluatingService;
    @Autowired
    private IExpertEvaluatingDetailService expertEvaluatingDetailService;
    @Autowired
    private IExpertRepetitionService expertRepetitionService;
    @Autowired
    private IExpertRepetitionSupplierService expertRepetitionSupplierService;
//    @Autowired
//    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISupNoticeApi supNoticeApi;

    @Autowired
    private IProcessService processService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private SessionManager sessionManager;
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherTalkService otherTalkService;

    @Autowired
    private IExpertRecordService expertRecordService;
    @Autowired
    private IExpertRecordScoreService expertRecordScoreService;

    @Autowired
    private IOtherInviteService otherInviteService;
    @Value("${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Value("${gysUrl.saveWjUrl}")
    private String saveWjUrl;
//    @Value("${gysUrl.saveOrUpdateUrl}")
//    private String saveOrUpdateUrl;
//    @Value("${gysUrl.updateSupStatusUrl}")
//    private String updateSupStatusUrl;
    @Value("${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private static final String BILL_CODE = "EXPERT_REPETITION_RULE";//此处需要根据实际修改



    @Override
    public ExpertRepetitionVO repetitionSell(ExpertRepetitionVO vo) {

        //新增二次报价主子表信息
        ExpertEvaluatingEntity expertEvaluatingEntity = expertEvaluatingService.selectById(vo.getEvaluatingId());
        List<ExpertRepetitionSupplierVO> expertRepetitionSupplierList = vo.getExpertRepetitionSupplierList();
        ExpertRepetitionEntity expertRepetitionEntity = BeanMapper.map(expertEvaluatingEntity, ExpertRepetitionEntity.class);
        expertRepetitionEntity.setId(IdWorker.getId());
        expertRepetitionEntity.setTalkNum(vo.getTalkNum()+1);
        expertRepetitionEntity.setBidFlag(0);
        expertRepetitionEntity.setPublishFlag(0);
        expertRepetitionEntity.setBillState(0);

        expertRepetitionEntity.setRepetiterId(sessionManager.getUserContext().getEmployeeId());
        expertRepetitionEntity.setRepetiterName(sessionManager.getUserContext().getEmployeeName());
        expertRepetitionEntity.setEvaluatingId(expertEvaluatingEntity.getId());

        List<ExpertRepetitionSupplierEntity> expertRepetitionSupplierEntities = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(expertRepetitionSupplierList)){
            expertRepetitionSupplierEntities = BeanMapper.mapList(expertRepetitionSupplierList, ExpertRepetitionSupplierEntity.class);
            for (ExpertRepetitionSupplierEntity expertRepetitionSupplierEntity : expertRepetitionSupplierEntities){
                expertRepetitionSupplierEntity.setId(IdWorker.getId());
                expertRepetitionSupplierEntity.setSellStatus(1);
//                expertRepetitionSupplierEntity.setLinkMobile(null);
//                expertRepetitionSupplierEntity.setLinkName(null);
                expertRepetitionSupplierEntity.setTalkNum(vo.getTalkNum()+1);

                expertRepetitionSupplierEntity.setRepetitionId(expertRepetitionEntity.getId());
            }
        }
        expertRepetitionSupplierService.saveBatch(expertRepetitionSupplierEntities);
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),vo);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            expertRepetitionEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }

        expertRepetitionService.save(expertRepetitionEntity);
        return queryCollectDetail(expertRepetitionEntity.getId());
    }

    @Override
    public ExpertRepetitionVO queryCollectDetail(Long id) {
        ExpertRepetitionEntity entity = expertRepetitionService.selectById(id);
        ExpertEvaluatingEntity expertEvaluatingEntity = expertEvaluatingService.selectById(entity.getEvaluatingId());
        ExpertEvaluatingVO expertEvaluatingVO = BeanMapper.map(expertEvaluatingEntity, ExpertEvaluatingVO.class);

        ExpertRepetitionVO vo = BeanMapper.map(entity, ExpertRepetitionVO.class);
        vo.setStuffEvaluationDetailEntities(expertEvaluatingVO.getStuffEvaluationDetailEntities());
        Integer num = vo.getTalkNum() -1;
        //TODO 招标修改
        if (entity.getInviteType()==5){
            OtherDocumentVO stuffDocumentVO = otherDocumentService.queryDetail1(vo.getDocumentId(),num);
            vo.setScoreResult(expertEvaluatingService.queryScoreDetail(entity.getInviteId(),entity.getEvaluatingId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getOtherDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getOtherDocumentSupplierSchemeList());
            //赋值招标金额
            OtherInviteEntity otherInviteEntity = otherInviteService.selectById(vo.getInviteId());
            vo.setTenderMoney(otherInviteEntity.getTenderMoney());
        }
        //查询本轮报价的供应商
//        if (vo.getPublishFlag() == 1){
//            num = num + 1;
//            if (entity.getInviteType()==0){
//                StuffDocumentVO stuffDocumentVO = stuffDocumentService.queryDetail1(vo.getDocumentId(),num);
//                List<StuffDocumentSupplierVO> stuffDocumentSupplierSchemeList = stuffDocumentVO.getStuffDocumentSupplierSchemeList();
//                List<ExpertRepetitionSupplierVO> expertRepetitionSupplierVOS = new ArrayList<>();
//                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierSchemeList)){
//                   expertRepetitionSupplierVOS = BeanMapper.mapList(stuffDocumentSupplierSchemeList, ExpertRepetitionSupplierVO.class);
//                }
//                vo.setExpertRepetitionSupplierList(expertRepetitionSupplierVOS);
//
//            }else if(entity.getInviteType()==1){
//                SubDocumentVO stuffDocumentVO = subDocumentService.queryDetail1(vo.getDocumentId(),num);
//                List<SubDocumentSupplierVO> stuffDocumentSupplierSchemeList = stuffDocumentVO.getSubDocumentSupplierSchemeList();
//                List<ExpertRepetitionSupplierVO> expertRepetitionSupplierVOS = new ArrayList<>();
//                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierSchemeList)){
//                    expertRepetitionSupplierVOS = BeanMapper.mapList(stuffDocumentSupplierSchemeList, ExpertRepetitionSupplierVO.class);
//                }
//                vo.setExpertRepetitionSupplierList(expertRepetitionSupplierVOS);
//            }else if (entity.getInviteType()==2){
//                EquipmentDocumentVO stuffDocumentVO = equipmentDocumentService.queryDetail1(vo.getDocumentId(),num);
//                List<EquipmentDocumentSupplierVO> stuffDocumentSupplierSchemeList = stuffDocumentVO.getEquipmentDocumentSupplierSchemeList();
//                List<ExpertRepetitionSupplierVO> expertRepetitionSupplierVOS = new ArrayList<>();
//                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierSchemeList)){
//                    expertRepetitionSupplierVOS = BeanMapper.mapList(stuffDocumentSupplierSchemeList, ExpertRepetitionSupplierVO.class);
//                }
//                vo.setExpertRepetitionSupplierList(expertRepetitionSupplierVOS);
//            }else if (entity.getInviteType()==3){
//                RentDocumentVO stuffDocumentVO = rentDocumentService.queryDetail1(vo.getDocumentId(),num);
//                List<RentDocumentSupplierVO> stuffDocumentSupplierSchemeList = stuffDocumentVO.getRentDocumentSupplierSchemeList();
//                List<ExpertRepetitionSupplierVO> expertRepetitionSupplierVOS = new ArrayList<>();
//                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierSchemeList)){
//                    expertRepetitionSupplierVOS = BeanMapper.mapList(stuffDocumentSupplierSchemeList, ExpertRepetitionSupplierVO.class);
//                }
//                vo.setExpertRepetitionSupplierList(expertRepetitionSupplierVOS);
//            }else if (entity.getInviteType()==4){
//                RmatDocumentVO stuffDocumentVO = rmatDocumentService.queryDetail1(vo.getDocumentId(),num);
//                List<RmatDocumentSupplierVO> stuffDocumentSupplierSchemeList = stuffDocumentVO.getRmatDocumentSupplierSchemeList();
//                List<ExpertRepetitionSupplierVO> expertRepetitionSupplierVOS = new ArrayList<>();
//                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierSchemeList)){
//                    expertRepetitionSupplierVOS = BeanMapper.mapList(stuffDocumentSupplierSchemeList, ExpertRepetitionSupplierVO.class);
//                }
//                vo.setExpertRepetitionSupplierList(expertRepetitionSupplierVOS);
//            }else if (entity.getInviteType()==5){
//                OtherDocumentVO stuffDocumentVO = otherDocumentService.queryDetail1(vo.getDocumentId(),num);
//                List<OtherDocumentSupplierVO> stuffDocumentSupplierSchemeList = stuffDocumentVO.getOtherDocumentSupplierSchemeList();
//                List<ExpertRepetitionSupplierVO> expertRepetitionSupplierVOS = new ArrayList<>();
//                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierSchemeList)){
//                    expertRepetitionSupplierVOS = BeanMapper.mapList(stuffDocumentSupplierSchemeList, ExpertRepetitionSupplierVO.class);
//                }
//                vo.setExpertRepetitionSupplierList(expertRepetitionSupplierVOS);
//            }
//            List<ExpertRepetitionSupplierVO> expertRepetitionSupplierList = vo.getExpertRepetitionSupplierList();
//            for (ExpertRepetitionSupplierVO expertRepetitionSupplierVO : expertRepetitionSupplierList){
//                expertRepetitionSupplierVO.setSellStatus(2);
//            }
//        }

        return vo;
    }

    @Transactional
    @Override
    public ExpertRepetitionVO publish(Long id) {
        //更新发布状态
        ExpertRepetitionEntity expertRepetitionEntity = super.selectById(id);
        expertRepetitionEntity.setPublishFlag(1);
        super.updateById(expertRepetitionEntity);

        //推送供应商
        OtherDocumentSupplierTbVO otherDocumentSupplierTbVO = new OtherDocumentSupplierTbVO();
        otherDocumentSupplierTbVO.setSourceId(expertRepetitionEntity.getInviteId().toString());
        otherDocumentSupplierTbVO.setNoticeType(1);
        otherDocumentSupplierTbVO.setTalkNum(expertRepetitionEntity.getTalkNum());
        otherDocumentSupplierTbVO.setMemo(expertRepetitionEntity.getRepetitionReason());

        //处理供应商
        List<ExpertRepetitionSupplierEntity> expertRepetitionSupplierList = expertRepetitionEntity.getExpertRepetitionSupplierList();
        List<OtherNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
        for (ExpertRepetitionSupplierEntity supplierDetailEntity : expertRepetitionSupplierList) {
            OtherNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new OtherNoticeSupplierDetailTbVO();
            stuffNoticeSupplierDetailTbVO.setSourceId(expertRepetitionEntity.getInviteId().toString());
            stuffNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            supplierDetailTbVOList.add(stuffNoticeSupplierDetailTbVO);
        }
        otherDocumentSupplierTbVO.setApplyList(supplierDetailTbVOList);
        String stringFb = JSONObject.toJSONString(otherDocumentSupplierTbVO);
        logger.info("二次报价信息"+stringFb);
        Map<String,String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;


//        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl,params,files, appId, appSecret, appHost);
//        if(!stringCommonResponses.isSuccess()) {
//            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
//        }
        //推送供方
        NoticeVO noticeVO = BeanMapper.map(otherDocumentSupplierTbVO, NoticeVO.class);
        CommonResponse<Boolean> booleanCommonResponse = supNoticeApi.saveWj(noticeVO);
        if (!booleanCommonResponse.isSuccess()){
            throw new BusinessException("招标文件发布推送供方接口报错" + booleanCommonResponse.getMsg());
        }

        //招标文件发布成功后 改招标状态 为报价中
        // 处理租赁方式
        ExpertEvaluatingEntity expertEvaluatingEntity = expertEvaluatingService.selectById(expertRepetitionEntity.getEvaluatingId());
        Integer inviteType = expertEvaluatingEntity.getInviteType();
        Long inviteId = expertRepetitionEntity.getInviteId();
        String billCode = null;
        switch (inviteType) {
            case CommonUtils.TYPE_OTHER:
            {//其他
                OtherInviteEntity inviteEntity = otherInviteService.selectById(inviteId);
                inviteEntity.setTenderState(TenderStateEnum.报价中.getCode());
                billCode = inviteEntity.getBillCode();
                otherInviteService.saveOrUpdate(inviteEntity);
            }
            break;
            default:
                throw new BusinessException("招标立项类型不存在[" + inviteType + "]");
        }

        //发布之后跟经办人发布消息
        List<String> messageType = new ArrayList<>();
        //系统消息
        messageType.add("sys");
        //微信消息
        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(expertRepetitionEntity.getEmployeeId() + "");
        logger.info("发送信息给专家:>----------" + sender);
        String subject = expertRepetitionEntity.getEmployeeName() + "您好，单据编码为" +billCode+ "的招标由于【"+expertRepetitionEntity.getRepetitionReason()+"】，评标组长发起了二次报价，请知晓！";
        String content = expertRepetitionEntity.getEmployeeName() + "您好，单据编码为" +billCode+ "的招标由于【"+expertRepetitionEntity.getRepetitionReason()+"】，评标组长发起了二次报价，请知晓！";
        logger.info("发送信息的内容:>----------" + content);
        new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);


        return null;
    }

    @Transactional
    @Override
    public String startScore(Long id) {
        //更新开始评标状态
        ExpertRepetitionEntity expertRepetitionEntity = super.selectById(id);
        expertRepetitionEntity.setBidFlag(1);
        super.updateById(expertRepetitionEntity);
        Integer num = expertRepetitionEntity.getTalkNum();

        //判断是否能评标
        List<ExpertRepetitionSupplierVO> expertRepetitionSupplierVOS = new ArrayList<>();
        if (expertRepetitionEntity.getInviteType()==5){
            OtherDocumentVO stuffDocumentVO = otherDocumentService.queryDetail1(expertRepetitionEntity.getDocumentId(),num);
            List<OtherDocumentSupplierVO> stuffDocumentSupplierSchemeList = stuffDocumentVO.getOtherDocumentSupplierSchemeList();
            if (CollectionUtils.isNotEmpty(stuffDocumentSupplierSchemeList)){
                expertRepetitionSupplierVOS = BeanMapper.mapList(stuffDocumentSupplierSchemeList, ExpertRepetitionSupplierVO.class);
            }
        }
        List<ExpertRepetitionSupplierEntity> expertRepetitionSupplierList = expertRepetitionEntity.getExpertRepetitionSupplierList();
        if (expertRepetitionSupplierVOS.size() < expertRepetitionSupplierList.size()){
            throw new BusinessException("供应商未全部完成报价,不能开始评标!");
        }

        //更新评标数据
        ExpertEvaluatingEntity expertEvaluatingEntity = expertEvaluatingService.selectById(expertRepetitionEntity.getEvaluatingId());
        expertEvaluatingEntity.setFlagNew(0);
        expertEvaluatingService.updateById(expertEvaluatingEntity);

        //重新生成新数据
        expertEvaluatingEntity.setId(IdWorker.getId());
        expertEvaluatingEntity.setFlagNew(1);
        expertEvaluatingEntity.setCreateTime(null);
        expertEvaluatingEntity.setChangeVersion(expertEvaluatingEntity.getChangeVersion()+1);
        List<ExpertEvaluatingDetailEntity> stuffEvaluationDetailEntities = expertEvaluatingEntity.getStuffEvaluationDetailEntities();

        for (ExpertEvaluatingDetailEntity expertEvaluatingDetailEntity : stuffEvaluationDetailEntities){
            expertEvaluatingDetailEntity.setId(IdWorker.getId());
            expertEvaluatingDetailEntity.setEvaluationId(expertEvaluatingEntity.getId());
            expertEvaluatingDetailEntity.setEvaluationState(0);
            expertEvaluatingDetailEntity.setEvaluationTime(null);
            if(expertEvaluatingDetailEntity.getLeader() == 1){
            //审批通过给专家发内部消息
            List<String> messageType = new ArrayList<>();
            //系统消息
            messageType.add("sys");
            //微信消息
            messageType.add("weChat");
            List<String> sender = new ArrayList<>();
            sender.add(expertEvaluatingDetailEntity.getExpertId() + "");
            String name = expertEvaluatingEntity.getPurchaseType()==0?expertEvaluatingEntity.getProjectName():expertEvaluatingEntity.getOrgName();
            logger.info("发送信息给专家:>----------" + sender);
            String subject = expertEvaluatingDetailEntity.getExpertName() + "专家您好，" +name+ "进入二次报价的评标阶段，请在24小时完成评标任务";
                String frontendBaseHost="";
                if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                    frontendBaseHost = BASE_HOST_FRONTEND;
                }else{
                    frontendBaseHost = BASE_HOST;
                }
            String formUrl = frontendBaseHost+"ejc-tender-frontend/#/bidRecordList";
            String content = expertEvaluatingDetailEntity.getExpertName() + "专家您好，" +name+ "进入二次报价的评标阶段，请在24小时完成评标任务,"+"<a href=" + '"' + formUrl + '"' + ">请尽快评标</a>";
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);
            }
        }

        LambdaQueryWrapper<ProcessEntity> lambdaExpertProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaExpertProcess.eq(ProcessEntity::getTenderId, expertRepetitionEntity.getInviteId());
        lambdaExpertProcess.eq(ProcessEntity::getFrontendUrl, "stuff/evaluationCard");
        ProcessEntity processServiceOne = processService.getOne(lambdaExpertProcess);
        processServiceOne.setBillId(expertEvaluatingEntity.getId());
        processService.updateById(processServiceOne);

        expertEvaluatingService.saveOrUpdate(expertEvaluatingEntity, false);
        logger.info("新数据"+expertEvaluatingEntity.getId()+"flagNew" + expertEvaluatingEntity.getFlagNew());
//        expertEvaluatingDetailService.saveBatch(stuffEvaluationDetailEntities);
        return "";
    }

    @Override
    public ExpertRepetitionVO saveOrUpdate(ExpertRepetitionVO saveOrUpdateVO) {
        ExpertRepetitionEntity entity = BeanMapper.map(saveOrUpdateVO, ExpertRepetitionEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        LambdaQueryWrapper<ExpertRepetitionEntity> lambdaRepetition = Wrappers.<ExpertRepetitionEntity>lambdaQuery();
        lambdaRepetition.eq(ExpertRepetitionEntity::getEvaluatingId, saveOrUpdateVO.getEvaluatingId());
        lambdaRepetition.eq(ExpertRepetitionEntity::getBidFlag, 0);
        if(null!=entity.getId()){
            lambdaRepetition.ne(ExpertRepetitionEntity::getId,entity.getId());
        }
        ExpertRepetitionEntity expertRepetitionEntity = expertRepetitionService.getOne(lambdaRepetition);
        if(null!=expertRepetitionEntity){
            throw new BusinessException("存在未开标的二次报价数据，不允许保存");
        }
        expertRepetitionService.saveOrUpdate(entity, false);
        return queryCollectDetail(entity.getId());

    }

}
