package com.ejianc.business.tender.other.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 材料招标立项采购清单表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_other_invite_detail")
public class OtherInviteDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 招标主键ID
    @TableField(value="material_id")
    private Long materialId; // 材料ID
    @TableField(value="material_name")
    private String materialName; // 材料名称
    @TableField(value="material_code")
    private String materialCode; // 材料编码
    @TableField(value="material_type_id")
    private Long materialTypeId; // 材料分类ID
    @TableField(value="material_type_name")
    private String materialTypeName; // 材料分类名称
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="detail_project_id")
    private Long detailProjectId; // 项目ID
    @TableField(value="detail_project_name")
    private String detailProjectName; // 项目名称
    @TableField(value="detail_org_id")
    private Long detailOrgId; // 组织ID
    @TableField(value="detail_org_name")
    private String detailOrgName; // 组织名称
    @TableField(value="plan_id")
    private Long planId; // 计划ID
    @TableField(value="plan_name")
    private String planName; // 计划名称
    @TableField(value="plan_code")
    private String planCode; // 计划编码
    @TableField(value="plan_money")
    private BigDecimal planMoney; // 计划金额
    @TableField(value="brand")
    private String brand; // 品牌
    @TableField(value="calculate_type")
    private Integer calculateType; // 计量方式(0-理计,1-过磅,2-点数)
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="rate")
    private BigDecimal rate; // 税率
    @TableField(value="money")
    private BigDecimal money; // 暂估金额
    @TableField(value="money_tax")
    private BigDecimal moneyTax; // 暂估金额(含税)
    @TableField(value="plan_num")
    private BigDecimal planNum; // 计划数量
    @TableField(value="contract_type")
    private String contractType;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    @TableField(value="purchase_id")
    private String purchaseId; // 采购方式ID
    @TableField(value="purchase_name")
    private String purchaseName; // 采购方式ID
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="plan_enter_date")
    private Date planEnterDate; // 计划进场时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="plan_leave_date")
    private Date planLeaveDate; // 计划出场时间
    @TableField(value="plan_day")
    private BigDecimal planDay; // 计划周期
    @TableField(value="address")
    private String address; //收货地址
    @TableField(value="price")
    private BigDecimal price; //招标控制单价（无税）
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 招标控制单价
    @TableField(value="tax")
    private BigDecimal tax; // 税额

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    /**
     * 招标主键ID
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标主键ID
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 材料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 材料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getDetailProjectId() {
        return detailProjectId;
    }

    public void setDetailProjectId(Long detailProjectId) {
        this.detailProjectId = detailProjectId;
    }

    public String getDetailProjectName() {
        return detailProjectName;
    }

    public void setDetailProjectName(String detailProjectName) {
        this.detailProjectName = detailProjectName;
    }

    /**
     * 计划ID
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 计划ID
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    /**
     * 计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划金额
     */
    public BigDecimal getPlanMoney() {
        return planMoney;
    }

    /**
     * 计划金额
     */
    public void setPlanMoney(BigDecimal planMoney) {
        this.planMoney = planMoney;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 暂估金额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 暂估金额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 暂估金额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 暂估金额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }

    public Long getDetailOrgId() {
        return detailOrgId;
    }

    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }

    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }
}
