package com.ejianc.business.tender.other.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_other_talk")
public class OtherTalkEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 招标立项主键
    @TableField(value="bill_id")
    private Long billId; // 来源单据主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="talk_name")
    private String talkName; // 洽商名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="talk_start_time")
    private java.util.Date talkStartTime; // 洽商开始时间
    @TableField(value="talk_end_time")
    private java.util.Date talkEndTime; // 洽商结束时间
    @TableField(value="brand_flag")
    private Integer brandFlag; // 是否允许多品牌报价,0-是,1-否
    @TableField(value="talk_num")
    private Integer talkNum; // 洽商轮数
    @TableField(value="talk_money")
    private java.math.BigDecimal talkMoney; // 洽商参考价
    @TableField(value="publish_flag")
    private Integer publishFlag; // 是否发布,0-是,1-否
    @TableField(value="next_flag")
    private Integer nextFlag; // 是否下一步,0-是,1-否
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="talk_num_name")
    private String talkNumName; // 洽商轮数名称
    @TableField(value="purchase_type")
    private Integer purchaseType;//采购方式(0-项目采购,1-单位采购)

    
    @TableField(exist=false)
    @SubEntity(serviceName="otherTalkDetailService",pidName= "talkId")
    private List<OtherTalkDetailEntity> otherTalkDetailList = new ArrayList<>(); // 洽商谈判子表

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getTalkNumName() {
        return talkNumName;
    }

    public void setTalkNumName(String talkNumName) {
        this.talkNumName = talkNumName;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 来源单据主键
     */
    public Long getBillId() {
        return billId;
    }

    /**
     * 来源单据主键
     */
    public void setBillId(Long billId) {
        this.billId = billId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 洽商名称
     */
    public String getTalkName() {
        return talkName;
    }

    /**
     * 洽商名称
     */
    public void setTalkName(String talkName) {
        this.talkName = talkName;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 洽商开始时间
     */
    public java.util.Date getTalkStartTime() {
        return talkStartTime;
    }

    /**
     * 洽商开始时间
     */
    public void setTalkStartTime(java.util.Date talkStartTime) {
        this.talkStartTime = talkStartTime;
    }
    /**
     * 洽商结束时间
     */
    public java.util.Date getTalkEndTime() {
        return talkEndTime;
    }

    /**
     * 洽商结束时间
     */
    public void setTalkEndTime(java.util.Date talkEndTime) {
        this.talkEndTime = talkEndTime;
    }
    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public Integer getBrandFlag() {
        return brandFlag;
    }

    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public void setBrandFlag(Integer brandFlag) {
        this.brandFlag = brandFlag;
    }
    /**
     * 洽商轮数
     */
    public Integer getTalkNum() {
        return talkNum;
    }

    /**
     * 洽商轮数
     */
    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    /**
     * 洽商参考价
     */
    public java.math.BigDecimal getTalkMoney() {
        return talkMoney;
    }

    /**
     * 洽商参考价
     */
    public void setTalkMoney(java.math.BigDecimal talkMoney) {
        this.talkMoney = talkMoney;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 是否下一步,0-是,1-否
     */
    public Integer getNextFlag() {
        return nextFlag;
    }

    /**
     * 是否下一步,0-是,1-否
     */
    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<OtherTalkDetailEntity> getOtherTalkDetailList() {
        return otherTalkDetailList;
    }

    public void setOtherTalkDetailList(List<OtherTalkDetailEntity> otherTalkDetailList) {
        this.otherTalkDetailList = otherTalkDetailList;
    }
}
