package com.ejianc.business.tender.other.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.supbid.notice.vo.BjNoticeVO;
import com.ejianc.business.supbid.notice.vo.BmNoticeVO;
import com.ejianc.business.supbid.notice.vo.CheckVo;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.expert.bean.ExpertRepetitionEntity;
import com.ejianc.business.tender.expert.service.IExpertRepetitionService;
import com.ejianc.business.tender.other.bean.OtherNoticeEntity;
import com.ejianc.business.tender.other.bean.OtherNoticeSupplierEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherNoticeService;
import com.ejianc.business.tender.other.service.IOtherNoticeSupplierService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.vo.OtherNoticeSupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/23 10:30
 */
@RestController
@RequestMapping("/api/otherPicketageRefsupplier/")
public class OtherTenderApi {

    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Autowired
    private IOtherPicketageRefsupplierService otherPicketageRefsupplierService;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOtherNoticeService otherNoticeService;

    @Autowired
    private IOtherNoticeSupplierService noticeSupplierService;

    @Autowired
    private IOtherDocumentService otherDocumentService;

    @Autowired
    private IExpertRepetitionService expertRepetitionService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "updateById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateById(@RequestParam Long id,@RequestParam Integer occupyFlag) {
        String s = otherPicketageRefsupplierService.updateById(id,occupyFlag);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("更新签订状态")
    @RequestMapping(value = "updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody TenderPicketageVO tenderPicketageVO) {
        String s = otherPicketageRefsupplierService.updateStatus(tenderPicketageVO,0);
        return CommonResponse.success(s);
    }
    @ApiOperation("删除操作-更新签订状态")
    @RequestMapping(value = "delUpdateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delUpdateStatus(@RequestBody TenderPicketageVO tenderPicketageVO) {
        String s = otherPicketageRefsupplierService.updateStatus(tenderPicketageVO,1);
        return CommonResponse.success(s);
    }

    @ApiOperation("报名情况")
    @RequestMapping(value = "/signUp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> signUp(@RequestBody BmNoticeVO bmNoticeVO) {
        logger.info("进入报名接口");
        logger.info("报名实体信息-{}",JSONObject.toJSONString(bmNoticeVO));
        OtherNoticeSupplierVO otherNoticeSupplierVO = BeanMapper.map(bmNoticeVO, OtherNoticeSupplierVO.class);

        OtherNoticeSupplierEntity otherNoticeSupplierEntity = BeanMapper.map(otherNoticeSupplierVO, OtherNoticeSupplierEntity.class);
        otherNoticeSupplierEntity.setNoticeId(otherNoticeService.selectNotice(otherNoticeSupplierVO.getSourceId()));
        otherNoticeSupplierEntity.setSourceSupplierTenantId(otherNoticeSupplierVO.getTenantId().toString());
        otherNoticeSupplierEntity.setSupplierId(Long.valueOf(otherNoticeSupplierVO.getSourceSupplierId()));
        SupplierVO supplierVO = supplierApi.queryById(Long.valueOf(otherNoticeSupplierVO.getSourceSupplierId())).getData();
        otherNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        otherNoticeSupplierEntity.setSupplierEmployeeId(otherNoticeSupplierVO.getEmployeeId());
        otherNoticeSupplierEntity.setSupplierEmployeeName(otherNoticeSupplierVO.getEmployeeName());
        otherNoticeSupplierEntity.setSupplierEmployeeMobile(otherNoticeSupplierVO.getEmployeeMobile());
        otherNoticeSupplierEntity.setId(null);
        otherNoticeSupplierEntity.setState(0);
        //查询是否已经报名
        LambdaQueryWrapper<OtherNoticeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OtherNoticeEntity::getInviteId, otherNoticeSupplierVO.getSourceId());
        List<OtherNoticeEntity> noticeEntityList = otherNoticeService.list(queryWrapper);
        LambdaQueryWrapper<OtherNoticeSupplierEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OtherNoticeSupplierEntity::getSourceSupplierId, otherNoticeSupplierVO.getSourceSupplierId())
                .eq(OtherNoticeSupplierEntity::getNoticeId, noticeEntityList.get(0).getId())
                .eq(OtherNoticeSupplierEntity::getDr, 0);
        List<OtherNoticeSupplierEntity> supplierEntityList = noticeSupplierService.list(lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty(supplierEntityList)) {
            noticeSupplierService.removeById(supplierEntityList.get(0).getId());
        }
        boolean b = noticeSupplierService.saveOrUpdate(otherNoticeSupplierEntity);
        //处理附件
        List<SupplyFileVo> pzList = otherNoticeSupplierVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            pzList.forEach(e->{
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(otherNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            });
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info("报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
        return CommonResponse.success("报名情况接口掉用成功",b);
    }

    @ApiOperation("供方推送报价信息接口")
    @RequestMapping(value = "/supplierPushSell", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> supplierPushSell(@RequestBody BjNoticeVO bjNoticeVO){
        Boolean b = otherDocumentService.supplierPushSell(bjNoticeVO);
        return CommonResponse.success("推送报价信息成功！",b);
    }

    /**
     * 查询二次报价是否开开始评标
     */
    @RequestMapping(value = "/checkBidFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> checkBidFlag(@RequestBody CheckVo checkVo) {
        Long inviteId = Long.valueOf(checkVo.getInviteId());
        List<ExpertRepetitionEntity> repetitionEntityList = expertRepetitionService.list(new QueryWrapper<ExpertRepetitionEntity>().eq("invite_id", inviteId).eq("publish_flag", 1).orderByDesc("talk_num"));
        if (CollectionUtils.isNotEmpty(repetitionEntityList)){
            return CommonResponse.success("开始评标状态:",repetitionEntityList.get(0).getBidFlag().toString());
        }
        return CommonResponse.success("开始评标状态:","0");
    }
}
