package com.ejianc.business.tender.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.mapper.OtherInviteMapper;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailBidderVO;
import com.ejianc.business.tender.other.vo.OtherInviteDetailVO;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Service("otherInviteService")
public class OtherInviteServiceImpl extends BaseServiceImpl<OtherInviteMapper, OtherInviteEntity> implements IOtherInviteService {
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IProcessService processService;
//    @Autowired
////    private ISubInviteService subInviteService;

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id,tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id,abolishType);
    }

    @Override
    public List<OtherInviteDetailVO> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<OtherInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);
        OtherInviteVO vo = BeanMapper.map(otherInviteEntity, OtherInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    @Override
    public Map<String, Object> getSuffAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);
        OtherInviteVO vo = BeanMapper.map(otherInviteEntity, OtherInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

//    @Override
//    public Map<String, Object> getSubAbolishType(Long tenderId) {
//        Map<String, Object> map = new HashMap<>();
//        SubInviteEntity subInviteEntity = subInviteService.selectById(tenderId);
//        SubInviteVO vo = BeanMapper.map(subInviteEntity, SubInviteVO.class);
//        if(vo.getAbolishType()==null){
//            vo.setAbolishType(0);
//        }
//        map.put("abolishType", vo.getAbolishType());
//        map.put("employeeId",vo.getEmployeeId());
//        return map;
//    }

    @Override
    public List<OtherInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }
}
