package com.ejianc.business.tender.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.other.bean.OtherPicketageSupplierEntity;
import com.ejianc.business.tender.other.mapper.OtherPicketageSupplierMapper;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.service.IOtherPicketageSupplierService;
import com.ejianc.business.tender.other.service.IOtherWinnoticeService;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.other.vo.OtherPicketageSupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 定标供应商表
 * 
 * @author generator
 * 
 */
@Service("otherPicketageSupplierService")
public class OtherPicketageSupplierServiceImpl extends BaseServiceImpl<OtherPicketageSupplierMapper, OtherPicketageSupplierEntity> implements IOtherPicketageSupplierService {
    @Autowired
    private IOtherPicketageSupplierService otherPicketageSupplierService;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherWinnoticeService otherWinnoticeService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IProcessService processService;
    @Override
    public List<OtherPicketageSupplierVO> queryDetail(Long id) {
        LambdaQueryWrapper<OtherPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(OtherPicketageSupplierEntity::getPicketageId,id);
        List<OtherPicketageSupplierEntity> listSupplier = otherPicketageSupplierService.list(lambdaSupplierList);
        List<OtherPicketageSupplierVO> otherPicketageSupplierVOS = BeanMapper.mapList(listSupplier, OtherPicketageSupplierVO.class);

        return otherPicketageSupplierVOS;
    }
}
