package com.ejianc.business.tender.other.service.impl;

import com.ejianc.business.tender.other.bean.OtherTalkRecordEntity;
import com.ejianc.business.tender.other.mapper.OtherTalkRecordMapper;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherTalkRecordService;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.other.vo.OtherTalkRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 洽商谈判记录主表
 * 
 * @author generator
 * 
 */
@Service("otherTalkRecordService")
public class OtherTalkRecordServiceImpl extends BaseServiceImpl<OtherTalkRecordMapper, OtherTalkRecordEntity> implements IOtherTalkRecordService {
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Override
    public OtherTalkRecordVO queryDetail(Long id) {
        OtherTalkRecordEntity otherTalkRecordEntity = super.selectById(id);
        OtherTalkRecordVO otherTalkRecordVO = BeanMapper.map(otherTalkRecordEntity, OtherTalkRecordVO.class);

        //确认轮数
        Integer talkNum = otherTalkRecordVO.getTalkNum();
        OtherDocumentVO otherDocumentVO = otherDocumentService.queryDocDetail(otherTalkRecordVO.getBillId(), talkNum);
        otherTalkRecordVO.setOtherDocumentDetailSellList(otherDocumentVO.getOtherDocumentDetailSellList());
        otherTalkRecordVO.setOtherDocumentSupplierSchemeList(otherDocumentVO.getOtherDocumentSupplierSchemeList());

        return otherTalkRecordVO;
    }
}
