package com.ejianc.business.tender.report.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.report.mapper.ReportMapper;
import com.ejianc.business.tender.report.service.IReportService;
import com.ejianc.business.tender.report.vo.BidDataVO;
import com.ejianc.business.tender.report.vo.ReportVO;
import com.ejianc.business.tender.report.vo.SupplierReportVO;
import com.ejianc.business.tender.util.MathUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 材料立项主表
 *
 * @author generator
 */
@Service("reportService")
public class ReportServiceImpl implements IReportService {
    @Autowired
    private ReportMapper reportMapper;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherPicketageRefsupplierService otherPicketageRefsupplierService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Map<String,Object> queryData(QueryParam param) {
        IPage<ReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<ReportVO> list = reportMapper.refPurchaseAcceptanceData(changeToQueryWrapper(param), page);
        List<ReportVO> list1 = reportMapper.refPurchaseAcceptanceAllData(changeToQueryWrapper(param));
        BigDecimal sumTaxMoney = BigDecimal.ZERO;
        //将list里的金额合并
        if (CollectionUtils.isNotEmpty(list1)) {
            logger.info("招标统计数据:{}", JSONObject.toJSONString(list1));
            for (ReportVO reportVO : list1) {
//                if (reportVO.getEstablishType()==1){
//                    if (reportVO.getLineTypeName().equals("分包招标")){
//                        reportVO.setTaxMoney(reportVO.getTenderMoney());
//                    }else {
//                        reportVO.setTaxMoney(reportVO.getTaxMoney());
//                    }
//                }
                sumTaxMoney = MathUtil.safeAdd(sumTaxMoney, reportVO.getTaxMoney());
            }
        }
        IPage<ReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        Map<String,Object> map = new HashMap<>();
        map.put("page", pageData);
        map.put("sumTaxMoney", sumTaxMoney);
        return map;
    }

    @Override
    public IPage<SupplierReportVO> querySupplierReportData(QueryParam param, Long supplierId) {
        IPage<SupplierReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<SupplierReportVO> list = reportMapper.querySupplierReportData(changeToQueryWrapper(param), page, supplierId);
        IPage<SupplierReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    @Override
    public BigDecimal queryMoney(Integer tenderType, String tenderTypeName, String firstDayOfMonth, String lastDayOfMonth) {

        //其他
        BigDecimal otherMoney = BigDecimal.ZERO;
        LambdaQueryWrapper<OtherInviteEntity> publicOtherInviteWrapper = new LambdaQueryWrapper<>();
        publicOtherInviteWrapper.eq(OtherInviteEntity::getEstablishType, 1)
                .in(OtherInviteEntity::getBillState, 1, 3)
                .eq(OtherInviteEntity::getDr, 0)
                .in(OtherInviteEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(OtherInviteEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .eq(OtherInviteEntity::getTenderType, tenderType);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicOtherInviteWrapper.between(OtherInviteEntity::getCreateDate, firstDayOfMonth, lastDayOfMonth);
        }

        LambdaQueryWrapper<OtherPicketageEntity> publicOtherPicketageWrapper = new LambdaQueryWrapper<>();
        publicOtherPicketageWrapper.eq(OtherPicketageEntity::getTenderTypeName, tenderTypeName)
                .eq(OtherPicketageEntity::getDr, 0)
                .in(OtherPicketageEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(OtherPicketageEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .in(OtherPicketageEntity::getBillState, 1, 3);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicOtherPicketageWrapper.between(OtherPicketageEntity::getPicketageTime, firstDayOfMonth, lastDayOfMonth);
        }

        List<Long> publicOtherInviteIdList = otherInviteService.list(publicOtherInviteWrapper).stream().map(OtherInviteEntity::getId).collect(Collectors.toList());
        List<Long> publicOtherPicketageIdList = otherPicketageService.list(publicOtherPicketageWrapper).stream().map(OtherPicketageEntity::getId).collect(Collectors.toList());
        publicOtherInviteIdList.addAll(publicOtherPicketageIdList);

        if (CollectionUtils.isNotEmpty(publicOtherInviteIdList)) {
            LambdaQueryWrapper<OtherPicketageRefsupplierEntity> publicOtherPicketageRefSupplierWrapper = new LambdaQueryWrapper<>();
            publicOtherPicketageRefSupplierWrapper.in(OtherPicketageRefsupplierEntity::getPicketageId, publicOtherInviteIdList);
            otherMoney = otherPicketageRefsupplierService.list(publicOtherPicketageRefSupplierWrapper).stream().filter(e -> e.getMoneyTax() != null).map(OtherPicketageRefsupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("其他数据条数:{}", publicOtherInviteIdList.size());
        }
        logger.info("合计总金额:{}", otherMoney);
        return otherMoney;
    }

    /**
     * 获取当前月第一天
     *
     * @param
     * @return
     */
    public static Date getFirstDayOfMonth(boolean flag) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        String format = sdf1.format(new Date());
        int month = Integer.parseInt(format);
        if (flag) {
            calendar.add(Calendar.YEAR, -1); //把日期往后增加一天,整数  往后推,负数往前移动
        }
        // 设置月份
        calendar.set(Calendar.MONTH, month - 1);
        // 获取某月最小天数
        int firstDay = calendar.getActualMinimum(Calendar.DAY_OF_MONTH);
        // 设置日历中月份的最小天数
        calendar.set(Calendar.DAY_OF_MONTH, firstDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayDate = sdf.format(calendar.getTime()) + " 00:00:00";
        return sdf.parse(firstDayDate);
    }


    /**
     * 获取当前月最后一天
     *
     * @param
     * @return
     */
    public static Date getLastDayOfMonth(boolean flag) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        String format = sdf1.format(new Date());
        int month = Integer.parseInt(format);
        if (flag) {
            calendar.add(Calendar.YEAR, -1); //把日期往后增加一天,整数 往后推,负数往前移动
        }
        // 设置月份
        calendar.set(Calendar.MONTH, month - 1);
        // 获取某月最大天数
        int lastDay = 0;
        //2月的平年瑞年天数
        if (month == 2) {
            // 这个api在计算2020年2月的过程中有问题
            lastDay = calendar.getLeastMaximum(Calendar.DAY_OF_MONTH);
        }
        else {
            lastDay = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        }
        // 设置日历中月份的最大天数
        calendar.set(Calendar.DAY_OF_MONTH, lastDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayDate = sdf.format(calendar.getTime()) + " 23:59:59";
        return sdf.parse(lastDayDate);
    }

    @Override
    public Map queryBidData(QueryParam param) throws ParseException {
        BidDataVO bidDataVO = new BidDataVO();
        Map<String, Object> bidDataVOMap = new HashMap<>();
        List<ReportVO> list = reportMapper.refPurchaseAcceptanceAllData(changeToQueryWrapper(param));
        //平台公开招标金额
        BigDecimal publicTenderMoney = calculateMoney(list, "0",null,null);
        bidDataVO.setPublicTenderMoney(publicTenderMoney);
        bidDataVOMap.put("publicTenderMoney",publicTenderMoney);
        //邀请招标金额
        BigDecimal inviteTenderMoney = calculateMoney(list, "1",null,null);
        bidDataVO.setInviteTenderMoney(inviteTenderMoney);
        bidDataVOMap.put("inviteTenderMoney",inviteTenderMoney);
        //询价招标金额
        BigDecimal inquiryTenderMoney = calculateMoney(list, "2",null,null);
        bidDataVO.setInquiryTenderMoney(inquiryTenderMoney);
        bidDataVOMap.put("inquiryTenderMoney",inquiryTenderMoney);
        //紧急招标金额
        BigDecimal urgentTenderMoney = calculateMoney(list, "5",null,null);
        bidDataVO.setUrgentTenderMoney(urgentTenderMoney);
        bidDataVOMap.put("urgentTenderMoney",urgentTenderMoney);
        //其他招标金额
        bidDataVOMap.put("otherTenderMoney",(calculateMoney(list, "3",null,null)).add(calculateMoney(list, "4",null,null)));

        //本期
        BidDataVO nowMonth = new BidDataVO();
        Date firstDayOfMonth = getFirstDayOfMonth(false);
        Date lastDayOfMonth = getLastDayOfMonth(false);
        logger.info("本期日期开始时间-{}",firstDayOfMonth);
        logger.info("本期日期结束时间-{}",lastDayOfMonth);
        nowMonth.setPublicTenderMoney(calculateMoney(list, "0", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setInviteTenderMoney(calculateMoney(list, "1", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setInquiryTenderMoney(calculateMoney(list, "2", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setUrgentTenderMoney(calculateMoney(list, "5", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setOtherTenderMoney(calculateMoney(list, "3", firstDayOfMonth, lastDayOfMonth).add(calculateMoney(list, "4", firstDayOfMonth, lastDayOfMonth)));


        //同期
        BidDataVO oldMonth = new BidDataVO();
        Date oldFirstDayOfMonth = getFirstDayOfMonth(true);
        Date oldLastDayOfMonth = getLastDayOfMonth(true);
        logger.info("同期日期开始时间-{}",oldFirstDayOfMonth);
        logger.info("同期日期结束时间-{}",oldLastDayOfMonth);
        oldMonth.setPublicTenderMoney(calculateMoney(list, "0", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setInviteTenderMoney(calculateMoney(list, "1", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setInquiryTenderMoney(calculateMoney(list, "2", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setUrgentTenderMoney(calculateMoney(list, "5", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setOtherTenderMoney(calculateMoney(list, "3", oldFirstDayOfMonth, oldLastDayOfMonth).add(calculateMoney(list, "4", oldFirstDayOfMonth, oldLastDayOfMonth)));

        //增减率
        BidDataVO rate = new BidDataVO();
        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setPublicTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setPublicTenderRate(nowMonth.getPublicTenderMoney().subtract(oldMonth.getPublicTenderMoney()).divide(oldMonth.getPublicTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }

        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setInviteTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setInviteTenderRate(nowMonth.getInviteTenderMoney().subtract(oldMonth.getInviteTenderMoney()).divide(oldMonth.getInviteTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }

        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setInquiryTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setInquiryTenderRate(nowMonth.getInquiryTenderMoney().subtract(oldMonth.getInquiryTenderMoney()).divide(oldMonth.getInquiryTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }

        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setUrgentTenderRate(BigDecimal.ZERO);
        }
        else {
            if(BigDecimal.ZERO.compareTo(oldMonth.getUrgentTenderMoney())==0){
                rate.setUrgentTenderRate(BigDecimal.ZERO);
            }else{
                rate.setUrgentTenderRate(nowMonth.getUrgentTenderMoney().subtract(oldMonth.getUrgentTenderMoney()).divide(oldMonth.getUrgentTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));
            }
        }

        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setOtherTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setOtherTenderRate(nowMonth.getOtherTenderMoney().subtract(oldMonth.getOtherTenderMoney()).divide(oldMonth.getOtherTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }
        bidDataVOMap.put("nowMonth",nowMonth);
        bidDataVOMap.put("oldMonth",oldMonth);
        bidDataVOMap.put("rate",rate);

        return bidDataVOMap;
    }

    public static BigDecimal calculateMoney(List<ReportVO> list, String tenderTypeName, Date firstDayOfMonth,Date lastDayOfMonth) {
        List<ReportVO> list1;
        if (firstDayOfMonth != null && lastDayOfMonth != null){
             list1 = list.stream().filter(item ->item.getTenderTypeName()!= null && item.getTenderTypeName().equals(tenderTypeName) &&  !item.getCreateDate().after(lastDayOfMonth) && !item.getCreateDate().before(firstDayOfMonth) ).collect(Collectors.toList());
        }else {
             list1 = list.stream().filter(item ->item.getTenderTypeName()!= null && item.getTenderTypeName().equals(tenderTypeName)).collect(Collectors.toList());
        }
        BigDecimal sumTaxMoney = BigDecimal.ZERO;
        //将list里的金额合并
        if (CollectionUtils.isNotEmpty(list1)) {
            for (ReportVO reportVO : list1) {
//                if (reportVO.getEstablishType()==1){
//                    if (reportVO.getLineTypeName().equals("分包招标")){
//                        reportVO.setTaxMoney(reportVO.getTenderMoney());
//                    }else {
//                        reportVO.setTaxMoney(reportVO.getTaxMoney());
//                    }
//                }
                sumTaxMoney = MathUtil.safeAdd(sumTaxMoney, reportVO.getTaxMoney());
            }
        }
        return sumTaxMoney;
    }
}
